/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.window;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import open.batoru.core.Disposable;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.DataTable;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UIConst;

public class OverlayWindowChoiceDistribute
extends OverlayWindow {
    private static final int INTERVAL = 1000;
    private static final Color[] COLORS = new Color[]{Color.rgb((int)100, (int)20, (int)20), Color.rgb((int)20, (int)100, (int)20), Color.rgb((int)20, (int)20, (int)100), Color.rgb((int)100, (int)20, (int)100)};
    private final SplitPane splitPane;
    private final int total;
    private final int sign;
    private final int numCards;
    private final List<CardEntry> entries = new ArrayList<CardEntry>();
    private final List<ChangeListener<Number>> dividerListeners = new ArrayList<ChangeListener<Number>>();

    public OverlayWindowChoiceDistribute(DataTable<CardIndex> data, int total) {
        super(LanguageParser.getString("UI_GAME_WINDOW_DISTRIBUTE_TITLE"), null);
        this.total = total;
        this.sign = total < 0 ? -1 : 1;
        this.numCards = data.size();
        this.splitPane = new SplitPane();
        this.splitPane.setBackground(UIConst.Style.BACKGROUND_GREY);
        this.splitPane.setMinHeight(20.0);
        HBox contentCards = new HBox();
        contentCards.setAlignment(Pos.CENTER);
        contentCards.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        contentCards.setSpacing(5.0);
        for (int i = 0; i < this.numCards; ++i) {
            CardEntry entry = new CardEntry(data.get(i));
            entry.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)COLORS[i], BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderStroke.THIN)}));
            HBox.setHgrow((Node)entry, (Priority)Priority.ALWAYS);
            contentCards.getChildren().add((Object)entry);
            this.entries.add(entry);
            StackPane splitItem = new StackPane();
            splitItem.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)COLORS[i], CornerRadii.EMPTY, Insets.EMPTY)}));
            this.splitPane.getItems().add((Object)splitItem);
        }
        this.setInitialValues();
        if (this.entries.size() > 1) {
            this.splitPane.setDividerPositions(new double[]{this.entries.getFirst().getRatio(), this.entries.getFirst().getRatio() + this.entries.get(1).getRatio()});
        }
        Text textTotal = OverlayWindowChoiceDistribute.createText(total < 0 ? Color.RED : Color.LIGHTGREEN, 20, (String)(total < 0 ? String.valueOf(total) : "+" + total));
        Text textArrows = OverlayWindowChoiceDistribute.createText(Color.WHITE, 20, "\ud83e\udc57   " + (this.numCards >= 3 ? "\ud83e\udc53   \ud83e\udc56" : "\ud83e\udc56"));
        VBox.setMargin((Node)textArrows, (Insets)new Insets(-10.0, 0.0, 0.0, 0.0));
        Text textInfo = OverlayWindowChoiceDistribute.createText(Color.WHITE, 12, "\ud83e\udc14 " + LanguageParser.getString("UI_GAME_WINDOW_DISTRIBUTE_DESC_HINT") + " \ud83e\udc16");
        int i = 0;
        while (i < this.splitPane.getDividers().size()) {
            int id = i++;
            ChangeListener listener = (ov, oldValue, newValue) -> {
                double nextRatio;
                double ratio = newValue.doubleValue();
                double prevRatio = id > 0 ? this.entries.get(id - 1).getRatio() : 0.0;
                double d = nextRatio = id < this.splitPane.getDividers().size() - 1 ? ((SplitPane.Divider)this.splitPane.getDividers().get(id + 1)).getPosition() : 1.0;
                if (ratio < prevRatio + 0.01 || ratio > nextRatio - 0.01) {
                    return;
                }
                double diff = ratio - prevRatio;
                this.entries.get(id).setRatio(diff);
                double valDiff = oldValue.doubleValue() - ratio;
                this.entries.get(id + 1).setRatio(this.entries.get(id + 1).getRatio() + valDiff);
                this.updateValues();
            };
            ((SplitPane.Divider)this.splitPane.getDividers().get(id)).positionProperty().addListener(listener);
            this.dividerListeners.add((ChangeListener<Number>)listener);
        }
        this.getContentNode().getChildren().addAll((Object[])new Node[]{textTotal, textArrows, contentCards, this.splitPane, textInfo});
    }

    private void setInitialValues() {
        int tempTotal = this.total;
        for (int i = 0; i < this.numCards; ++i) {
            int value = i != this.numCards - 1 ? Math.round((float)(this.total / this.numCards) / 1000.0f) * 1000 : tempTotal;
            this.entries.get(i).setDiff(value);
            this.entries.get(i).setRatio((double)value / (double)this.total);
            tempTotal -= value;
        }
    }

    private void updateValues() {
        int tempTotal = this.total;
        double prevRatio = 0.0;
        for (int i = 0; i < this.numCards; ++i) {
            int value = i != this.numCards - 1 ? (int)Math.round((this.entries.get(i).getRatio() - prevRatio) * (double)this.total / 1000.0) * 1000 : tempTotal;
            this.entries.get(i).setDiff(value);
            if (i > 0) {
                prevRatio = this.entries.get(i).getRatio();
            }
            tempTotal -= value;
        }
    }

    public void setLock(boolean set) {
        this.splitPane.setDisable(set);
    }

    public String exportChoicesAsPacketData() {
        return this.entries.stream().map(entry -> Integer.toString(entry.getDiff())).collect(Collectors.joining("|"));
    }

    public void applyChoicesToDataTable(DataTable<Integer> data) {
        for (CardEntry entry : this.entries) {
            data.add(entry.getDiff());
        }
    }

    @Override
    public void forceFakeChoice(List<String> choices) {
        for (int i = 0; i < this.entries.size(); ++i) {
            this.entries.get(i).setDiff(Integer.parseInt(choices.get(i)));
        }
        super.forceFakeChoice(choices);
    }

    @Override
    public void dispose() {
        super.dispose();
        for (int i = 0; i < this.splitPane.getDividers().size(); ++i) {
            ((SplitPane.Divider)this.splitPane.getDividers().get(i)).positionProperty().removeListener(this.dividerListeners.get(i));
        }
        this.dividerListeners.clear();
        for (CardEntry entry : this.entries) {
            entry.dispose();
        }
        this.entries.clear();
    }

    private class CardEntry
    extends VBox
    implements Disposable {
        private static final int INFINITE = -1;
        private final Text textDiff;
        private final Text textNewValue;
        private Text textIconKill;
        private final ImageView imageCard;
        private final HBox containerDiff = new HBox();
        private final int initialValue;
        private int diff;
        private double ratio;

        public CardEntry(CardIndex cardIndex) {
            this.setAlignment(Pos.CENTER);
            this.setPadding(new Insets(5.0));
            this.setSpacing(5.0);
            double power = cardIndex.getIndexedInstance().getPower().getValue();
            this.initialValue = power != Double.POSITIVE_INFINITY ? (int)power : -1;
            Text textInitialValue = OverlayWindow.createText(Color.WHITE, 14, this.initialValue != -1 ? String.valueOf(this.initialValue) : "\u221e");
            this.containerDiff.setAlignment(Pos.CENTER);
            this.containerDiff.setSpacing(5.0);
            this.containerDiff.getChildren().add((Object)OverlayWindow.createText(Color.KHAKI, 20, "\u2939"));
            VBox containerDiffValues = new VBox();
            containerDiffValues.setAlignment(Pos.CENTER);
            containerDiffValues.setSpacing(5.0);
            this.textDiff = OverlayWindow.createText(OverlayWindowChoiceDistribute.this.sign == -1 ? Color.RED : Color.LIGHTGREEN, 14, "");
            this.textNewValue = OverlayWindow.createText(Color.KHAKI, 14, this.initialValue != -1 ? "" : "\u221e");
            containerDiffValues.getChildren().addAll((Object[])new Node[]{this.textDiff, this.textNewValue});
            this.containerDiff.getChildren().add((Object)containerDiffValues);
            VBox.setMargin((Node)this.containerDiff, (Insets)new Insets(0.0, 0.0, 0.0, -16.0));
            StackPane containerImage = new StackPane();
            this.imageCard = OverlayWindow.createCardImage(cardIndex);
            containerImage.getChildren().addAll((Object[])new Node[]{this.imageCard});
            if (OverlayWindowChoiceDistribute.this.sign < 0 && this.initialValue != -1) {
                this.textIconKill = new Text("\u2718");
                this.textIconKill.setFont(Font.font((String)"file:fonts/Symbola-12.ttf", (double)64.0));
                this.textIconKill.setFill((Paint)Color.RED);
                this.textIconKill.setStroke((Paint)Color.DARKRED);
                this.textIconKill.setStrokeWidth(3.0);
                containerImage.getChildren().add((Object)this.textIconKill);
            }
            this.getChildren().addAll((Object[])new Node[]{containerImage, textInitialValue, this.containerDiff});
        }

        public void setRatio(double ratio) {
            this.ratio = Math.max(0.0, Math.min(1.0, ratio));
        }

        public double getRatio() {
            return this.ratio;
        }

        public void setDiff(int diff) {
            this.diff = diff;
            this.textDiff.setText(String.valueOf(diff));
            if (this.initialValue != -1) {
                int newValue = this.initialValue + diff * OverlayWindowChoiceDistribute.this.sign;
                this.textNewValue.setText(String.valueOf(newValue));
                this.textNewValue.setFill((Paint)(newValue > 0 ? Color.KHAKI : Color.RED));
                if (this.textIconKill != null) {
                    this.textIconKill.setVisible(newValue <= 0);
                }
            }
            this.containerDiff.setVisible(diff != 0);
        }

        public int getDiff() {
            return this.diff;
        }

        @Override
        public void dispose() {
            this.imageCard.setOnMouseEntered(null);
        }
    }
}

