/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.window;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.HBox;
import javafx.scene.web.WebView;
import open.batoru.catalog.description.DescriptionParser;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.ModalChoiceRepeatTracker;
import open.batoru.game.overlay.OverlayConst;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UIConst;
import open.batoru.ui.UtilDispose;

public class OverlayWindowChoiceMode
extends OverlayWindow {
    private final int minPicks;
    private final int maxPicks;
    private final int bitsDisabled;
    private final ModalChoiceRepeatTracker repeatChoiceTracker;
    private int pickedModes;
    private int pickedCount;
    private boolean isLocked;

    public OverlayWindowChoiceMode(int minPicks, int maxPicks, Ability ability, int bitsDisabled, ModalChoiceRepeatTracker repeatChoiceTracker) {
        super(LanguageParser.getString("UI_GAME_WINDOW_MODE_TITLE"), (String)((Object)(minPicks > 1 || maxPicks > minPicks ? "0 / " + maxPicks : null)));
        this.minPicks = minPicks;
        this.maxPicks = maxPicks;
        this.bitsDisabled = bitsDisabled;
        this.repeatChoiceTracker = repeatChoiceTracker;
        String description = ability.getCachedAbilityDescription();
        StringBuilder descriptionMode = new StringBuilder();
        int currentMode = -1;
        for (int i = 0; i < description.length(); ++i) {
            int c0 = i > 0 ? (int)description.charAt(i - 1) : 48;
            char c1 = description.charAt(i);
            int c2 = 48;
            if (i != description.length() - 1) {
                c2 = description.charAt(i + 1);
            }
            if ((c0 == 10 || c0 == 64 || c0 == 48) && c1 == '$' && c2 == 36) {
                if (!descriptionMode.isEmpty()) {
                    this.addMode(currentMode, descriptionMode.toString());
                    descriptionMode = new StringBuilder();
                }
                ++currentMode;
            }
            if (currentMode == -1) continue;
            descriptionMode.append(c1);
        }
        if (!descriptionMode.isEmpty()) {
            this.addMode(currentMode, descriptionMode.toString());
        }
        this.getConfirmButton().setText(minPicks > 0 ? OverlayConst.BUTTON_TEXT_CONFIRM : OverlayConst.BUTTON_TEXT_SKIP);
        if (minPicks > 0) {
            this.getConfirmButton().setDisable(true);
        }
        if (minPicks == 1 && maxPicks == 1) {
            this.hideConfirmButton();
        }
    }

    private void addMode(int modeId, String stringAbilityMode) {
        ArrayList<CheckBox> repeatCheckboxes;
        HBox container = new HBox();
        container.setAlignment(Pos.CENTER);
        container.setSpacing(10.0);
        WebView descriptionWebView = new WebView();
        descriptionWebView.setContextMenuEnabled(false);
        descriptionWebView.getEngine().setJavaScriptEnabled(false);
        descriptionWebView.setMaxSize(300.0, 80.0);
        descriptionWebView.getEngine().loadContent(DescriptionParser.DEFAULT.parseDescription(stringAbilityMode));
        container.getChildren().add((Object)descriptionWebView);
        if ((this.bitsDisabled & 1 << modeId) == 0) {
            container.setOnMouseEntered(e -> {
                if (this.isLocked || (this.pickedModes & 1 << modeId) != 0) {
                    return;
                }
                container.setBackground(UIConst.Style.BACKGROUND_HOVER);
            });
            container.setOnMouseExited(e -> {
                if (this.isLocked || (this.pickedModes & 1 << modeId) != 0) {
                    return;
                }
                container.setBackground(UIConst.Style.BACKGROUND_TRANSPARENT);
            });
            if (this.repeatChoiceTracker != null) {
                repeatCheckboxes = new ArrayList<CheckBox>();
                HBox containerRepeat = new HBox();
                containerRepeat.setAlignment(Pos.CENTER);
                containerRepeat.setSpacing(5.0);
                int i = 0;
                while (i < this.maxPicks) {
                    CheckBox checkBox = new CheckBox();
                    checkBox.setDisable(true);
                    repeatCheckboxes.add(checkBox);
                    int refI = i++;
                    checkBox.setOnAction(e -> {
                        if (checkBox.isSelected()) {
                            ++this.pickedCount;
                            this.repeatChoiceTracker.incrementChoiceRepeats(modeId, 1);
                            for (int ii = refI - 1; ii >= 1 && !((CheckBox)repeatCheckboxes.get(ii)).isSelected(); --ii) {
                                ((CheckBox)repeatCheckboxes.get(ii)).setSelected(true);
                                ++this.pickedCount;
                                this.repeatChoiceTracker.incrementChoiceRepeats(modeId, 1);
                            }
                        } else {
                            --this.pickedCount;
                            this.repeatChoiceTracker.incrementChoiceRepeats(modeId, -1);
                            for (int ii = refI + 1; ii < repeatCheckboxes.size() && ((CheckBox)repeatCheckboxes.get(ii)).isSelected(); ++ii) {
                                ((CheckBox)repeatCheckboxes.get(ii)).setSelected(false);
                                --this.pickedCount;
                                this.repeatChoiceTracker.incrementChoiceRepeats(modeId, -1);
                            }
                        }
                        this.updatePickedCount();
                    });
                    containerRepeat.getChildren().add((Object)checkBox);
                }
                container.getChildren().add((Object)containerRepeat);
            } else {
                repeatCheckboxes = null;
            }
            container.setOnMouseClicked(e -> {
                if (this.isLocked) {
                    return;
                }
                if ((this.pickedModes & 1 << modeId) == 0) {
                    this.pickedModes |= 1 << modeId;
                    ++this.pickedCount;
                    container.setBackground(UIConst.Style.BACKGROUND_MID);
                    if (repeatCheckboxes != null) {
                        ((CheckBox)repeatCheckboxes.getFirst()).setSelected(true);
                        for (int i = 1; i < repeatCheckboxes.size(); ++i) {
                            ((CheckBox)repeatCheckboxes.get(i)).setDisable(false);
                        }
                    }
                } else {
                    this.pickedModes &= ~(1 << modeId);
                    --this.pickedCount;
                    container.setBackground(UIConst.Style.BACKGROUND_HOVER);
                    if (repeatCheckboxes != null) {
                        for (int i = 0; i < repeatCheckboxes.size(); ++i) {
                            ((CheckBox)repeatCheckboxes.get(i)).setDisable(true);
                            if (i > 0 && ((CheckBox)repeatCheckboxes.get(i)).isSelected()) {
                                --this.pickedCount;
                                this.repeatChoiceTracker.incrementChoiceRepeats(modeId, -1);
                            }
                            ((CheckBox)repeatCheckboxes.get(i)).setSelected(false);
                        }
                    }
                }
                this.updatePickedCount();
            });
        } else {
            container.setOpacity(0.75);
            repeatCheckboxes = null;
        }
        UtilDispose.TEMP.setOnDisposed((Node)container, () -> {
            container.setOnMouseEntered(null);
            container.setOnMouseExited(null);
            container.setOnMouseClicked(null);
            if (repeatCheckboxes != null) {
                for (CheckBox checkBox : repeatCheckboxes) {
                    checkBox.setOnAction(null);
                }
            }
        });
        this.getContentNode().getChildren().add((Object)container);
    }

    public int getPickedModes() {
        return this.pickedModes;
    }

    public void setLock(boolean lock) {
        this.isLocked = lock;
    }

    private void updatePickedCount() {
        if (this.minPicks == 0) {
            this.getConfirmButton().setText(this.pickedCount > 0 ? OverlayConst.BUTTON_TEXT_CONFIRM : OverlayConst.BUTTON_TEXT_SKIP);
        }
        this.getConfirmButton().setDisable(this.minPicks > 0 && this.pickedCount < this.minPicks || this.pickedCount > this.maxPicks);
        if (this.minPicks == 1 && this.maxPicks == 1) {
            this.getConfirmButton().fire();
        } else if (this.minPicks > 1 || this.maxPicks > 1) {
            this.updateDescriptionText(this.pickedCount + " / " + this.maxPicks);
        }
    }

    @Override
    public void forceFakeChoice(List<String> choices) {
        this.pickedModes = Integer.parseInt(choices.getFirst());
        if (this.repeatChoiceTracker != null && choices.size() >= 3) {
            for (int i = 1; i < choices.size(); i += 2) {
                int modeId = Integer.parseInt(choices.get(i));
                int repeats = Integer.parseInt(choices.get(i + 1));
                this.repeatChoiceTracker.incrementChoiceRepeats(modeId, repeats);
            }
        }
        this.getConfirmButton().setDisable(false);
        super.forceFakeChoice(choices);
    }

    @Override
    public void dispose() {
        super.dispose();
        UtilDispose.TEMP.attachChildDisposeListener((Node)this.getContentNode());
        this.getContentNode().getChildren().clear();
        UtilDispose.TEMP.detachChildDisposeListener((Node)this.getContentNode());
    }
}

