/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.window;

import java.util.List;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.web.WebView;
import open.batoru.ImageCache;
import open.batoru.catalog.description.DescriptionParser;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.CardConst;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityCondition;
import open.batoru.data.ability.CheckZoneAbility;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.cost.CoinCost;
import open.batoru.game._3d.textures.UtilTexture;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowChoiceEffect;
import open.batoru.game.overlay.window.OverlayWindowWarnConfirmation;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;
import open.batoru.ui.UIConst;
import open.batoru.ui.UtilDispose;

public class OverlayWindowEffectActivateAction
extends OverlayWindowChoiceEffect {
    public OverlayWindowEffectActivateAction(List<Ability> listAbilities) {
        super(LanguageParser.getString("UI_GAME_WINDOW_ABILITY_TITLE_ACTION"), LanguageParser.getString("UI_GAME_WINDOW_ABILITY_DESC_ACTION"));
        for (int i = 0; i < listAbilities.size(); ++i) {
            this.addAbility(i, listAbilities.get(i));
        }
        this.getConfirmButton().setText(LanguageParser.getString("UI_GAME_WINDOW_BUTTON_CANCEL"));
    }

    private void addAbility(int arrayId, Ability ability) {
        ImageView imageCard;
        HBox container = new HBox();
        container.setAlignment(Pos.CENTER);
        container.setSpacing(10.0);
        WebView descriptionWebView = new WebView();
        descriptionWebView.setContextMenuEnabled(false);
        descriptionWebView.getEngine().setJavaScriptEnabled(false);
        descriptionWebView.setMaxSize(400.0, 80.0);
        if (ability.getSourceCardIndex().getLocation() != GameConst.CardLocation.DECK_LRIG) {
            descriptionWebView.getEngine().loadContent(DescriptionParser.DEFAULT.parseDescription(DescriptionParser.getAbilityDescription(ability)));
        } else {
            descriptionWebView.getEngine().loadContent(DescriptionParser.DEFAULT.parseDescription(ability.getSourceCardIndex(), false));
        }
        if (!GameConst.CardLocation.isOnField(ability.getSourceCardIndex().getLocation())) {
            CardIndex cardIndex;
            CheckZoneAbility checkZoneAbility;
            StackPane containerImage = new StackPane();
            imageCard = OverlayWindowEffectActivateAction.createCardImage(ability.getSourceCardIndex());
            containerImage.getChildren().add((Object)imageCard);
            if (ability instanceof CheckZoneAbility && (checkZoneAbility = (CheckZoneAbility)ability).getReductionForcedPaymentMinCount() > 0) {
                ImageView imageCostIcon;
                VBox containerWarnForcedReduction = new VBox();
                containerWarnForcedReduction.setAlignment(Pos.CENTER);
                containerWarnForcedReduction.setPadding(new Insets(5.0));
                Text textMinRequiredPayment = new Text(checkZoneAbility.getReductionForcedPaymentMinCount() + "\u00d7");
                textMinRequiredPayment.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)32.0));
                textMinRequiredPayment.setFill((Paint)Color.RED);
                textMinRequiredPayment.setStroke((Paint)Color.BLACK);
                textMinRequiredPayment.setStrokeWidth(1.0);
                AbilityCost reductionCost = checkZoneAbility.getReductionPayCostList().getDataArray().getFirst();
                if (!(reductionCost instanceof CoinCost)) {
                    imageCostIcon = new ImageView((Image)UtilTexture.colorize(ImageCache.INSTANCE.getImage(ImageCache.getBorderIconTexturePath(reductionCost.getDefaultTargetHintType())), Color.RED));
                    imageCostIcon.setFitWidth(48.0);
                    imageCostIcon.setFitHeight(48.0);
                } else {
                    imageCostIcon = new ImageView(ImageCache.INSTANCE.getImageIcon("coin"));
                }
                containerWarnForcedReduction.getChildren().addAll((Object[])new Node[]{textMinRequiredPayment, imageCostIcon});
                containerImage.getChildren().add((Object)containerWarnForcedReduction);
            }
            if (((cardIndex = ability.getSourceCardIndex()).getLocation() != GameConst.CardLocation.DECK_LRIG || cardIndex.getCardReference().getType() == CardConst.CardType.ARTS || cardIndex.getCardReference().getType() == CardConst.CardType.PIECE) && ability.getConditionState(cardIndex) == AbilityCondition.ConditionState.WARN) {
                ImageView iconWarn = new ImageView(ImageCache.INSTANCE.getImageIcon("restrict/warning"));
                containerImage.getChildren().add((Object)iconWarn);
            }
            container.getChildren().addAll((Object[])new Node[]{containerImage, descriptionWebView});
        } else if (ability.getConditionState(ability.getSourceCardIndex()) == AbilityCondition.ConditionState.WARN) {
            ImageView iconWarn = new ImageView(ImageCache.INSTANCE.getImageIcon("restrict/warning"));
            StackPane containerDescription = new StackPane();
            containerDescription.getChildren().addAll((Object[])new Node[]{descriptionWebView, iconWarn});
            descriptionWebView.setOpacity(0.5);
            container.getChildren().add((Object)containerDescription);
            imageCard = null;
        } else {
            container.getChildren().add((Object)descriptionWebView);
            imageCard = null;
        }
        container.setOnMouseEntered(e -> {
            if (this.isLocked()) {
                return;
            }
            container.setBackground(UIConst.Style.BACKGROUND_HOVER);
            UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(ability.getSourceCardIndex());
        });
        container.setOnMouseExited(e -> {
            if (this.isLocked()) {
                return;
            }
            container.setBackground(UIConst.Style.BACKGROUND_TRANSPARENT);
        });
        container.setOnMouseClicked(e -> {
            if (this.isLocked() || this.getOnAbilityChosenHandler() == null) {
                return;
            }
            CardIndex cardIndex = ability.getSourceCardIndex();
            if (cardIndex.getLocation() == GameConst.CardLocation.DECK_LRIG && cardIndex.getCardReference().getType() != CardConst.CardType.ARTS && cardIndex.getCardReference().getType() != CardConst.CardType.PIECE || ability.getConditionState(cardIndex) != AbilityCondition.ConditionState.WARN) {
                this.getOnAbilityChosenHandler().handle(arrayId);
                this.setLock(true);
            } else {
                OverlayWindowWarnConfirmation windowWarn = this.getOverlayWindowEffectWarnConfirmation(arrayId);
                windowWarn.setAlias("warn");
                OverlayWindow.hideWindow(this);
                OverlayWindow.addToFieldOverlay(windowWarn);
            }
        });
        UtilDispose.TEMP.setOnDisposed((Node)container, () -> {
            container.setOnMouseEntered(null);
            container.setOnMouseExited(null);
            container.setOnMouseClicked(null);
            if (imageCard != null) {
                imageCard.setOnMouseEntered(null);
            }
        });
        this.getContentNode().getChildren().add((Object)container);
    }

    private OverlayWindowWarnConfirmation getOverlayWindowEffectWarnConfirmation(int arrayId) {
        OverlayWindowWarnConfirmation windowWarn = new OverlayWindowWarnConfirmation(LanguageParser.getString("UI_GAME_WINDOW_ABILITY_DESC_WARN"));
        windowWarn.setOnConfirm(isConfirmed -> {
            OverlayWindow.removeFromFieldOverlay(windowWarn);
            if (isConfirmed) {
                this.getOnAbilityChosenHandler().handle(arrayId);
                this.setLock(true);
            } else {
                OverlayWindow.showWindow(this);
            }
        });
        return windowWarn;
    }

    @Override
    public void dispose() {
        super.dispose();
        UtilDispose.TEMP.attachChildDisposeListener((Node)this.getContentNode());
        this.getContentNode().getChildren().clear();
        UtilDispose.TEMP.detachChildDisposeListener((Node)this.getContentNode());
    }
}

