/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.window;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.web.WebView;
import open.batoru.ImageCache;
import open.batoru.catalog.description.DescriptionParser;
import open.batoru.core.Disposable;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.rulechecks.CostRuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.CardConst;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.LifeBurstAbility;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.game._3d.textures.UtilTexture;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.parsers.LanguageParser;

public class OverlayWindowEffectDecideLifeBurst
extends OverlayWindow {
    private final List<LifeBurstEntry> entries = new ArrayList<LifeBurstEntry>();
    private final Button buttonSkip;
    private List<Integer> fakeDecidedData;

    public OverlayWindowEffectDecideLifeBurst(List<CardIndex> listCards) {
        super(LanguageParser.getString("UI_GAME_WINDOW_LIFEBURST_TITLE"), LanguageParser.getString("UI_GAME_WINDOW_LIFEBURST_DESC"));
        for (CardIndex cardIndex : listCards) {
            List<Ability> abilitiesLB = cardIndex.getIndexedInstance().getAbilityList().stream().filter(LifeBurstAbility.class::isInstance).toList();
            if (abilitiesLB.isEmpty()) continue;
            LifeBurstEntry entry = new LifeBurstEntry(cardIndex, abilitiesLB);
            this.getContentNode().getChildren().add((Object)entry);
            this.entries.add(entry);
        }
        this.buttonSkip = OverlayWindowEffectDecideLifeBurst.createButton(LanguageParser.getString("UI_GAME_WINDOW_BUTTON_SKIP"));
        this.addWindowButton(this.buttonSkip);
    }

    public Button getSkipButton() {
        return this.buttonSkip;
    }

    public void setLock(boolean set) {
        for (LifeBurstEntry entry : this.entries) {
            entry.setLock(set);
        }
    }

    public void deselectAll() {
        for (LifeBurstEntry entry : this.entries) {
            entry.deselectAll();
        }
    }

    public List<Integer> getDecidedData() {
        if (this.fakeDecidedData != null) {
            return this.fakeDecidedData;
        }
        ArrayList<Integer> data = new ArrayList<Integer>();
        for (LifeBurstEntry entry : this.entries) {
            entry.forEachLifeBurst(isSelected -> data.add(isSelected != false ? 1 : 0));
        }
        return data;
    }

    @Override
    public void forceFakeChoice(List<String> choices) {
        this.fakeDecidedData = new ArrayList<Integer>();
        for (int i = 1; i < choices.size(); ++i) {
            this.fakeDecidedData.add(Integer.parseInt(choices.get(i)));
        }
        super.forceFakeChoice(choices);
    }

    @Override
    public void dispose() {
        for (LifeBurstEntry entry : this.entries) {
            entry.dispose();
        }
        super.dispose();
    }

    private static class LifeBurstEntry
    extends HBox
    implements Disposable {
        private final ImageView imageCard;
        private final List<CheckBox> listControls = new ArrayList<CheckBox>();
        private int numSelected;

        public LifeBurstEntry(CardIndex cardIndex, List<Ability> abilitiesLB) {
            this.setAlignment(Pos.TOP_CENTER);
            this.setSpacing(10.0);
            StackPane containerImage = new StackPane();
            this.imageCard = OverlayWindow.createCardImage(cardIndex);
            containerImage.getChildren().add((Object)this.imageCard);
            VBox contentLB = new VBox();
            contentLB.setAlignment(Pos.TOP_CENTER);
            contentLB.setSpacing(10.0);
            boolean isEnabled = true;
            CostRuleCheck costRuleCheckUseLB = (CostRuleCheck)cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.COST_TO_USE_LB);
            List<AbilityCostList> dataCostListsUseLB = ((AbilityCost)costRuleCheckUseLB.check(cardIndex)).getSourceCostList().getSourceDataCostLists();
            if (!dataCostListsUseLB.isEmpty()) {
                if (!AbilityCostList.canPayDataCostLists(dataCostListsUseLB)) {
                    isEnabled = false;
                }
                StackPane containerCost = new StackPane();
                ImageView imageCostIcon = new ImageView((Image)UtilTexture.colorize(ImageCache.INSTANCE.getImage(ImageCache.getColorTexturePath(CardConst.CardColor.getColorByShortLabel(CardConst.CardColor.COLORLESS.getShortLabel()))), Color.RED));
                imageCostIcon.setFitWidth(36.0);
                imageCostIcon.setFitHeight(36.0);
                containerCost.getChildren().add((Object)imageCostIcon);
                containerImage.getChildren().add((Object)containerCost);
            }
            for (Ability ability : abilitiesLB) {
                HBox containerAbility = new HBox();
                containerAbility.setAlignment(Pos.CENTER_LEFT);
                containerAbility.setSpacing(10.0);
                CheckBox checkBox = new CheckBox();
                this.listControls.add(checkBox);
                WebView descriptionWebView = new WebView();
                descriptionWebView.setContextMenuEnabled(false);
                descriptionWebView.getEngine().setJavaScriptEnabled(false);
                descriptionWebView.setMaxSize(400.0, 80.0);
                descriptionWebView.getEngine().loadContent(DescriptionParser.DEFAULT.parseDescription(DescriptionParser.getAbilityDescription(ability)));
                checkBox.setOnAction(e -> {
                    descriptionWebView.setOpacity(checkBox.isSelected() ? 1.0 : 0.33);
                    this.numSelected += checkBox.isSelected() ? 1 : -1;
                    this.imageCard.setOpacity(this.numSelected > 0 ? 1.0 : 0.75);
                });
                if (isEnabled) {
                    checkBox.setSelected(true);
                    ++this.numSelected;
                } else {
                    checkBox.setDisable(true);
                    descriptionWebView.setOpacity(0.33);
                }
                containerAbility.getChildren().addAll((Object[])new Node[]{checkBox, descriptionWebView});
                contentLB.getChildren().add((Object)containerAbility);
            }
            if (this.numSelected == 0) {
                this.imageCard.setOpacity(0.75);
            }
            this.getChildren().addAll((Object[])new Node[]{containerImage, contentLB});
        }

        public void setLock(boolean set) {
            for (CheckBox checkBox : this.listControls) {
                checkBox.setDisable(set);
            }
        }

        public void deselectAll() {
            for (CheckBox checkBox : this.listControls) {
                checkBox.setSelected(false);
            }
        }

        public void forEachLifeBurst(Consumer<Boolean> handler) {
            for (CheckBox checkBox : this.listControls) {
                handler.accept(checkBox.isSelected());
            }
        }

        @Override
        public void dispose() {
            for (CheckBox checkBox : this.listControls) {
                checkBox.setOnAction(null);
            }
            this.imageCard.setOnMouseEntered(null);
        }
    }
}

