/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.window;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.web.WebView;
import open.batoru.ImageCache;
import open.batoru.Settings;
import open.batoru.catalog.description.DescriptionParser;
import open.batoru.core.Game;
import open.batoru.core.gameplay.EffectBucket;
import open.batoru.data.CircularList;
import open.batoru.data.ability.Ability;
import open.batoru.game.FieldZone;
import open.batoru.game.Zone;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;
import open.batoru.ui.UIConst;
import open.batoru.ui.UtilDispose;

public class OverlayWindowEffectReorder
extends OverlayWindow {
    private final List<Button> cacheButtons = new ArrayList<Button>();
    private final CircularList<HBox> entries = new CircularList();
    private final VBox scrollContent = new VBox();
    private final CheckBox checkBoxShouldReorderAtOnce;
    private boolean isLocked;
    private List<Integer> fakeOrderDiff;

    public OverlayWindowEffectReorder() {
        super(LanguageParser.getString("UI_GAME_WINDOW_REORDER_TITLE"), " ");
        StackPane containerCheckBox = new StackPane();
        containerCheckBox.setAlignment(Pos.CENTER_RIGHT);
        containerCheckBox.setPadding(new Insets(0.0, 5.0, 0.0, 0.0));
        this.checkBoxShouldReorderAtOnce = new CheckBox(LanguageParser.getString("UI_GAME_WINDOW_CHECKBOX_DONTASK"));
        this.checkBoxShouldReorderAtOnce.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)12.0));
        this.checkBoxShouldReorderAtOnce.setTextFill((Paint)Color.KHAKI);
        this.checkBoxShouldReorderAtOnce.setOnAction(e -> {
            Settings.INSTANCE.setShouldReorderAtOnce(this.checkBoxShouldReorderAtOnce.isSelected());
            Game.getCurrentGame().getOwnPlayerData().setShouldReorderEffectsAtOnce(this.checkBoxShouldReorderAtOnce.isSelected());
            this.reset();
        });
        containerCheckBox.getChildren().add((Object)this.checkBoxShouldReorderAtOnce);
        this.getContentNode().getChildren().add((Object)containerCheckBox);
        this.getConfirmButton().visibleProperty().bind((ObservableValue)this.checkBoxShouldReorderAtOnce.selectedProperty());
        this.getConfirmButton().managedProperty().bind((ObservableValue)this.checkBoxShouldReorderAtOnce.selectedProperty());
        this.scrollContent.setSpacing(10.0);
        UtilDispose.TEMP.attachChildDisposeListener((Node)this.scrollContent);
        ScrollPane scroll = new ScrollPane((Node)this.scrollContent);
        scroll.setStyle("-fx-background: transparent; -fx-background-color: transparent;");
        scroll.setMaxHeight(500.0);
        scroll.setFitToWidth(true);
        scroll.setFitToHeight(true);
        this.getContentNode().getChildren().add((Object)scroll);
        this.reset();
        this.cacheButtons.add(this.getConfirmButton());
    }

    private void reset() {
        this.entries.clear();
        this.checkBoxShouldReorderAtOnce.setSelected(Game.getCurrentGame().getOwnPlayerData().shouldReorderEffectsAtOnce() || Settings.INSTANCE.shouldReorderAtOnce());
        this.updateDescriptionText(LanguageParser.getString(this.checkBoxShouldReorderAtOnce.isSelected() ? "UI_GAME_WINDOW_REORDER_TITLE_DESC_ATONCE" : "UI_GAME_WINDOW_REORDER_TITLE_DESC_NEXT"));
        this.scrollContent.getChildren().clear();
        EffectBucket playerBucket = Game.getCurrentGame().getGameRules().getEffectProcessor().getPlayerBucket(Game.getCurrentGame().getPlayerRole());
        for (int i = playerBucket.getCompletedEffectsNum(); i < playerBucket.getAbilitiesNum(); ++i) {
            HBox entry = this.newAbilityEntry(playerBucket.getAbilityList().get(i));
            this.entries.add(entry);
            this.scrollContent.getChildren().add((Object)entry);
        }
    }

    private HBox newAbilityEntry(Ability ability) {
        Button buttonDown;
        Button buttonUp;
        HBox container = new HBox();
        container.setAlignment(Pos.CENTER);
        container.setSpacing(10.0);
        String imageSet = ability.getSourceCardIndex().getImageSet();
        ImageView imageCard = new ImageView(ImageCache.INSTANCE.getCardImage(imageSet != null ? imageSet : ability.getCachedSourceCardImageSet()));
        imageCard.setFitWidth(63.0);
        imageCard.setFitHeight(87.0);
        Rectangle clip = new Rectangle(63.0, 87.0);
        clip.setArcWidth(9.0);
        clip.setArcHeight(9.0);
        imageCard.setClip((Node)clip);
        container.getChildren().add((Object)imageCard);
        if (this.checkBoxShouldReorderAtOnce.isSelected()) {
            VBox boxButtons = new VBox();
            boxButtons.setSpacing(10.0);
            boxButtons.setAlignment(Pos.CENTER);
            buttonUp = OverlayWindowEffectReorder.createButton("\u25b2");
            buttonUp.setPadding(Insets.EMPTY);
            buttonUp.setMinSize(24.0, 24.0);
            buttonUp.setMaxSize(24.0, 24.0);
            buttonDown = OverlayWindowEffectReorder.createButton("\u25bc");
            buttonDown.setPadding(Insets.EMPTY);
            buttonDown.setMinSize(24.0, 24.0);
            buttonDown.setMaxSize(24.0, 24.0);
            boxButtons.getChildren().addAll((Object[])new Node[]{buttonUp, buttonDown});
            this.cacheButtons.add(buttonUp);
            this.cacheButtons.add(buttonDown);
            buttonUp.setOnAction(e -> {
                int arrayId = this.scrollContent.getChildren().indexOf((Object)container) - 1;
                if (arrayId < 0) {
                    arrayId = this.scrollContent.getChildren().size() - 1;
                }
                UtilDispose.TEMP.suppressDispose(() -> this.scrollContent.getChildren().remove((Object)container));
                this.scrollContent.getChildren().add(arrayId, (Object)container);
                this.entries.moveBackward(container);
            });
            buttonDown.setOnAction(e -> {
                int arrayId = this.scrollContent.getChildren().indexOf((Object)container) + 1;
                if (arrayId >= this.scrollContent.getChildren().size()) {
                    arrayId = 0;
                }
                UtilDispose.TEMP.suppressDispose(() -> this.scrollContent.getChildren().remove((Object)container));
                this.scrollContent.getChildren().add(arrayId, (Object)container);
                this.entries.moveForward(container);
            });
            container.setOnMouseEntered(e -> {
                UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(ability.getSourceCardIndex());
                Zone patt0$temp = ability.getSourceCardIndex().getZoneByLocation();
                if (patt0$temp instanceof FieldZone) {
                    FieldZone fieldZone = (FieldZone)patt0$temp;
                    fieldZone.installZoneHighlighter();
                }
            });
            container.setOnMouseExited(e -> {
                Zone patt0$temp = ability.getSourceCardIndex().getZoneByLocation();
                if (patt0$temp instanceof FieldZone) {
                    FieldZone fieldZone = (FieldZone)patt0$temp;
                    fieldZone.uninstallZoneHighlighter();
                }
            });
            container.getChildren().add((Object)boxButtons);
        } else {
            container.setOnMouseEntered(e -> {
                UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(ability.getSourceCardIndex());
                Zone patt0$temp = ability.getSourceCardIndex().getZoneByLocation();
                if (patt0$temp instanceof FieldZone) {
                    FieldZone fieldZone = (FieldZone)patt0$temp;
                    fieldZone.installZoneHighlighter();
                }
                if (!this.isLocked) {
                    container.setBackground(UIConst.Style.BACKGROUND_HOVER);
                }
            });
            container.setOnMouseExited(e -> {
                Zone patt0$temp = ability.getSourceCardIndex().getZoneByLocation();
                if (patt0$temp instanceof FieldZone) {
                    FieldZone fieldZone = (FieldZone)patt0$temp;
                    fieldZone.uninstallZoneHighlighter();
                }
                if (!this.isLocked) {
                    container.setBackground(UIConst.Style.BACKGROUND_TRANSPARENT);
                }
            });
            container.setOnMouseClicked(e -> {
                if (this.isLocked) {
                    return;
                }
                UtilDispose.TEMP.suppressDispose(() -> {
                    this.scrollContent.getChildren().remove((Object)container);
                    this.scrollContent.getChildren().addFirst((Object)container);
                });
                this.entries.moveToTop(container);
                this.getConfirmButton().fire();
            });
            buttonDown = null;
            buttonUp = null;
        }
        WebView descriptionWebView = new WebView();
        descriptionWebView.setContextMenuEnabled(false);
        descriptionWebView.getEngine().setJavaScriptEnabled(false);
        descriptionWebView.setMaxSize(300.0, 80.0);
        descriptionWebView.getEngine().loadContent(DescriptionParser.DEFAULT.parseDescription(ability.getCachedAbilityDescription()));
        container.getChildren().add((Object)descriptionWebView);
        UtilDispose.TEMP.setOnDisposed((Node)container, () -> {
            imageCard.setOnMouseEntered(null);
            imageCard.setImage(null);
            container.setOnMouseEntered(null);
            container.setOnMouseExited(null);
            container.setOnMouseClicked(null);
            if (buttonUp != null) {
                buttonUp.setOnAction(null);
            }
            if (buttonDown != null) {
                buttonDown.setOnAction(null);
            }
        });
        return container;
    }

    public void lockControls(boolean set) {
        for (Control control : this.cacheButtons) {
            control.setDisable(set);
        }
        this.checkBoxShouldReorderAtOnce.setDisable(set);
        this.isLocked = set;
    }

    public List<Integer> getAbilityOrderDiffData() {
        if (this.fakeOrderDiff != null) {
            return this.fakeOrderDiff;
        }
        List<HBox> listEntriesOriginal = this.entries.listWithOriginalOrder();
        ArrayList<Integer> listAbilitiesOrderDiff = new ArrayList<Integer>();
        for (HBox entry : listEntriesOriginal) {
            listAbilitiesOrderDiff.add(this.entries.getDiffOf(entry));
        }
        return listAbilitiesOrderDiff;
    }

    @Override
    public void forceFakeChoice(List<String> choices) {
        this.fakeOrderDiff = new ArrayList<Integer>();
        for (String choice : choices) {
            this.fakeOrderDiff.add(Integer.parseInt(choice));
        }
        Game.getCurrentGame().getPlayerGameData(Game.getCurrentGame().getPlayerRole()).setShouldReorderEffectsAtOnce(choices.getLast().equals("1"));
        super.forceFakeChoice(choices);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.entries.clear();
        this.scrollContent.getChildren().clear();
        UtilDispose.TEMP.detachChildDisposeListener((Node)this.scrollContent);
        this.getConfirmButton().visibleProperty().unbind();
        this.getConfirmButton().managedProperty().unbind();
        this.checkBoxShouldReorderAtOnce.setOnAction(null);
    }
}

