/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.window;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import javafx.beans.value.ChangeListener;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import open.batoru.ImageCache;
import open.batoru.Settings;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.pickers.EnerColorPicker;
import open.batoru.core.gameplay.pickers.Picker;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.CardConst;
import open.batoru.data.DataTable;
import open.batoru.game.FieldZoneEnerGroup;
import open.batoru.game._3d.Card3DSubstitute;
import open.batoru.game._3d.EnerColor;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.networking.PacketParser;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UtilDispose;

public class OverlayWindowEnerCost
extends OverlayWindow {
    private final HBox containerCards = new HBox();
    private final Button buttonExpand;
    private String costString;
    private final boolean isMandatory;
    private final List<FieldZoneEnerGroup> listEnerGroups;
    private final Map<String, List<EnerIcon>> mapEnerIcons = new HashMap<String, List<EnerIcon>>();
    private final HBox contentPayEner = new HBox();
    private final DataTable<String> dataAvailablePayCostStrings;
    private ToggleGroup toggleGroup;
    private ChangeListener<Toggle> listenerToggle;
    private List<RadioButton> listRadioButtons;
    private final String buttonTextConfirm = LanguageParser.getString("UI_GAME_WINDOW_BUTTON_CONFIRM");
    private final String buttonTextSkip = LanguageParser.getString("UI_GAME_WINDOW_BUTTON_SKIP");
    private final String buttonTextExpand = "\u21ca " + LanguageParser.getString("UI_GAME_WINDOW_BUTTON_ENER_EXPAND") + " \u21ca";
    private final String buttonTextHide = "\u21c8 " + LanguageParser.getString("UI_GAME_WINDOW_BUTTON_ENER_HIDE") + " \u21c8";
    private int oldPickedCount;
    private int oldRemainingCostLen;
    private OnPayCostChangedHandler handlerOnPayCostChanged;

    public OverlayWindowEnerCost(String title, String description, List<FieldZoneEnerGroup> listEnerGroups, DataTable<String> dataAvailablePayCostStrings, CardIndex cardIndex, boolean isMandatory) {
        super(title, description);
        this.listEnerGroups = listEnerGroups;
        this.dataAvailablePayCostStrings = dataAvailablePayCostStrings;
        this.costString = dataAvailablePayCostStrings.get();
        this.oldRemainingCostLen = this.costString.length();
        this.isMandatory = isMandatory;
        VBox container = new VBox();
        container.setSpacing(25.0);
        container.setPadding(new Insets(0.0, 0.0, 20.0, 0.0));
        StackPane content = new StackPane();
        this.containerCards.setAlignment(Pos.CENTER_RIGHT);
        StackPane.setAlignment((Node)this.containerCards, (Pos)Pos.CENTER_RIGHT);
        StackPane.setMargin((Node)this.containerCards, (Insets)new Insets(0.0, 100.0, 0.0, 0.0));
        if (dataAvailablePayCostStrings.size() == 1) {
            FlowPane containerIcons = this.addEnerCostIcons(this.costString);
            containerIcons.setPrefHeight(87.0);
            containerIcons.setMinHeight(87.0);
            StackPane.setAlignment((Node)containerIcons, (Pos)Pos.CENTER_LEFT);
            content.getChildren().add((Object)containerIcons);
        } else {
            VBox containerPayCostOptions = new VBox();
            containerPayCostOptions.setSpacing(10.0);
            this.toggleGroup = new ToggleGroup();
            this.listRadioButtons = new ArrayList<RadioButton>();
            HashMap<RadioButton, FlowPane> mapOptionIcons = new HashMap<RadioButton, FlowPane>();
            HashMap<RadioButton, String> mapOptionCostStrings = new HashMap<RadioButton, String>();
            for (int i = 0; i < dataAvailablePayCostStrings.size(); ++i) {
                String costString = dataAvailablePayCostStrings.get(i);
                HBox optionBox = new HBox();
                optionBox.setAlignment(Pos.CENTER);
                optionBox.setPadding(new Insets(0.0, 40.0, 0.0, 20.0));
                RadioButton radioButton = new RadioButton();
                radioButton.setToggleGroup(this.toggleGroup);
                this.listRadioButtons.add(radioButton);
                FlowPane containerIcons = this.addEnerCostIcons(costString);
                HBox.setHgrow((Node)containerIcons, (Priority)Priority.ALWAYS);
                mapOptionIcons.put(radioButton, containerIcons);
                mapOptionCostStrings.put(radioButton, costString);
                if (i == 0) {
                    radioButton.setSelected(true);
                } else {
                    containerIcons.setOpacity(0.33);
                }
                optionBox.getChildren().addAll((Object[])new Node[]{radioButton, containerIcons});
                containerPayCostOptions.getChildren().add((Object)optionBox);
            }
            this.listenerToggle = (ov, oldValue, newValue) -> {
                ((FlowPane)mapOptionIcons.get(oldValue)).setOpacity(0.33);
                ((FlowPane)mapOptionIcons.get(newValue)).setOpacity(1.0);
                this.mapEnerIcons.get(this.costString).stream().filter(EnerIcon::isSelected).forEach(EnerIcon::toggleSelect);
                this.costString = (String)mapOptionCostStrings.get(newValue);
                this.oldRemainingCostLen = this.costString.length();
                this.handlerOnPayCostChanged.handle(this.costString);
            };
            this.toggleGroup.selectedToggleProperty().addListener(this.listenerToggle);
            StackPane.setMargin((Node)containerPayCostOptions, (Insets)new Insets(0.0, 0.0, 20.0, 0.0));
            content.getChildren().add((Object)containerPayCostOptions);
        }
        ImageView imageCard = OverlayWindowEnerCost.createCardImage(cardIndex);
        this.containerCards.setMaxWidth(imageCard.getFitWidth());
        this.containerCards.getChildren().add((Object)imageCard);
        content.getChildren().add((Object)this.containerCards);
        this.buttonExpand = OverlayWindowEnerCost.createButton(Settings.INSTANCE.shouldExpandEnerPay() ? this.buttonTextHide : this.buttonTextExpand);
        StackPane.setAlignment((Node)this.buttonExpand, (Pos)Pos.BOTTOM_CENTER);
        StackPane.setMargin((Node)this.buttonExpand, (Insets)new Insets(0.0, 20.0, -20.0, 20.0));
        content.getChildren().add((Object)this.buttonExpand);
        if (listEnerGroups.isEmpty() && dataAvailablePayCostStrings.size() == 1) {
            this.buttonExpand.setVisible(false);
            this.buttonExpand.setManaged(false);
        }
        UtilDispose.TEMP.attachChildDisposeListener((Node)this.contentPayEner);
        ScrollPane scrollPayEner = new ScrollPane((Node)this.contentPayEner);
        scrollPayEner.setStyle("-fx-background: black;");
        scrollPayEner.setPrefWidth(660.0);
        scrollPayEner.setFitToWidth(true);
        scrollPayEner.setFitToHeight(true);
        if (listEnerGroups.size() >= 10) {
            scrollPayEner.setPrefHeight(127.0);
        }
        scrollPayEner.setVisible((!listEnerGroups.isEmpty() || dataAvailablePayCostStrings.size() > 1) && Settings.INSTANCE.shouldExpandEnerPay());
        scrollPayEner.setManaged(scrollPayEner.isVisible());
        this.buttonExpand.setOnAction(e -> {
            scrollPayEner.setVisible(!scrollPayEner.isVisible());
            scrollPayEner.setManaged(scrollPayEner.isVisible());
            this.buttonExpand.setText(scrollPayEner.isVisible() ? this.buttonTextHide : this.buttonTextExpand);
            Settings.INSTANCE.setShouldExpandEnerPay(scrollPayEner.isVisible());
        });
        this.updateEnerGroups();
        container.getChildren().addAll((Object[])new Node[]{content, scrollPayEner});
        this.getConfirmButton().setText(isMandatory ? this.buttonTextConfirm : this.buttonTextSkip);
        if (!this.costString.isEmpty() && isMandatory) {
            this.getConfirmButton().setDisable(true);
        }
        this.getContentNode().getChildren().add((Object)container);
    }

    private FlowPane addEnerCostIcons(String costString) {
        FlowPane containerIcons = new FlowPane();
        containerIcons.setAlignment(Pos.CENTER);
        containerIcons.setHgap(5.0);
        containerIcons.setVgap(5.0);
        containerIcons.setPrefWrapLength(5.0);
        for (int i = 0; i < costString.length(); ++i) {
            EnerIcon enerIcon = new EnerIcon(CardConst.CardColor.getColorByShortLabel(costString.charAt(i)));
            containerIcons.getChildren().add((Object)enerIcon);
            this.mapEnerIcons.computeIfAbsent(costString, k -> new ArrayList()).add(enerIcon);
        }
        return containerIcons;
    }

    public final void updateEnerGroups() {
        this.contentPayEner.getChildren().clear();
        for (FieldZoneEnerGroup enerGroup : this.listEnerGroups) {
            int countPayEner;
            VBox contentCard = new VBox();
            contentCard.setAlignment(Pos.TOP_CENTER);
            contentCard.setMaxWidth(71.0);
            CardIndex cardIndex = enerGroup.getSourceCard3D().getCardIndex();
            ImageView imageCardEner = OverlayWindowEnerCost.createCardImage(cardIndex, false);
            if (enerGroup.getSourceCard3D() instanceof Card3DSubstitute) {
                imageCardEner.setImage(enerGroup.getSourceCard3D().getCardMeshFace().getTexture());
            }
            if ((countPayEner = cardIndex.getIndexedInstance().getRCRegistry().getRuleValue(CardRuleCheckRegistry.CardRuleValueType.PAY_ENER_COUNT).getValue().intValue()) == 1) {
                contentCard.getChildren().add((Object)imageCardEner);
            } else {
                Text textCount = new Text(countPayEner + "\u00d7");
                textCount.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)32.0));
                textCount.setFill((Paint)Color.RED);
                textCount.setStroke((Paint)Color.BLACK);
                textCount.setStrokeWidth(1.0);
                textCount.setMouseTransparent(true);
                StackPane containerCardImage = new StackPane();
                containerCardImage.getChildren().addAll((Object[])new Node[]{imageCardEner, textCount});
                contentCard.getChildren().add((Object)containerCardImage);
            }
            FlowPane contentEner = new FlowPane();
            contentEner.setAlignment(Pos.CENTER);
            contentEner.setPadding(new Insets(2.0));
            contentEner.setHgap(2.0);
            contentEner.setVgap(2.0);
            contentEner.setMinWidth(contentCard.getMaxWidth());
            contentEner.setMaxWidth(contentCard.getMaxWidth());
            ArrayList<ImageView> listEnerIcons = new ArrayList<ImageView>();
            for (EnerColor enerColor : enerGroup.getEnerColorsList()) {
                ImageView iconEner = new ImageView(ImageCache.INSTANCE.getImageIcon(ImageCache.getColorIconPath(enerColor.getColor())));
                iconEner.setFitWidth(20.0);
                iconEner.setFitHeight(20.0);
                iconEner.setOpacity(0.75);
                iconEner.setCursor(Cursor.HAND);
                iconEner.setOnMouseEntered(e -> {
                    enerColor.fireEvent(e);
                    if (!enerColor.isLocked() && enerColor.getSourceEnerGroup().getSelectedEnerColor() == null) {
                        iconEner.setOpacity(1.0);
                    }
                });
                iconEner.setOnMouseExited(e -> {
                    enerColor.fireEvent(e);
                    if (!enerColor.isLocked() && enerColor.getSourceEnerGroup().getSelectedEnerColor() == null) {
                        iconEner.setOpacity(0.75);
                    }
                });
                iconEner.setOnMouseClicked(arg_0 -> ((EnerColor)enerColor).fireEvent(arg_0));
                enerColor.setOnEnerColorLocked(() -> {
                    iconEner.setImage(enerColor.getMaterial().getDiffuseMap());
                    iconEner.setCursor(enerColor.isLocked() ? Cursor.DEFAULT : Cursor.HAND);
                });
                contentEner.getChildren().addFirst((Object)iconEner);
                listEnerIcons.addFirst(iconEner);
            }
            SequencedCollection reversedEnerColorsList = enerGroup.getEnerColorsList().reversed();
            imageCardEner.setOnMouseEntered(arg_0 -> OverlayWindowEnerCost.lambda$updateEnerGroups$8((List)reversedEnerColorsList, listEnerIcons, arg_0));
            imageCardEner.setOnMouseExited(arg_0 -> OverlayWindowEnerCost.lambda$updateEnerGroups$11((List)reversedEnerColorsList, listEnerIcons, arg_0));
            imageCardEner.setOnMouseClicked(arg_0 -> OverlayWindowEnerCost.lambda$updateEnerGroups$14((List)reversedEnerColorsList, listEnerIcons, arg_0));
            contentCard.getChildren().add((Object)contentEner);
            UtilDispose.TEMP.setOnDisposed((Node)contentCard, () -> {
                imageCardEner.setOnMouseEntered(null);
                imageCardEner.setOnMouseExited(null);
                imageCardEner.setOnMouseClicked(null);
                imageCardEner.setImage(null);
                for (EnerColor enerColor : enerGroup.getEnerColorsList()) {
                    enerColor.setOnEnerColorLocked(null);
                }
                for (ImageView iconEner : listEnerIcons) {
                    iconEner.setOnMouseEntered(null);
                    iconEner.setOnMouseExited(null);
                    iconEner.setOnMouseClicked(null);
                }
            });
            this.contentPayEner.getChildren().add((Object)contentCard);
        }
    }

    public void setOnPayCostChanged(OnPayCostChangedHandler handler) {
        this.handlerOnPayCostChanged = handler;
    }

    public void disableToggleControls(boolean set) {
        if (this.listRadioButtons != null) {
            for (RadioButton radioButton : this.listRadioButtons) {
                radioButton.setDisable(set);
            }
        }
    }

    public final HBox getContainerCardsNode() {
        return this.containerCards;
    }

    public void updatePickedCount(int newPickedCount, CardConst.CardColor pickedColor, EnerColorPicker picker) {
        int newRemainingCostLen = picker.getRemainingCostStringLength();
        if (newPickedCount > this.oldPickedCount) {
            diff = this.oldRemainingCostLen - newRemainingCostLen;
            for (int i = 0; i < diff; ++i) {
                this.mapEnerIcons.get(this.costString).stream().filter(enerIcon -> enerIcon.getColor() == pickedColor && !enerIcon.isSelected()).findFirst().ifPresent(EnerIcon::toggleSelect);
            }
        } else if (newPickedCount < this.oldPickedCount && newRemainingCostLen > 0) {
            diff = newRemainingCostLen - this.oldRemainingCostLen;
            for (int i = 0; i < diff; ++i) {
                this.mapEnerIcons.get(this.costString).reversed().stream().filter(enerIcon -> enerIcon.getColor() == pickedColor && enerIcon.isSelected()).findFirst().ifPresent(EnerIcon::toggleSelect);
            }
        }
        this.oldRemainingCostLen = picker.getRemainingCostStringLength();
        this.oldPickedCount = newPickedCount;
        if (!this.isMandatory) {
            this.getConfirmButton().setText(newPickedCount > 0 ? this.buttonTextConfirm : this.buttonTextSkip);
        }
        boolean isConditionValid = picker.getCondition() == null || picker.getCondition().isValid(picker.getPickedCardIndexList());
        this.getConfirmButton().setDisable(!isConditionValid || (this.isMandatory || newPickedCount > 0) && newPickedCount < this.costString.length());
    }

    @Override
    public void forceFakeChoice(List<String> choices) {
        Picker<?> picker = Game.getCurrentGame().getPlayerControl().getCurrentPicker();
        if (picker instanceof EnerColorPicker) {
            EnerColorPicker picker2 = (EnerColorPicker)picker;
            if (this.listRadioButtons != null) {
                int i;
                PacketParser lastFakePickData = picker2.getLastFakePickData();
                StringBuilder costString = new StringBuilder();
                for (i = 1; i < lastFakePickData.getDataArgsNum(); i += 2) {
                    costString.append(lastFakePickData.getDataArgument(i));
                }
                for (i = 0; i < this.dataAvailablePayCostStrings.size(); ++i) {
                    if (!this.dataAvailablePayCostStrings.get(i).contentEquals(costString)) continue;
                    this.listRadioButtons.get(i).setSelected(true);
                    break;
                }
            }
            picker2.confirmForcedFakePick();
        }
        super.forceFakeChoice(choices);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.contentPayEner.getChildren().clear();
        UtilDispose.TEMP.detachChildDisposeListener((Node)this.contentPayEner);
        if (this.toggleGroup != null) {
            this.toggleGroup.selectedToggleProperty().removeListener(this.listenerToggle);
            this.listenerToggle = null;
        }
        for (Node node : this.containerCards.getChildren()) {
            if (!(node instanceof ImageView)) continue;
            ImageView imageView = (ImageView)node;
            imageView.setOnMouseEntered(null);
            imageView.setImage(null);
        }
        this.buttonExpand.setOnAction(null);
        this.mapEnerIcons.clear();
        this.handlerOnPayCostChanged = null;
    }

    private static /* synthetic */ void lambda$updateEnerGroups$14(List reversedEnerColorsList, List listEnerIcons, MouseEvent e) {
        reversedEnerColorsList.stream().filter(enerColor -> !enerColor.isLocked()).findFirst().ifPresent(enerColor -> ((ImageView)listEnerIcons.get(reversedEnerColorsList.indexOf(enerColor))).fireEvent((Event)e));
    }

    private static /* synthetic */ void lambda$updateEnerGroups$11(List reversedEnerColorsList, List listEnerIcons, MouseEvent e) {
        reversedEnerColorsList.stream().filter(enerColor -> !enerColor.isLocked()).findFirst().ifPresent(enerColor -> ((ImageView)listEnerIcons.get(reversedEnerColorsList.indexOf(enerColor))).fireEvent((Event)e));
    }

    private static /* synthetic */ void lambda$updateEnerGroups$8(List reversedEnerColorsList, List listEnerIcons, MouseEvent e) {
        reversedEnerColorsList.stream().filter(enerColor -> !enerColor.isLocked()).findFirst().ifPresent(enerColor -> ((ImageView)listEnerIcons.get(reversedEnerColorsList.indexOf(enerColor))).fireEvent((Event)e));
    }

    public static class EnerIcon
    extends StackPane {
        private final Circle outline;
        private final CardConst.CardColor color;
        private boolean isSelected;

        public EnerIcon(CardConst.CardColor color) {
            this.color = color;
            ImageView iconEner = new ImageView(ImageCache.INSTANCE.getImage(ImageCache.getColorTexturePath(color)));
            iconEner.setFitWidth(32.0);
            iconEner.setFitHeight(32.0);
            this.outline = new Circle(19.0, (Paint)Color.GREEN);
            this.outline.setVisible(false);
            this.getChildren().addAll((Object[])new Node[]{this.outline, iconEner});
        }

        public void toggleSelect() {
            this.isSelected = !this.isSelected;
            this.outline.setVisible(this.isSelected);
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public CardConst.CardColor getColor() {
            return this.color;
        }
    }

    @FunctionalInterface
    public static interface OnPayCostChangedHandler {
        public void handle(String var1);
    }
}

