/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.window;

import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.layout.VBox;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.parsers.LanguageParser;

public class OverlayWindowWarnConfirmation
extends OverlayWindow {
    private WindowOnConfirmedHandler handler;

    public OverlayWindowWarnConfirmation(String description) {
        super(LanguageParser.getString("UI_GAME_WINDOW_WARN_TITLE"), description + "\n" + LanguageParser.getString("UI_GAME_WINDOW_WARN_DESC"));
        VBox containerButtons = new VBox();
        containerButtons.setAlignment(Pos.CENTER);
        containerButtons.setSpacing(50.0);
        this.getConfirmButton().setText(LanguageParser.getString("UI_GAME_WINDOW_BUTTON_YES"));
        Button buttonCancel = OverlayWindowWarnConfirmation.createButton(LanguageParser.getString("UI_GAME_WINDOW_BUTTON_NO"));
        this.getConfirmButton().setOnAction(e -> {
            if (this.handler != null) {
                this.handler.handle(true);
            }
        });
        buttonCancel.setOnAction(e -> {
            if (this.handler != null) {
                this.handler.handle(false);
            }
        });
        this.addWindowButton(buttonCancel);
    }

    public void setOnConfirm(WindowOnConfirmedHandler handler) {
        this.handler = handler;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.handler = null;
    }

    @FunctionalInterface
    public static interface WindowOnConfirmedHandler {
        public void handle(boolean var1);
    }
}

