/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking;

import java.net.DatagramSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.pickers.Picker;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.networking.GameReceiver;
import open.batoru.networking.PacketParser;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.ConnectionAttempt;
import open.batoru.ui.FX;
import open.batoru.ui.UI;

public class FakeGameReceiver
extends GameReceiver {
    protected final Map<Integer, List<String>> actionData = new HashMap<Integer, List<String>>();
    private int finalOrder;
    private int surrenderOrder;
    private RedirectedReceiver lastRedirectedReceiver;
    private boolean isPlayerDisconnected;
    private boolean isLocked;
    private final GameReceiver gameReceiver;
    private final List<String> lastManualChoice = new ArrayList<String>();

    public FakeGameReceiver(List<String> data, DatagramSocket socket, int portOffset) {
        super(null, 0);
        data.removeIf(rawData -> {
            if (rawData.equals("DC")) {
                this.isPlayerDisconnected = true;
                return true;
            }
            if (rawData.equals("RC")) {
                this.isPlayerDisconnected = false;
                return true;
            }
            return false;
        });
        for (int i = 0; i < data.size(); ++i) {
            int orderId = this.addData(data.get(i));
            if (this.finalOrder != 0 || i != data.size() - 1) continue;
            this.finalOrder = orderId;
        }
        this.gameReceiver = new GameReceiver(socket, portOffset);
    }

    protected final int addData(String rawData) {
        if (rawData.isEmpty()) {
            return 0;
        }
        int token = rawData.indexOf("|");
        if (token == -1) {
            return 0;
        }
        int orderId = Integer.parseInt(rawData.substring(0, token));
        String data = rawData.substring(token + 1);
        this.actionData.computeIfAbsent(orderId, key -> new ArrayList()).add(data);
        if (data.startsWith("GG")) {
            this.finalOrder = this.surrenderOrder = orderId;
        }
        return orderId;
    }

    public String getNextData(int orderId) {
        return this.getNextData(orderId, null);
    }

    public String getNextData(int orderId, RemoveOrderCondition removeCondition) {
        if (this.isLocked) {
            return null;
        }
        List<String> list = this.actionData.get(orderId);
        if (list == null) {
            Log.printMessage("!fake: No data list found for order: " + orderId);
            if (orderId > this.finalOrder) {
                this.processEnd();
            }
            return null;
        }
        if (list.isEmpty()) {
            Log.printMessage("!fake: Empty data list found for order: " + orderId);
            if (orderId == this.finalOrder) {
                this.processEnd();
            }
            return null;
        }
        return removeCondition == null || removeCondition.shouldRemove(list.getFirst()) ? list.removeFirst() : list.getFirst();
    }

    @Override
    public void start() {
    }

    public void processRequest(int orderId) {
        if (orderId == this.surrenderOrder) {
            this.processIdle(this.surrenderOrder);
            return;
        }
        String data = this.getNextData(orderId);
        if (data == null) {
            return;
        }
        PacketParser pp = new PacketParser(data);
        Log.printMessage(">>> FAKE: (PRE) RQ: " + data);
        if (this.lastRedirectedReceiver != null) {
            Log.printMessage(">>> FAKE: RQ: " + data);
            this.lastRedirectedReceiver.processResponse(pp);
        }
    }

    public void processIdle(int nextOrderId) {
        String data = this.getNextData(nextOrderId, d -> this.gameReceiver.getTokenProcessors().containsKey(d.substring(0, d.indexOf(36))));
        if (data == null) {
            return;
        }
        PacketParser pp = new PacketParser(data);
        System.out.println(">>> FAKE: (PRE) ON IDLE: " + data);
        GameReceiver.GamePacketProcessor processor = this.gameReceiver.getTokenProcessors().get(pp.getPacketDataToken());
        if (processor != null) {
            Log.printMessage(">>> FAKE: ON IDLE: " + data);
            processor.process(nextOrderId, pp);
        }
    }

    public void processChoice(int orderId) {
        if (orderId == this.surrenderOrder) {
            this.processIdle(this.surrenderOrder);
            return;
        }
        String data = this.getNextData(orderId, d -> !d.contains("X$"));
        if (data == null) {
            return;
        }
        PacketParser pp = new PacketParser(data);
        Log.printMessage(">>> FAKE: CHOICE: " + data);
        for (int i = 0; i < pp.getDataArgsNum(); ++i) {
            this.lastManualChoice.add(pp.getDataArgument(i));
        }
    }

    public void processPicker(Picker<?> picker) {
        int orderId = Game.getCurrentGame().getActionQueue().getLastOrder();
        if (orderId == this.surrenderOrder) {
            this.processIdle(this.surrenderOrder);
            return;
        }
        String data = this.getNextData(orderId);
        if (data == null) {
            return;
        }
        PacketParser pp = new PacketParser(data);
        Log.printMessage(">>> FAKE: PICK: " + data);
        picker.forceFakePick(pp);
    }

    public void processEnd() {
        if (Game.getCurrentGame().getFakeReceiver() == null) {
            return;
        }
        Game.getCurrentGame().setFakeReceiver(null);
        Player.getNetworkFrame().startGameReceiver(this.gameReceiver);
        FX.run(() -> {
            UI.getTabGame().getFieldSceneOverlay().showGameMessage(null);
            UI.getTabGame().getFieldSceneOverlay().showBlackScreen(false);
            if (Game.getCurrentGame().getRoom().getRoomId() != 0 && this.isPlayerDisconnected()) {
                UI.getTabGame().getFieldSceneOverlay().showDisconnectedScreen();
            }
        });
        Game.getCurrentGame().getGameSpeedController().setMultiplier(-1.0);
        Log.printMessage(">>>>>>>>> FAKE END?");
    }

    public void forceConfirmWindow(OverlayWindow window) {
        if (this.lastManualChoice.isEmpty()) {
            this.processChoice(Game.getCurrentGame().getActionQueue().getLastOrder());
            if (this.lastManualChoice.isEmpty()) {
                return;
            }
        }
        Log.printMessage(">>> FAKE: (FORCED) CHOICE: " + String.valueOf(this.lastManualChoice));
        window.forceFakeChoice(this.lastManualChoice);
        this.lastManualChoice.clear();
    }

    @Override
    public void setPacketRedirectByToken(String token, ConnectionAttempt attempt, RedirectedReceiver.RedirectValidator validator, RedirectedReceiver.RedirectHandler handler) {
        this.lastRedirectedReceiver = new RedirectedReceiver(attempt, validator, handler);
    }

    @Override
    public void stopPacketRedirectByToken(String token) {
        this.lastRedirectedReceiver = null;
    }

    public int getFinalOrder() {
        return this.finalOrder;
    }

    public boolean isPlayerDisconnected() {
        return this.isPlayerDisconnected;
    }

    @Deprecated
    public void setLockNextDataRequests(boolean set) {
        this.isLocked = set;
    }

    @FunctionalInterface
    public static interface RemoveOrderCondition {
        public boolean shouldRemove(String var1);
    }
}

