/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.stream.Stream;

public class HTTPFileReader {
    private static final HttpClient HTTP_CLIENT = HttpClient.newHttpClient();

    public Stream<String> read(String url) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).build();
        try {
            HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                System.err.println("Warning: HTTP request failed with status code: " + response.statusCode());
                return null;
            }
            return response.body().lines();
        }
        catch (IOException | InterruptedException ex) {
            System.err.println(ex.getMessage());
            return null;
        }
    }
}

