/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Properties;

public class HTTPPostRequest {
    private static final HttpClient HTTP_CLIENT = HttpClient.newHttpClient();

    public Properties send(String url, String data) throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(data)).build();
        Properties props = new Properties();
        HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            System.err.println("Warning: HTTP request failed with status code: " + response.statusCode());
            props.put("response", String.valueOf(response.statusCode()));
            return props;
        }
        response.body().lines().forEach(line -> {
            int tokenSeparator = line.indexOf(61);
            if (tokenSeparator == -1) {
                System.err.println("Warning: HTTP request returned unexpected result: " + line);
                return;
            }
            String key = line.substring(0, tokenSeparator);
            String value = line.substring(tokenSeparator + 1);
            props.setProperty(key, value);
        });
        return props;
    }
}

