/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking;

import open.batoru.networking.PacketParser;
import open.batoru.networking.connection.ConnectionAttempt;

public class RedirectedReceiver {
    private final ConnectionAttempt attempt;
    private final RedirectValidator validator;
    private final RedirectHandler handler;

    public RedirectedReceiver(ConnectionAttempt attempt, RedirectValidator validator, RedirectHandler handler) {
        this.attempt = attempt;
        this.validator = validator;
        this.handler = handler;
    }

    public boolean isValidResponse(PacketParser pp) {
        return this.validator == null || this.validator.check(pp);
    }

    public boolean hasCustomValidator() {
        return this.validator == RedirectValidator.CUSTOM;
    }

    public void processResponse(PacketParser pp) {
        this.handler.handle(pp);
    }

    public void setReceivedPacketAsSatisfying() {
        if (this.attempt != null) {
            this.attempt.setReceivedPacketAsSatisfying();
        }
    }

    @FunctionalInterface
    public static interface RedirectValidator {
        public static final RedirectValidator CUSTOM = pp -> true;

        public boolean check(PacketParser var1);

        public static RedirectValidator ofGameAction(int orderId) {
            return pp -> pp.getDataArgsNum() >= 2 && pp.getDataArgument(0).equals(String.valueOf(orderId)) && pp.getDataArgument(1).equals("!1");
        }

        public static RedirectValidator ofSimpleGameAction(int orderId) {
            return pp -> pp.getDataArgsNum() >= 1 && pp.getDataArgument(0).equals(String.valueOf(orderId));
        }

        public static RedirectValidator ofIdlePlayerAction(int orderId) {
            return pp -> !(pp.getDataArgsNum() < 1 || !pp.getDataArgument(0).equals("!4") && !pp.getDataArgument(0).equals(String.valueOf(orderId)) || pp.getDataArgsNum() != 1 && !pp.getDataArgument(1).equals("!1"));
        }
    }

    @FunctionalInterface
    public static interface RedirectHandler {
        public void handle(PacketParser var1);
    }
}

