/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.gameplay.pickers.Picker;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.networking.FakeGameReceiver;
import open.batoru.networking.HTTPFileDownloader;
import open.batoru.ui.FX;
import open.batoru.ui.UI;

public class SpecFakeGameReceiver
extends FakeGameReceiver {
    private static final int DATA_REQUEST_PERIOD = 3000;
    private long lastRequest;
    private final int gameId;
    private boolean hasFFended;
    private ProcessWrapper lastProcess;
    private ScheduledExecutorService executor;

    public SpecFakeGameReceiver(List<String> data, int gameId) {
        super(data, null, 0);
        this.gameId = gameId;
    }

    public void onDataReceived(String data) {
        if (Game.getCurrentGame() == null || Game.getCurrentGame().getFakeReceiver() != this) {
            return;
        }
        System.out.println(">>> RQ: " + data);
        if (!data.isEmpty()) {
            int prevSize = this.actionData.size();
            data.lines().forEach(rawData -> {
                if (Character.isDigit(rawData.charAt(0))) {
                    this.addData((String)rawData);
                } else if (rawData.startsWith("DC")) {
                    FX.run(() -> UI.getTabGame().getFieldSceneOverlay().showDisconnectedScreen());
                } else if (rawData.startsWith("RC")) {
                    FX.run(() -> UI.getTabGame().getFieldSceneOverlay().hideDisconnectedScreen());
                }
            });
            if (this.actionData.size() != prevSize) {
                this.lastProcess.process();
            } else {
                this.requestData();
            }
        } else {
            if (Instant.now().toEpochMilli() - this.lastRequest < 3000L) {
                return;
            }
            this.executor.schedule(this::requestData, 3000L, TimeUnit.MILLISECONDS);
            this.lastRequest = Instant.now().toEpochMilli();
        }
    }

    @Override
    public String getNextData(int orderId, FakeGameReceiver.RemoveOrderCondition removeCondition) {
        if (!this.hasFFended) {
            return super.getNextData(orderId, removeCondition);
        }
        List list = (List)this.actionData.get(orderId);
        if (list == null) {
            this.requestData();
            return null;
        }
        if (list.isEmpty()) {
            if (!this.actionData.containsKey(orderId + 1)) {
                this.requestData();
            }
            return null;
        }
        return removeCondition == null || removeCondition.shouldRemove((String)list.getFirst()) ? (String)list.removeFirst() : (String)list.getFirst();
    }

    private void requestData() {
        Path pathTemp = Path.of("downloads/temp/spec/" + this.gameId + ".replay", new String[0]);
        Thread requestThread = new Thread(() -> {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            HTTPFileDownloader downloader = new HTTPFileDownloader(outputStream);
            downloader.setOnDownloadCompleted(() -> this.onDataReceived(outputStream.toString()));
            try {
                downloader.download("https://open.batoru.moe/game/downloads/temp/spec/" + this.gameId + ".replay", pathTemp);
            }
            catch (IOException | InterruptedException ex) {
                Log.printMessage(ex);
                this.onDataReceived("");
            }
        });
        requestThread.setDaemon(true);
        requestThread.start();
    }

    @Override
    public void processRequest(int orderId) {
        this.lastProcess = () -> super.processRequest(orderId);
        this.lastProcess.process();
    }

    @Override
    public void processIdle(int orderId) {
        this.lastProcess = () -> super.processIdle(orderId);
        this.lastProcess.process();
    }

    @Override
    public void processPicker(Picker<?> picker) {
        this.lastProcess = () -> super.processPicker(picker);
        this.lastProcess.process();
    }

    @Override
    public void forceConfirmWindow(OverlayWindow window) {
        this.lastProcess = () -> super.forceConfirmWindow(window);
        this.lastProcess.process();
    }

    @Override
    public void processEnd() {
        if (this.hasFFended) {
            return;
        }
        this.hasFFended = true;
        this.executor = Executors.newSingleThreadScheduledExecutor();
        FX.run(() -> {
            UI.getTabGame().getFieldSceneOverlay().showGameMessage(null);
            UI.getTabGame().getFieldSceneOverlay().showBlackScreen(false);
            if (this.isPlayerDisconnected()) {
                UI.getTabGame().getFieldSceneOverlay().showDisconnectedScreen();
            }
        });
        Game.getCurrentGame().getGameSpeedController().setMultiplier(-1.0);
        Log.printMessage(">>>>>>>>> FAKE END? (preloaded)");
        this.lastProcess.process();
    }

    @Override
    public void end() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        super.end();
    }

    @FunctionalInterface
    private static interface ProcessWrapper {
        public void process();
    }
}

