/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class UtilHash {
    public static String generateChecksum(String data) {
        if (data == null || data.isEmpty()) {
            return "";
        }
        try {
            return String.format("%032X", new BigInteger(1, MessageDigest.getInstance("MD5").digest(data.getBytes())));
        }
        catch (NoSuchAlgorithmException ex) {
            System.err.println(ex.getMessage());
            return "";
        }
    }

    public static String generateFileHash(Path path) {
        try {
            return String.format("%064X", new BigInteger(1, MessageDigest.getInstance("SHA-256").digest(Files.readAllBytes(path))));
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            System.err.println(ex.getMessage());
            return "";
        }
    }

    private UtilHash() {
    }
}

