/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking.connection;

import java.net.UnknownHostException;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.GameAction;
import open.batoru.networking.connection.ConnectionAttempt;

public class GameSendActionAttempt
extends ConnectionAttempt {
    private final int orderId;
    private GameAction<?> action;

    public GameSendActionAttempt(String token, GameAction<?> action, String data) throws UnknownHostException {
        this(token, !action.isChildAction() ? action.getOrderId() : Game.getCurrentGame().getActionQueue().getLastOrder(), data);
        this.action = action;
    }

    public GameSendActionAttempt(String token, int orderId, String data) throws UnknownHostException {
        super(Player.getNetworkFrame().getGameReceiver().getSocket(), token, Game.getCurrentGame().getGameServerPort());
        this.setReceive(ConnectionAttempt.ReceiveType.RELIABLE_REQUEST);
        this.setData(Player.getKeyHash() + "|" + orderId + (String)(!data.isEmpty() ? "|" + data : ""));
        this.orderId = orderId;
    }

    @Override
    public void send() {
        if (Game.getCurrentGame().getFakeReceiver() == null) {
            super.send();
            return;
        }
        Game.getCurrentGame().getFakeReceiver().processRequest(this.orderId);
        if (Game.getCurrentGame().getFakeReceiver() == null && this.action != null && this.action.getRequestMinExpectedArgs() > 0 && !this.action.isDataReceived()) {
            this.action.requestData(this.action.getRequestMinExpectedArgs());
        }
    }
}

