/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking.connection;

import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import open.batoru.networking.NetworkReceiver;
import open.batoru.networking.PacketParser;

public class TemporaryPacketRedirect {
    private final NetworkReceiver receiver;
    private final String token;
    private final ResponseHandler handlerOnReceived;
    private final Timer timer = new Timer(true);

    public TemporaryPacketRedirect(NetworkReceiver receiver, String token, ResponseHandler handlerResponse) {
        this.receiver = receiver;
        this.token = token;
        this.handlerOnReceived = handlerResponse;
    }

    public void activate() {
        this.receiver.setCustomPacketRedirectByToken(this.token, pp -> {
            this.receiver.stopPacketRedirectByToken(this.token);
            this.timer.cancel();
            Platform.runLater(() -> this.handlerOnReceived.handle(pp, pp.getPacketData().equals("!1") || !pp.isDataResponseCode() ? RedirectResponseStatus.SUCCESS : RedirectResponseStatus.INVALID));
        });
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                TemporaryPacketRedirect.this.receiver.stopPacketRedirectByToken(TemporaryPacketRedirect.this.token);
                Platform.runLater(() -> TemporaryPacketRedirect.this.handlerOnReceived.handle(null, RedirectResponseStatus.TIMEOUT));
            }
        }, 20000L);
    }

    @FunctionalInterface
    public static interface ResponseHandler {
        public void handle(PacketParser var1, RedirectResponseStatus var2);
    }

    public static enum RedirectResponseStatus {
        TIMEOUT,
        INVALID,
        SUCCESS;

    }
}

