/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking.service;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.DecimalFormat;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import open.batoru.Main;
import open.batoru.networking.HTTPFileDownloader;
import open.batoru.networking.UtilHash;
import open.batoru.parsers.LanguageParser;

public class UpdateProcedureService
extends Stage {
    private final String expectedAutoUpdateServiceHash;
    private final ProgressBar progressBar;
    private final Text textProgress;
    private HTTPFileDownloader downloader;

    public UpdateProcedureService(String expectedAutoUpdateServiceHash) {
        this.expectedAutoUpdateServiceHash = expectedAutoUpdateServiceHash;
        this.initStyle(StageStyle.UTILITY);
        VBox root = new VBox();
        Scene scene = new Scene((Parent)root);
        this.setScene(scene);
        this.setResizable(false);
        this.initModality(Modality.WINDOW_MODAL);
        this.initOwner((Window)Main.getStage());
        this.setOnCloseRequest(e -> {
            if (this.downloader != null) {
                this.downloader.cancel();
            }
        });
        root.setAlignment(Pos.CENTER);
        root.setPadding(new Insets(10.0));
        root.setSpacing(10.0);
        Text text = new Text(LanguageParser.getString("UI_UPDATE_DOWNLOAD"));
        this.progressBar = new ProgressBar();
        this.progressBar.setProgress(-1.0);
        this.textProgress = new Text("0%");
        this.progressBar.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        root.getChildren().addAll((Object[])new Node[]{text, this.progressBar, this.textProgress});
    }

    public void startDownload() {
        if (this.downloader != null) {
            return;
        }
        new Thread(new DownloadRunnable()).start();
        this.showAndWait();
    }

    private static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.2f kB", (double)bytes / 1024.0);
        }
        return String.format("%.2f MB", (double)bytes / 1048576.0);
    }

    public void runAutoUpdater() {
        try {
            ProcessBuilder builder = System.getProperty("os.name").startsWith("Win") ? new ProcessBuilder("cmd.exe", "/c", "start", "update.bat", "-auto") : new ProcessBuilder("nohup", "./update.sh", "-auto");
            builder.start();
            System.exit(0);
        }
        catch (IOException ex) {
            Platform.runLater(() -> new Alert(Alert.AlertType.ERROR, ex.getMessage(), new ButtonType[0]).showAndWait());
        }
    }

    private class DownloadRunnable
    implements Runnable {
        private final DecimalFormat FORMATTER = new DecimalFormat("0.00");

        private DownloadRunnable() {
        }

        @Override
        public void run() {
            Path pathTemp = Path.of("downloads/temp/update.jar", new String[0]);
            UpdateProcedureService.this.downloader = new HTTPFileDownloader((existingFileSize, fileSize) -> Platform.runLater(() -> {
                double percent = 100.0 * (double)existingFileSize / (double)fileSize;
                UpdateProcedureService.this.progressBar.setProgress(percent / 100.0);
                UpdateProcedureService.this.textProgress.setText(this.FORMATTER.format(percent) + "% (" + UpdateProcedureService.formatBytes(existingFileSize) + " / " + UpdateProcedureService.formatBytes(fileSize) + ")");
            }));
            UpdateProcedureService.this.downloader.setOnDownloadCompleted(() -> {
                UpdateProcedureService.this.downloader = null;
                String hashDownloaded = UtilHash.generateFileHash(pathTemp);
                if (hashDownloaded.equalsIgnoreCase(UpdateProcedureService.this.expectedAutoUpdateServiceHash)) {
                    try {
                        Files.move(pathTemp, Path.of("downloads/update.jar", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        UpdateProcedureService.this.runAutoUpdater();
                    }
                    catch (IOException ex) {
                        System.err.println(ex.getMessage());
                    }
                }
            });
            try {
                UpdateProcedureService.this.downloader.download("https://open.batoru.moe/game/downloads/update.jar", pathTemp);
            }
            catch (IOException | InterruptedException ex) {
                System.err.println(ex.getMessage());
            }
        }
    }
}

