/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking.service;

import javafx.application.Platform;
import open.batoru.Settings;
import open.batoru.core.Player;
import open.batoru.networking.NetworkFrame;
import open.batoru.networking.RoomsReceiver;
import open.batoru.networking.UsernameData;
import open.batoru.networking.connection.LoginAttempt;
import open.batoru.networking.connection.RunnableConnection;
import open.batoru.networking.service.GameReconnectService;
import open.batoru.ui.UI;

public class UserLoginService {
    private final LoginHandler handler;
    private Thread thread;

    public UserLoginService(LoginHandler handler) {
        this.handler = handler;
    }

    public void start() {
        if (this.thread != null) {
            return;
        }
        RunnableConnection connection = new RunnableConnection(LoginAttempt::new, (socketReceiver, pp, status) -> {
            if (status != RunnableConnection.ResponseStatus.SUCCESS) {
                this.handler.handle(status);
                return;
            }
            Settings.INSTANCE.reloadDeck(Settings.DeckSource.PLAY);
            if (Player.getNetworkFrame() == null) {
                NetworkFrame networkFrame = new NetworkFrame();
                Player.setNetworkFrame(networkFrame);
            }
            Player.getNetworkFrame().startRoomsReceiver(new RoomsReceiver(socketReceiver));
            this.handler.handle(RunnableConnection.ResponseStatus.SUCCESS);
            if (pp.getDataArgument(0).startsWith("!")) {
                if (pp.getDataArgsNum() > 1) {
                    UsernameData.updateAndGet(Player.getUsername() + pp.getDataArgument(1));
                }
                UI.selectTab(UI.getTabRooms());
            } else {
                UI.setTabEnabled(UI.getTabRooms(), true);
                int startArg = 0;
                if (pp.getDataArgument(0).startsWith("@")) {
                    UsernameData.updateAndGet(Player.getUsername() + pp.getDataArgument(startArg++));
                }
                int portOffset = Integer.parseInt(pp.getDataArgument(startArg));
                int gameId = Integer.parseInt(pp.getDataArgument(startArg + 1));
                String exportedRecordData = pp.getPacketData().substring(pp.getPacketData().indexOf(pp.getDataArgument(startArg + 2)));
                Player.getNetworkFrame().getRoomsReceiver().parseRoomQueryData(exportedRecordData);
                Platform.runLater(() -> {
                    GameReconnectService service = new GameReconnectService(portOffset, gameId);
                    service.start();
                });
            }
        });
        this.thread = new Thread(connection);
        this.thread.start();
    }

    @FunctionalInterface
    public static interface LoginHandler {
        public void handle(RunnableConnection.ResponseStatus var1);
    }
}

