/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.parsers;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.image.Image;
import open.batoru.ImageCache;

public class BadgesParser {
    private static final Map<Integer, PlayerBadge> mapBadges = new HashMap<Integer, PlayerBadge>();

    public static void load() {
        block12: {
            try {
                BufferedReader reader = Files.newBufferedReader(Path.of("badges.dat", new String[0]));
                block9: while (true) {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        String[] args = line.split(",", -1);
                        try {
                            mapBadges.put(Integer.parseInt(args[0]), new PlayerBadge(args[1], args[2], ImageCache.INSTANCE.getImageIcon("ui/badges/" + args[3])));
                            continue block9;
                        }
                        catch (ArrayIndexOutOfBoundsException | NumberFormatException ex) {
                            System.err.println("Warning: Invalid badge format: " + line);
                        }
                    }
                    break block12;
                    {
                        continue block9;
                        break;
                    }
                    break;
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (IOException ex) {
                System.err.println("Warning: Failed to load badges.dat file.");
            }
        }
    }

    public static PlayerBadge getBadge(int badgeId) {
        return mapBadges.get(badgeId);
    }

    private BadgesParser() {
    }

    public record PlayerBadge(String title, String hexColor, Image imageIcon) {
    }
}

