/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.parsers;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CardSetsParser {
    private static final List<String> listSets = new ArrayList<String>();

    public static void load() {
        try (BufferedReader reader = Files.newBufferedReader(Path.of("cardsets.list", new String[0]));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.indexOf(61) == -1) continue;
                listSets.add(line.replace("=", ": "));
            }
        }
        catch (IOException ex) {
            System.err.println("Warning: Failed to load cardsets.list file.");
        }
    }

    public static List<String> getSetsAsOptionArray() {
        return Collections.unmodifiableList(listSets);
    }

    public static String getSetPrefix(String optionString) {
        return optionString.substring(0, optionString.indexOf(": "));
    }

    private CardSetsParser() {
    }
}

