/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui;

import java.awt.Toolkit;
import javafx.stage.PopupWindow;
import javafx.stage.Window;
import open.batoru.Main;
import open.batoru.Settings;
import open.batoru.ui.FX;
import open.batoru.ui.UI;
import open.batoru.ui.UITab;

public class UserAttentionNotifier {
    private static String lastNotifier;

    public static void notifyUser(boolean playSound, UITab sourceTab) {
        UserAttentionNotifier.notifyUser(playSound, null, sourceTab);
    }

    public static void notifyUser(boolean playSound, String sourceNotifier, UITab sourceTab) {
        UserAttentionNotifier.notifyUser(playSound, true, sourceNotifier, sourceTab);
    }

    public static void notifyUser(boolean playSound, boolean flashWindow, String sourceNotifier, UITab sourceTab) {
        if (Main.testPort > 0 || Main.getStage().isFocused() && (UI.getCurrentTab() == sourceTab || !playSound) || sourceNotifier != null && sourceNotifier.equals(lastNotifier)) {
            return;
        }
        lastNotifier = sourceNotifier;
        if (Window.getWindows().stream().filter(Window::isShowing).anyMatch(window -> window != Main.getStage() && !(window instanceof PopupWindow))) {
            return;
        }
        FX.run(() -> {
            if (flashWindow && !Main.getStage().isFocused() && Settings.INSTANCE.isNotificationWindowFlashEnabled()) {
                Main.getStage().toFront();
            }
            if (playSound && Settings.INSTANCE.isNotificationAlertSoundEnabled()) {
                Toolkit.getDefaultToolkit().beep();
            }
        });
    }

    private UserAttentionNotifier() {
    }
}

