/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui;

import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import open.batoru.core.Disposable;
import open.batoru.game.overlay.effects.AnimVBox;

public class UtilDispose {
    public static final UtilDispose TEMP = new UtilDispose();
    public static final UtilDispose PERM = new UtilDispose();
    private final Map<Node, Disposable> map = new WeakHashMap<Node, Disposable>();
    private final Map<ObservableList<Node>, ListChangeListener<Node>> listeners = new HashMap<ObservableList<Node>, ListChangeListener<Node>>();
    private boolean isSuppressed;

    public void setOnDisposed(Node node, Disposable disposable) {
        this.map.put(node, disposable);
    }

    public void attachChildDisposeListener(Node parent) {
        ObservableList<Node> children = this.getChildren(parent);
        if (children == null) {
            throw new IllegalArgumentException();
        }
        ListChangeListener listener = change -> {
            if (this.isSuppressed) {
                return;
            }
            while (change.next()) {
                if (!change.wasRemoved()) continue;
                for (Node node : change.getRemoved()) {
                    if (node instanceof Disposable) {
                        Disposable disposable2 = (Disposable)node;
                        disposable2.dispose();
                    }
                    this.map.computeIfPresent(node, (k, disposable) -> {
                        disposable.dispose();
                        return null;
                    });
                }
            }
        };
        children.addListener(listener);
        this.listeners.put(children, (ListChangeListener<Node>)listener);
    }

    public void detachChildDisposeListener(Node parent) {
        ObservableList<Node> children = this.getChildren(parent);
        if (children == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.computeIfPresent(children, (list, listener) -> {
            children.removeListener(listener);
            return null;
        });
    }

    public void suppressDispose(Runnable runnable) {
        this.isSuppressed = true;
        try {
            runnable.run();
        }
        finally {
            this.isSuppressed = false;
        }
    }

    private ObservableList<Node> getChildren(Node parent) {
        Node node = parent;
        Objects.requireNonNull(node);
        Node node2 = node;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pane.class, Group.class, AnimVBox.class}, (Object)node2, n)) {
            case 0 -> {
                Pane pane = (Pane)node2;
                yield pane.getChildren();
            }
            case 1 -> {
                Group group = (Group)node2;
                yield group.getChildren();
            }
            case 2 -> {
                AnimVBox animVBox = (AnimVBox)node2;
                yield animVBox.getChildren();
            }
            default -> null;
        };
    }

    public void clearAllDisposeListeners() {
        this.map.clear();
        this.listeners.forEach(ObservableList::removeListener);
        this.listeners.clear();
    }

    private UtilDispose() {
    }
}

