/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.deck;

import java.util.HashMap;
import java.util.Map;
import javafx.geometry.Insets;
import javafx.scene.layout.HBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import open.batoru.data.Card;
import open.batoru.data.CardConst;
import open.batoru.parsers.LanguageParser;

public class CardCountBar
extends HBox {
    private final Map<CardConst.CardType, Text> mapTypeText = new HashMap<CardConst.CardType, Text>();
    private final Map<Integer, Text> mapLevelsText = new HashMap<Integer, Text>();
    private Text textGuard;
    private static final Font TEXT_FONT = Font.font((String)LanguageParser.getString("UI_FONT"), (double)10.0);

    public CardCountBar() {
        this.setSpacing(10.0);
        this.setPadding(new Insets(2.0, 5.0, 0.0, 5.0));
        this.setMinHeight(15.0);
        this.getStyleClass().add((Object)"ui_deck_panel");
    }

    public void addCard(Card cardObject) {
        this.updateCard(cardObject, 1);
    }

    public void removeCard(Card cardObject) {
        this.updateCard(cardObject, -1);
    }

    private void updateCard(Card cardObject, int addCount) {
        if (cardObject == null) {
            return;
        }
        CardConst.CardType cardType = cardObject.getType();
        if (cardType == CardConst.CardType.LRIG_ASSIST) {
            cardType = CardConst.CardType.LRIG;
        }
        if (this.mapTypeText.containsKey((Object)cardType)) {
            text = this.mapTypeText.get((Object)cardType);
            int newCount = this.getTextCount(text) + addCount;
            if (newCount > 0) {
                text.setText(cardType.getLabel() + ": " + newCount);
            } else {
                this.mapTypeText.remove((Object)cardType);
                this.getChildren().remove((Object)text);
            }
        } else {
            text = this.newText(cardType.getLabel());
            this.mapTypeText.put(cardType, text);
            this.getChildren().add((Object)text);
        }
        if (cardType == CardConst.CardType.SIGNI) {
            int level = cardObject.getLevel();
            if (this.mapLevelsText.containsKey(level)) {
                Text textLevel = this.mapLevelsText.get(level);
                int newLevelCount = this.getTextCount(textLevel) + addCount;
                if (newLevelCount > 0) {
                    textLevel.setText("LV" + level + ": " + newLevelCount);
                } else {
                    this.mapLevelsText.remove(level);
                    this.getChildren().remove((Object)textLevel);
                }
            } else {
                Text textLevel = this.newText("LV" + level);
                this.mapLevelsText.put(level, textLevel);
                this.getChildren().add(this.mapLevelsText.size() - 1, (Object)textLevel);
            }
        }
        if (cardObject.canGuard()) {
            if (this.textGuard == null) {
                this.textGuard = this.newText(LanguageParser.getString("CARD_TEXT_GUARD"));
                this.getChildren().add((Object)this.textGuard);
            } else {
                int newCount = this.getTextCount(this.textGuard) + addCount;
                if (newCount > 0) {
                    this.textGuard.setText(LanguageParser.getString("CARD_TEXT_GUARD") + ": " + newCount);
                } else {
                    this.getChildren().remove((Object)this.textGuard);
                    this.textGuard = null;
                }
            }
        }
    }

    private Text newText(String string) {
        Text text = new Text(string + ": 1");
        text.setFont(TEXT_FONT);
        return text;
    }

    private int getTextCount(Text text) {
        return Integer.parseInt(text.getText().substring(text.getText().indexOf(":") + 2));
    }

    public void clearAll() {
        this.mapTypeText.clear();
        this.mapLevelsText.clear();
        this.textGuard = null;
        this.getChildren().clear();
    }
}

