/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.deck;

import java.util.List;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import open.batoru.ImageCache;
import open.batoru.core.Disposable;
import open.batoru.data.CardDataImageSet;
import open.batoru.data.CardLoader;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;
import open.batoru.ui.UtilDispose;

public class CardImageSetPicker
extends StackPane
implements Disposable {
    private final HBox content = new HBox();
    private final ScrollPane scroll;
    private final Button buttonClose;
    private EventHandler<ScrollEvent> eventFilterScroll;
    private OnResultPickedHandler handler;

    public CardImageSetPicker(List<String> imageSets, OnResultPickedHandler handler) {
        this.handler = handler;
        this.setAlignment(Pos.BOTTOM_CENTER);
        this.getStyleClass().add((Object)"ui_deck_panel_window_art_header");
        double width = 677.5;
        double height = 225.0;
        this.setMinSize(width, height + 20.0);
        this.setMaxSize(this.getMinWidth(), this.getMinHeight());
        this.scroll = new ScrollPane((Node)this.content);
        this.scroll.setMaxSize(width, height);
        this.scroll.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.eventFilterScroll = e -> {
            if (e.getDeltaY() != 0.0) {
                this.scroll.setHvalue(this.scroll.getHvalue() - e.getDeltaY() / this.content.getWidth());
            }
        };
        this.scroll.addEventFilter(ScrollEvent.SCROLL, this.eventFilterScroll);
        this.getChildren().add((Object)this.scroll);
        for (String imageSet : imageSets) {
            this.addCard(imageSet);
        }
        this.buttonClose = new Button("\u2716");
        this.buttonClose.setFont(Font.font((double)10.0));
        this.buttonClose.getStyleClass().add((Object)"ui_deck_panel_window_art_button");
        StackPane.setAlignment((Node)this.buttonClose, (Pos)Pos.TOP_RIGHT);
        StackPane.setMargin((Node)this.buttonClose, (Insets)new Insets(0.0, 0.0, 16.0, 0.0));
        this.getChildren().add((Object)this.buttonClose);
        this.buttonClose.setOnAction(e -> handler.handle(null));
        this.setOnMouseClicked(e -> this.requestFocus());
        this.setOnKeyPressed(e -> {
            if (e.getCode() == KeyCode.ESCAPE) {
                handler.handle(null);
            }
        });
    }

    private void addCard(String imageSet) {
        String imageSetText;
        VBox cardContainer = new VBox();
        cardContainer.setPadding(new Insets(10.0));
        cardContainer.setAlignment(Pos.CENTER);
        cardContainer.setSpacing(10.0);
        ImageView cardImage = new ImageView(ImageCache.INSTANCE.getCardImage(imageSet));
        cardImage.setFitWidth(125.0);
        cardImage.setFitHeight(175.0);
        Rectangle clip = new Rectangle(125.0, 175.0);
        clip.setArcWidth(15.0);
        clip.setArcHeight(15.0);
        cardImage.setClip((Node)clip);
        if (CardLoader.getImageSetMaskType(imageSet) != CardDataImageSet.MaskType.DOUBLE_FACED_UR) {
            cardContainer.getChildren().add((Object)cardImage);
            imageSetText = imageSet;
        } else {
            StackPane imageContainer = new StackPane();
            Text textUR = new Text("UR");
            textUR.getStyleClass().add((Object)"ui_deck_panel_text_red");
            textUR.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)48.0));
            imageContainer.getChildren().addAll((Object[])new Node[]{cardImage, textUR});
            cardContainer.getChildren().add((Object)imageContainer);
            imageSetText = imageSet.substring(1);
        }
        Text cardText = new Text(imageSetText);
        cardText.getStyleClass().add((Object)"ui_deck_panel_window_art_text");
        cardContainer.getChildren().add((Object)cardText);
        cardContainer.setOnMouseEntered(e -> {
            cardContainer.setCursor(Cursor.HAND);
            cardContainer.getStyleClass().add((Object)"ui_deck_panel_window_art_highlight");
            UI.getTabDeck().getCardPreview().update(imageSet);
        });
        cardContainer.setOnMouseExited(e -> {
            cardContainer.setCursor(Cursor.DEFAULT);
            cardContainer.getStyleClass().remove((Object)"ui_deck_panel_window_art_highlight");
        });
        cardContainer.setOnMouseClicked(e -> {
            if (e.getButton() != MouseButton.PRIMARY) {
                return;
            }
            this.handler.handle(imageSet);
        });
        UtilDispose.PERM.setOnDisposed((Node)cardContainer, () -> {
            cardImage.setImage(null);
            cardContainer.setOnMouseEntered(null);
            cardContainer.setOnMouseExited(null);
            cardContainer.setOnMouseClicked(null);
        });
        this.content.getChildren().add((Object)cardContainer);
    }

    @Override
    public void dispose() {
        this.setOnMouseClicked(null);
        this.setOnKeyPressed(null);
        this.buttonClose.setOnAction(null);
        this.scroll.removeEventFilter(ScrollEvent.SCROLL, this.eventFilterScroll);
        this.eventFilterScroll = null;
        this.handler = null;
        UtilDispose.PERM.attachChildDisposeListener((Node)this);
        this.getChildren().clear();
        UtilDispose.PERM.detachChildDisposeListener((Node)this);
    }

    @FunctionalInterface
    public static interface OnResultPickedHandler {
        public void handle(String var1);
    }
}

