/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.deck;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import open.batoru.ImageCache;
import open.batoru.data.Card;
import open.batoru.data.CardConst;
import open.batoru.data.CardDataColor;

public class ColorsCountBar
extends VBox {
    private final Map<CardConst.CardColor, ColorEntry> mapColorEntries = new HashMap<CardConst.CardColor, ColorEntry>();

    public ColorsCountBar() {
        this.setAlignment(Pos.TOP_CENTER);
        this.setSpacing(2.0);
        this.getStyleClass().add((Object)"ui_deck_panel");
    }

    public void addCard(Card cardObject) {
        this.updateCard(cardObject, true);
    }

    public void removeCard(Card cardObject) {
        this.updateCard(cardObject, false);
    }

    private void updateCard(Card cardObject, boolean isAdded) {
        CardDataColor dataColor = cardObject.getColor();
        if (dataColor.getPrimaryValue() != CardConst.CardColor.COLORLESS) {
            dataColor.getValue().forEach(color -> this.updateColorCount((CardConst.CardColor)((Object)color), isAdded));
        } else {
            this.updateColorCount(CardConst.CardColor.COLORLESS, isAdded);
        }
    }

    private void updateColorCount(CardConst.CardColor color, boolean isAdded) {
        if (this.mapColorEntries.containsKey((Object)color)) {
            ColorEntry entry = this.mapColorEntries.get((Object)color);
            int newCount = entry.getValue() + (isAdded ? 1 : -1);
            if (newCount > 0) {
                entry.updateValue(isAdded);
            } else {
                this.mapColorEntries.remove((Object)color);
                this.getChildren().remove((Object)entry);
            }
        } else {
            ColorEntry entry = new ColorEntry(color);
            this.mapColorEntries.put(color, entry);
            this.getChildren().add(color != CardConst.CardColor.COLORLESS ? 0 : this.getChildren().size(), (Object)entry);
        }
    }

    public void clearAll() {
        this.mapColorEntries.clear();
        this.getChildren().clear();
    }

    public Map<CardConst.CardColor, ColorEntry> getMapColorEntries() {
        return Collections.unmodifiableMap(this.mapColorEntries);
    }

    public static class ColorEntry
    extends VBox {
        private final Text text;
        private int value;

        public ColorEntry(CardConst.CardColor color) {
            this(color, 1);
        }

        public ColorEntry(CardConst.CardColor color, int value) {
            this.setAlignment(Pos.CENTER);
            this.setSpacing(2.0);
            ImageView icon = new ImageView(ImageCache.INSTANCE.getImageIcon(ImageCache.getColorIconPath(color) + "i"));
            this.text = new Text(String.valueOf(value));
            this.value = value;
            this.getChildren().addAll((Object[])new Node[]{icon, this.text});
        }

        public void updateValue(boolean isAdded) {
            this.value += isAdded ? 1 : -1;
            this.text.setText(String.valueOf(this.value));
        }

        public int getValue() {
            return this.value;
        }
    }
}

