/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.deck;

import java.util.Optional;
import open.batoru.core.Deck;
import open.batoru.data.CardConst;
import open.batoru.parsers.LanguageParser;

public class DeckCompatibilityService {
    public Optional<String> getCompatibilityMessage(Deck deck, boolean allowedUnreleased, boolean allowedUnrestricted, CardConst.PlayFormat playFormat) {
        switch (deck.getValidStatus()) {
            case UNRELEASED: {
                if (allowedUnreleased) break;
                return Optional.of(LanguageParser.getString("UI_ALERT_DECK_UNRELEASED"));
            }
            case RESTRICTED: {
                if (allowedUnrestricted) break;
                return Optional.of(LanguageParser.getString("UI_ALERT_DECK_RESTRICTED"));
            }
            case READY: {
                break;
            }
            default: {
                return Optional.of(LanguageParser.getString("UI_ALERT_CONNECT_DECK"));
            }
        }
        if (!deck.isPlayFormatCompatible(playFormat)) {
            return Optional.of(LanguageParser.getString("UI_ALERT_DECK_FORMAT"));
        }
        if (!allowedUnrestricted && deck.containsFormatRestrictedCards(playFormat)) {
            return Optional.of(LanguageParser.getString("UI_ALERT_DECK_RESTRICTED"));
        }
        return Optional.empty();
    }
}

