/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.deck;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import open.batoru.ImageCache;
import open.batoru.Main;
import open.batoru.Settings;
import open.batoru.core.Deck;
import open.batoru.data.Card;
import open.batoru.data.CardConst;
import open.batoru.data.CardLoader;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;
import open.batoru.ui.deck.CardCountBar;
import open.batoru.ui.deck.ColorsCountBar;

public class DeckSnapshot {
    private static final int SPACE = 10;
    private static final int WIDTH = 3120;
    private static final int HEIGHT_MAIN = 1511;
    private static final int HEIGHT_LRIG = 479;

    public static void saveSnapshot() {
        VBox container = new VBox();
        container.setPadding(new Insets(10.0));
        container.setAlignment(Pos.CENTER);
        container.setMinSize(3120.0, 1990.0);
        Text textDeckName = new Text(Settings.INSTANCE.getCurrentDeck().getSourceFileName());
        textDeckName.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (double)36.0));
        StringBuilder strCardCount = new StringBuilder();
        CardCountBar cardCountBar = UI.getTabDeck().getCardCountBar();
        for (int i = 0; i < cardCountBar.getChildren().size(); ++i) {
            Text text = (Text)cardCountBar.getChildren().get(i);
            if (text.getText().endsWith(" 0")) continue;
            strCardCount.append(text.getText()).append("    ");
        }
        HBox boxColors = new HBox();
        boxColors.setSpacing(5.0);
        ColorsCountBar colorsCountBar = UI.getTabDeck().getColorsCountBar();
        colorsCountBar.getMapColorEntries().forEach((color, entry) -> {
            ColorsCountBar.ColorEntry snapshotEntry = new ColorsCountBar.ColorEntry((CardConst.CardColor)((Object)color), entry.getValue());
            boxColors.getChildren().add(color != CardConst.CardColor.COLORLESS ? 0 : boxColors.getChildren().size(), (Object)snapshotEntry);
        });
        Text textCardCount = new Text(strCardCount.toString());
        textCardCount.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (double)21.0));
        TilePane flowMain = DeckSnapshot.newDeckList(Deck.DeckType.MAIN);
        flowMain.setPadding(new Insets(5.0, 5.0, 0.0, 5.0));
        flowMain.setMinSize(3120.0, 1511.0);
        TilePane flowLRIG = DeckSnapshot.newDeckList(Deck.DeckType.LRIG);
        flowLRIG.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        flowLRIG.setMinSize(3120.0, 479.0);
        container.getChildren().addAll((Object[])new Node[]{textDeckName, textCardCount, boxColors, flowMain, flowLRIG});
        WritableImage snapshot = new WritableImage(3120, 1990);
        container.snapshot(new SnapshotParameters(), snapshot);
        try {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Save Snapshot");
            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Image File (PNG)", new String[]{"*.png"}));
            fileChooser.setInitialDirectory(new File("."));
            fileChooser.setInitialFileName("snapshot-" + Settings.INSTANCE.getCurrentDeck().getSourceFileName().replace(".deck", ""));
            File newFile = fileChooser.showSaveDialog((Window)Main.getStage());
            if (newFile != null) {
                if (!newFile.getPath().endsWith(".png")) {
                    newFile = new File(newFile.getPath() + ".png");
                }
                ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)snapshot, null), "png", newFile);
            }
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    private static TilePane newDeckList(Deck.DeckType deckType) {
        TilePane flow = new TilePane(Orientation.HORIZONTAL, 10.0, 10.0);
        flow.setPrefTileWidth(250.0);
        flow.setPrefTileHeight(369.0);
        for (String imageSet : Settings.INSTANCE.getCurrentDeck().getDeckList(deckType)) {
            VBox container = new VBox();
            container.setAlignment(Pos.CENTER);
            StackPane containerImage = new StackPane();
            ImageView image = new ImageView(ImageCache.INSTANCE.getCardImage(imageSet));
            image.setFitWidth(250.0);
            image.setFitHeight(349.0);
            Rectangle clip = new Rectangle(250.0, 349.0);
            clip.setArcWidth(24.0);
            clip.setArcHeight(24.0);
            image.setClip((Node)clip);
            containerImage.getChildren().add((Object)image);
            Card cardObject = CardLoader.getCardByImageSet(imageSet);
            if (cardObject.canGuard()) {
                ImageView iconGuard = new ImageView(ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("guard")));
                containerImage.getChildren().add((Object)iconGuard);
            }
            if (cardObject.hasLifeBurst()) {
                ImageView iconLifeBurst = new ImageView(ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("lifeburst")));
                containerImage.getChildren().add((Object)iconLifeBurst);
            }
            container.getChildren().add((Object)containerImage);
            if (!cardObject.getName().equals(cardObject.getOriginalName())) {
                Text textName = new Text(cardObject.getName());
                container.getChildren().add((Object)textName);
            }
            flow.getChildren().add((Object)container);
        }
        return flow;
    }
}

