/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.deck;

import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import open.batoru.ImageCache;
import open.batoru.Settings;
import open.batoru.core.Deck;
import open.batoru.data.Card;
import open.batoru.data.CardConst;
import open.batoru.data.CardLoader;
import open.batoru.parsers.LanguageParser;
import open.batoru.parsers.RestrictedCardsParser;
import open.batoru.parsers.UnreleasedCardsParser;

public class RestrictIconsContainer
extends VBox {
    private final String imageSet;
    private final Card cardObject;

    public RestrictIconsContainer(String imageSet) {
        this.imageSet = imageSet;
        this.cardObject = CardLoader.getCardByImageSet(imageSet);
        this.setSpacing(2.0);
        this.setMaxWidth(24.0);
    }

    public void update() {
        this.getChildren().clear();
        this.setMaxHeight(0.0);
        Deck currentDeck = Settings.INSTANCE.getCurrentDeck();
        if (this.cardObject.getLevel() != 0 && CardConst.CardType.isLRIG(this.cardObject.getType()) && currentDeck.getDeckList(Deck.DeckType.LRIG).stream().map(CardLoader::getCardByImageSet).noneMatch(c -> c.getLevel() == this.cardObject.getLevel() - 1 && CardConst.CardType.isLRIG(c.getType()) && c.getLRIGType().matches(this.cardObject.getLRIGType()))) {
            this.addRestrictIcon(ImageCache.INSTANCE.getImageIcon("restrict/warning"), LanguageParser.getString("UI_DECK_INFO_WARN_LRIG"));
        }
        if (currentDeck.isLRIGLimitMismatch(this.cardObject)) {
            this.addRestrictIcon(ImageCache.INSTANCE.getImageIcon("restrict/warning"), RestrictedCardsParser.formatLRIGLimitMismatchWarningText());
        }
        if (this.cardObject.getReleaseDate() != null) {
            this.addRestrictIcon(ImageCache.INSTANCE.getImageIcon("restrict/unreleased"), UnreleasedCardsParser.formatUnreleasedTooltipText(this.cardObject));
        }
        if (currentDeck.isCardMarkedAsSpecialRestricted(this.imageSet)) {
            this.addRestrictIcon(ImageCache.INSTANCE.getImageIcon("restrict/special"), RestrictedCardsParser.formatSpecialRestrictTooltipText(currentDeck, this.imageSet));
        }
        if (this.cardObject.getBanlistRestriction() != RestrictedCardsParser.RestrictType.NONE) {
            this.addRestrictIcon(ImageCache.INSTANCE.getImageIcon(ImageCache.getRestrictIconPath(this.cardObject.getBanlistRestriction())), RestrictedCardsParser.formatRestrictTooltipText(this.cardObject.getBanlistRestriction()));
        }
        if (this.cardObject.getBanlistSimultaneousNum() != 0 && currentDeck.checkSimultaneousConflicts(this.cardObject)) {
            this.addRestrictIcon(ImageCache.INSTANCE.getImageIcon("restrict/simultaneous"), RestrictedCardsParser.formatSimultaneousRestrictTooltipText(this.cardObject));
        }
        if (this.cardObject.getType() == CardConst.CardType.PIECE && (currentDeck.getZeroLevelLRIGCount() != 3 || currentDeck.getPieceTeamLimitCount() > 1)) {
            this.addRestrictIcon(ImageCache.INSTANCE.getImageIcon("restrict/diva"), null);
        }
        if (currentDeck.isPlayFormatCompatible(CardConst.PlayFormat.DIVA)) {
            if (currentDeck.checkDivaMatchingLRIGColors().contains((Object)this.cardObject.getLRIGType().getPrimaryValue())) {
                this.addRestrictIcon(ImageCache.INSTANCE.getImageIcon("restrict/diva"), LanguageParser.getString("UI_DECK_INFO_WARN_LRIG_COLORS") + " (" + CardConst.PlayFormat.DIVA.getLabel() + ")");
            }
            if (this.cardObject.getBanlistRestriction() == RestrictedCardsParser.RestrictType.UP_TO_TWO && currentDeck.containsFormatRestrictedCards(CardConst.PlayFormat.DIVA)) {
                this.addRestrictIcon(ImageCache.INSTANCE.getImageIcon("restrict/diva"), null);
            }
        }
    }

    private void addRestrictIcon(Image icon, String tooltip) {
        ImageView restrictIcon = new ImageView(icon);
        if (tooltip != null) {
            Tooltip toolTip = new Tooltip(tooltip);
            toolTip.setShowDelay(Duration.ZERO);
            Tooltip.install((Node)restrictIcon, (Tooltip)toolTip);
        }
        this.getChildren().add((Object)restrictIcon);
        this.setMaxHeight(this.getMaxHeight() + 24.0);
    }
}

