/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.deck;

import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import open.batoru.ImageCache;
import open.batoru.Settings;
import open.batoru.catalog.CardCatalog;
import open.batoru.catalog.CardPreview;
import open.batoru.catalog.SearchFilter;
import open.batoru.core.Deck;
import open.batoru.data.CardConst;
import open.batoru.data.CardLoader;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;
import open.batoru.ui.UIConst;
import open.batoru.ui.UITab;
import open.batoru.ui.UtilDispose;
import open.batoru.ui.deck.AdvancedFiltersPicker;
import open.batoru.ui.deck.CardCountBar;
import open.batoru.ui.deck.CardImageSetPicker;
import open.batoru.ui.deck.ColorsCountBar;
import open.batoru.ui.deck.DeckBuilder;
import open.batoru.ui.deck.DeckSnapshot;
import open.batoru.ui.deck.OptionFilters;

public class UITabDeck
extends UITab
implements UI.Selectable {
    private final DeckBuilder builder = new DeckBuilder();
    private final StackPane deckContainer = new StackPane();
    private CardPreview cardPreview;
    private CardCatalog cardCatalog;
    private CardImageSetPicker picker;
    private CardCountBar countBar;
    private ColorsCountBar countBarColors;
    private FlowPane flowPaneMain;
    private FlowPane flowPaneLRIG;
    private TextField deckFileNameTextBox;
    private Button buttonLoad;
    private Button buttonSave;
    private Button buttonClear;
    private AdvancedFiltersPicker pickerAdvancedFilters;
    private final TextField filterSearch = new TextField();
    private ComboBox<String> filterType;
    private ComboBox<String> filterColor;
    private ComboBox<String> filterLRIGType;
    private ComboBox<String> filterClass;
    private ComboBox<String> filterSets;
    private ComboBox<String> filterRestrict;
    private TextField filterLevel;
    private TextField filterPower;
    private CheckBox filterLifeBurst;
    private CheckBox filterGuard;
    private ComboBox<String> filterFormat;
    private HBox iconListCompatibleFormats;
    private ImageView iconDeckStatus;
    private Text messageDeckStatus;
    private Text messageDeckInfo;
    private Text messageCardsCount;

    public UITabDeck() {
        this.showCardPreview();
        this.showButtons();
        this.showDeck();
        this.showCatalog();
        this.addToTabRoot((Node)this.deckContainer);
        UtilDispose.PERM.attachChildDisposeListener((Node)this.deckContainer);
        int lastSelectedFormat = Settings.INSTANCE.getLastSelectedDeckBuilderFormat();
        if (lastSelectedFormat > 0) {
            this.filterFormat.getSelectionModel().select(lastSelectedFormat);
        }
    }

    private void showCardPreview() {
        StackPane preview = new StackPane();
        preview.setPadding(new Insets(10.0));
        preview.setPrefWidth(250.0);
        preview.getStyleClass().add((Object)"ui_deck_panel");
        this.cardPreview = new CardPreview();
        preview.getChildren().add((Object)this.cardPreview.getNode());
        this.addToTab((Node)preview, UITab.Position.LEFT, new Insets(5.0));
    }

    @Override
    public void onSelected() {
        this.cardPreview.getDescriptionWebView().setBlendMode(!Settings.INSTANCE.isUsingDarkTheme() ? null : BlendMode.LIGHTEN);
    }

    @Override
    public void onDeselected() {
    }

    private void showButtons() {
        BorderPane panel = new BorderPane();
        panel.setStyle("-fx-font-size: 8pt;");
        panel.setLeft((Node)this.showDeckButtons());
        panel.setCenter((Node)this.showFilterButtons());
        this.addToTab((Node)panel, UITab.Position.TOP, new Insets(5.0, 5.0, 0.0, 5.0));
    }

    private VBox showDeckButtons() {
        VBox deckButtons = new VBox();
        deckButtons.setSpacing(10.0);
        deckButtons.getStyleClass().add((Object)"ui_deck_panel");
        HBox buttonBox = new HBox();
        buttonBox.setAlignment(Pos.CENTER_LEFT);
        buttonBox.setPadding(new Insets(5.0));
        buttonBox.setSpacing(5.0);
        Label labelDeck = new Label(LanguageParser.getString("UI_DECK_DISPLAY"));
        this.deckFileNameTextBox = new TextField(Settings.INSTANCE.getCurrentDeck().getSourceFileName());
        this.deckFileNameTextBox.setPrefWidth(200.0);
        this.deckFileNameTextBox.setDisable(true);
        this.buttonLoad = new Button(LanguageParser.getString("UI_DECK_BUTTON_LOAD"));
        this.buttonLoad.setMinWidth(80.0);
        this.buttonLoad.setOnAction(e -> Settings.INSTANCE.loadDeckFile(Settings.DeckSource.EDIT));
        this.buttonSave = new Button(LanguageParser.getString("UI_DECK_BUTTON_SAVE"));
        this.buttonSave.setMinWidth(80.0);
        this.buttonSave.setOnAction(e -> Settings.INSTANCE.saveDeckFile());
        this.buttonClear = new Button(LanguageParser.getString("UI_DECK_BUTTON_CLEAR"));
        this.buttonClear.setMinWidth(80.0);
        this.buttonClear.setOnAction(e -> {
            Settings.INSTANCE.getCurrentDeck().clearDeck();
            this.builder.clearAllCards();
            this.updateDeckStatus();
        });
        Button buttonSnapshot = new Button("\ud83d\udcf7");
        buttonSnapshot.setFont(Font.loadFont((String)"file:fonts/Symbola-12.ttf", (double)12.0));
        buttonSnapshot.setOnAction(e -> DeckSnapshot.saveSnapshot());
        buttonBox.getChildren().addAll((Object[])new Node[]{labelDeck, this.deckFileNameTextBox, this.buttonLoad, this.buttonSave, this.buttonClear, buttonSnapshot});
        HBox statusBox = new HBox();
        statusBox.setAlignment(Pos.CENTER_LEFT);
        statusBox.setPadding(new Insets(5.0));
        statusBox.setSpacing(5.0);
        this.iconDeckStatus = new ImageView();
        this.messageDeckStatus = new Text();
        this.messageDeckStatus.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)12.0));
        this.messageDeckStatus.getStyleClass().add((Object)"ui_deck_panel_text_green");
        statusBox.getChildren().addAll((Object[])new Node[]{this.iconDeckStatus, this.messageDeckStatus});
        this.iconListCompatibleFormats = new HBox();
        this.iconListCompatibleFormats.setAlignment(Pos.CENTER_LEFT);
        this.iconListCompatibleFormats.setSpacing(5.0);
        statusBox.getChildren().add((Object)this.iconListCompatibleFormats);
        HBox infoBox = new HBox();
        infoBox.setAlignment(Pos.CENTER_LEFT);
        infoBox.setPadding(new Insets(5.0));
        infoBox.setSpacing(5.0);
        this.messageDeckInfo = new Text();
        this.messageDeckInfo.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (double)12.0));
        this.messageDeckInfo.setWrappingWidth(360.0);
        infoBox.getChildren().add((Object)this.messageDeckInfo);
        deckButtons.getChildren().addAll((Object[])new Node[]{buttonBox, statusBox, infoBox});
        return deckButtons;
    }

    private GridPane showFilterButtons() {
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER_RIGHT);
        grid.setPadding(new Insets(5.0));
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.getStyleClass().add((Object)"ui_deck_panel");
        Label labelType = new Label(LanguageParser.getString("UI_DECK_FILTER_TYPE"));
        this.filterType = new ComboBox(OptionFilters.getTypeList());
        this.filterType.getSelectionModel().selectFirst();
        this.filterType.setPrefWidth(100.0);
        this.filterType.valueProperty().addListener((ov, oldValue, newValue) -> {
            this.cardCatalog.getSearchFilter().applyFiltersInLockedState(filter -> this.toggleFiltersByCardType(CardConst.CardType.getTypeByLabel(newValue)));
            this.cardCatalog.getSearchFilter().filterType(CardConst.CardType.getTypeByLabel(newValue));
        });
        Label labelColor = new Label(LanguageParser.getString("UI_DECK_FILTER_COLOR"));
        HBox boxFilterColor = new HBox();
        VBox boxColor = new VBox();
        this.filterColor = new ComboBox(OptionFilters.getColorList());
        this.filterColor.getSelectionModel().selectFirst();
        this.filterColor.setPrefWidth(90.0);
        this.filterColor.valueProperty().addListener((ov, oldValue, newValue) -> this.cardCatalog.getSearchFilter().filterColor(CardConst.CardColor.getColorByLabel(newValue)));
        ToggleButton buttonToggleColor2 = new ToggleButton("+");
        buttonToggleColor2.setMaxWidth(10.0);
        ComboBox filterColor2 = new ComboBox(OptionFilters.getColorList());
        filterColor2.getItems().removeLast();
        filterColor2.getSelectionModel().selectFirst();
        filterColor2.setPrefWidth(90.0);
        filterColor2.valueProperty().addListener((ov, oldValue, newValue) -> this.cardCatalog.getSearchFilter().filterColor2(CardConst.CardColor.getColorByLabel(newValue)));
        filterColor2.visibleProperty().bind((ObservableValue)buttonToggleColor2.selectedProperty());
        filterColor2.managedProperty().bind((ObservableValue)buttonToggleColor2.selectedProperty());
        boxColor.getChildren().addAll((Object[])new Node[]{this.filterColor, filterColor2});
        buttonToggleColor2.setOnAction(e -> {
            boolean isSelected = buttonToggleColor2.isSelected();
            buttonToggleColor2.setMinHeight(!isSelected ? 0.0 : this.filterColor.getHeight() * 2.0);
            if (!isSelected) {
                filterColor2.getSelectionModel().selectFirst();
            }
        });
        boxFilterColor.getChildren().addAll((Object[])new Node[]{boxColor, buttonToggleColor2});
        Label labelTypeLRIG = new Label(LanguageParser.getString("UI_DECK_FILTER_LRIG"));
        this.filterLRIGType = new ComboBox(OptionFilters.getLRIGTypeList());
        this.filterLRIGType.getSelectionModel().selectFirst();
        this.filterLRIGType.setPrefWidth(100.0);
        this.filterLRIGType.valueProperty().addListener((ov, oldValue, newValue) -> this.cardCatalog.getSearchFilter().filterLRIGType(CardConst.CardLRIGType.getLRIGTypeByLabel(newValue)));
        Label labelSets = new Label(LanguageParser.getString("UI_DECK_FILTER_SETS"));
        this.filterSets = new ComboBox(OptionFilters.getSetsList());
        this.filterSets.getSelectionModel().selectFirst();
        this.filterSets.setPrefWidth(100.0);
        this.filterSets.valueProperty().addListener((ov, oldValue, newValue) -> this.cardCatalog.getSearchFilter().filterSets(OptionFilters.parseSetOptionFilter(newValue)));
        grid.add((Node)labelType, 0, 0);
        grid.add(this.filterType, 1, 0);
        grid.add((Node)labelColor, 2, 0);
        grid.add((Node)boxFilterColor, 3, 0);
        grid.add((Node)labelTypeLRIG, 4, 0);
        grid.add(this.filterLRIGType, 5, 0);
        grid.add((Node)labelSets, 6, 0);
        grid.add(this.filterSets, 7, 0);
        Label labelLevel = new Label(LanguageParser.getString("UI_DECK_FILTER_LEVEL"));
        this.filterLevel = new TextField();
        this.filterLevel.setPrefWidth(10.0);
        this.filterLevel.setTextFormatter(OptionFilters.formatterNumerical());
        this.filterLevel.textProperty().addListener((ov, oldValue, newValue) -> this.cardCatalog.getSearchFilter().filterLevel(OptionFilters.parseNumberOptionFilter(newValue)));
        this.filterLevel.disableProperty().addListener((ov, oldValue, newValue) -> this.cardCatalog.getSearchFilter().filterLevel(OptionFilters.parseNumberOptionFilter(newValue != false ? "" : this.filterLevel.getText())));
        Label labelPower = new Label(LanguageParser.getString("UI_DECK_FILTER_POWER"));
        this.filterPower = new TextField();
        this.filterPower.setPromptText("\u00d71000");
        this.filterPower.setTextFormatter(OptionFilters.formatterNumerical());
        this.filterPower.setPrefWidth(10.0);
        this.filterPower.textProperty().addListener((ov, oldValue, newValue) -> this.cardCatalog.getSearchFilter().filterPower(OptionFilters.parseNumberOptionFilter(newValue)));
        this.filterPower.disableProperty().addListener((ov, oldValue, newValue) -> this.cardCatalog.getSearchFilter().filterPower(OptionFilters.parseNumberOptionFilter(newValue != false ? "" : this.filterPower.getText())));
        Label labelClass = new Label(LanguageParser.getString("UI_DECK_FILTER_CLASS"));
        this.filterClass = new ComboBox(OptionFilters.getSIGNIClassList());
        this.filterClass.getSelectionModel().selectFirst();
        this.filterClass.setPrefWidth(100.0);
        this.filterClass.valueProperty().addListener((ov, oldValue, newValue) -> this.cardCatalog.getSearchFilter().filterClass(CardConst.CardSIGNIClass.getSIGNIClassByLabel(newValue)));
        this.filterClass.disableProperty().addListener((ov, oldValue, newValue) -> this.cardCatalog.getSearchFilter().filterClass(CardConst.CardSIGNIClass.getSIGNIClassByLabel(newValue != false ? (String)OptionFilters.getSIGNIClassList().getFirst() : (String)this.filterClass.getSelectionModel().getSelectedItem())));
        Label labelRestrict = new Label(LanguageParser.getString("UI_DECK_FILTER_RESTRICT"));
        this.filterRestrict = new ComboBox(OptionFilters.getRestrictList());
        this.filterRestrict.getSelectionModel().selectFirst();
        this.filterRestrict.setPrefWidth(100.0);
        this.filterRestrict.valueProperty().addListener((ov, oldValue, newValue) -> this.cardCatalog.getSearchFilter().filterRestrict(OptionFilters.parseRestrictOptionFilter(newValue), OptionFilters.parseSpecialRestrictOptionFilter(newValue)));
        grid.add((Node)labelLevel, 0, 1);
        grid.add((Node)this.filterLevel, 1, 1);
        grid.add((Node)labelPower, 2, 1);
        grid.add((Node)this.filterPower, 3, 1);
        grid.add((Node)labelClass, 4, 1);
        grid.add(this.filterClass, 5, 1);
        grid.add((Node)labelRestrict, 6, 1);
        grid.add(this.filterRestrict, 7, 1);
        Button buttonReset = new Button(LanguageParser.getString("UI_DECK_FILTER_BUTTON_RESET"));
        buttonReset.setPrefWidth(100.0);
        buttonReset.setOnAction(e -> UI.getTabDeck().getCardCatalog().getSearchFilter().applyFiltersInLockedState(filter -> {
            this.filterType.getSelectionModel().selectFirst();
            this.filterColor.getSelectionModel().selectFirst();
            if (buttonToggleColor2.isSelected()) {
                filterColor2.getSelectionModel().selectFirst();
            }
            this.filterLRIGType.getSelectionModel().selectFirst();
            this.filterSets.getSelectionModel().selectFirst();
            this.filterLevel.clear();
            this.filterPower.clear();
            this.filterClass.getSelectionModel().selectFirst();
            this.filterRestrict.getSelectionModel().selectFirst();
            this.filterLifeBurst.setIndeterminate(true);
            this.filterGuard.setIndeterminate(true);
            this.filterFormat.getSelectionModel().selectFirst();
            this.filterSearch.clear();
            if (this.pickerAdvancedFilters != null) {
                this.pickerAdvancedFilters.clear();
            }
        }));
        this.filterLifeBurst = new CheckBox(LanguageParser.getString("UI_DECK_FILTER_CHECKBOX_LIFEBURST"));
        this.filterLifeBurst.setAllowIndeterminate(true);
        this.filterLifeBurst.setIndeterminate(true);
        this.filterLifeBurst.selectedProperty().addListener((ov, oldValue, newValue) -> this.cardCatalog.getSearchFilter().filterLifeBurst(false, (boolean)newValue));
        this.filterLifeBurst.indeterminateProperty().addListener((ov, oldValue, newValue) -> this.cardCatalog.getSearchFilter().filterLifeBurst(true, (boolean)newValue));
        this.filterLifeBurst.disableProperty().addListener((ov, oldValue, newValue) -> this.cardCatalog.getSearchFilter().filterLifeBurst(newValue != false || this.filterLifeBurst.isIndeterminate(), newValue != false || this.filterLifeBurst.isSelected()));
        this.filterGuard = new CheckBox(LanguageParser.getString("UI_DECK_FILTER_CHECKBOX_GUARD"));
        this.filterGuard.setAllowIndeterminate(true);
        this.filterGuard.setIndeterminate(true);
        this.filterGuard.selectedProperty().addListener((ov, oldValue, newValue) -> this.cardCatalog.getSearchFilter().filterGuard(false, (boolean)newValue));
        this.filterGuard.indeterminateProperty().addListener((ov, oldValue, newValue) -> this.cardCatalog.getSearchFilter().filterGuard(true, (boolean)newValue));
        this.filterGuard.disableProperty().addListener((ov, oldValue, newValue) -> this.cardCatalog.getSearchFilter().filterGuard(newValue != false || this.filterGuard.isIndeterminate(), newValue != false || this.filterGuard.isSelected()));
        Label labelFormat = new Label(LanguageParser.getString("UI_DECK_FILTER_FORMAT"));
        this.filterFormat = new ComboBox(OptionFilters.getFormatList());
        this.filterFormat.getSelectionModel().selectFirst();
        this.filterFormat.setPrefWidth(120.0);
        this.filterFormat.valueProperty().addListener((ov, oldValue, newValue) -> {
            Settings.INSTANCE.setLastSelectedDeckBuilderFormat(this.filterFormat.getSelectionModel().getSelectedIndex());
            this.cardCatalog.getSearchFilter().filterFormat(OptionFilters.parseFormatOptionFilter(newValue));
        });
        this.messageCardsCount = new Text();
        GridPane.setHalignment((Node)this.messageCardsCount, (HPos)HPos.CENTER);
        this.updateCardsCountMessage(CardLoader.getTotalCards());
        HBox checkBoxFilterContainer = new HBox();
        checkBoxFilterContainer.setAlignment(Pos.CENTER_LEFT);
        checkBoxFilterContainer.setSpacing(20.0);
        checkBoxFilterContainer.getChildren().addAll((Object[])new Node[]{this.filterLifeBurst, this.filterGuard, labelFormat, this.filterFormat});
        grid.add((Node)buttonReset, 1, 2);
        grid.add((Node)checkBoxFilterContainer, 3, 2, 4, 1);
        grid.add((Node)this.messageCardsCount, 7, 2);
        ToggleButton buttonAdvanced = new ToggleButton(LanguageParser.getString("UI_DECK_FILTER_BUTTON_ADVANCED"));
        buttonAdvanced.setPrefWidth(100.0);
        buttonAdvanced.setOnAction(e -> {
            if (this.pickerAdvancedFilters == null) {
                this.pickerAdvancedFilters = new AdvancedFiltersPicker(buttonAdvanced);
            }
            if (this.deckContainer.getChildren().contains((Object)this.pickerAdvancedFilters)) {
                this.deckContainer.getChildren().remove((Object)this.pickerAdvancedFilters);
            } else {
                this.pickerAdvancedFilters.syncWithTheme();
                this.deckContainer.getChildren().add((Object)this.pickerAdvancedFilters);
            }
        });
        Label labelSearch = new Label(LanguageParser.getString("UI_DECK_FILTER_SEARCH"));
        this.filterSearch.setPromptText(LanguageParser.getString("UI_DECK_FILTER_SEARCH_HINT"));
        this.filterSearch.setPrefWidth(100.0);
        this.filterSearch.textProperty().addListener((ov, oldValue, newValue) -> this.cardCatalog.getSearchFilter().search((String)newValue));
        grid.add((Node)buttonAdvanced, 1, 3);
        grid.add((Node)labelSearch, 2, 3);
        grid.add((Node)this.filterSearch, 3, 3, 5, 1);
        return grid;
    }

    private void showDeck() {
        VBox content = new VBox();
        content.setSpacing(2.0);
        this.countBar = new CardCountBar();
        VBox.setMargin((Node)this.countBar, (Insets)new Insets(0.0, 1.0, -3.0, 1.0));
        this.countBarColors = new ColorsCountBar();
        BorderPane.setMargin((Node)this.countBarColors, (Insets)new Insets(0.0, -1.0, 1.0, 1.0));
        BorderPane containerMain = new BorderPane();
        this.flowPaneMain = new FlowPane();
        this.flowPaneMain.getStyleClass().add((Object)"ui_deck_panel");
        ScrollPane scrollMain = new ScrollPane((Node)this.flowPaneMain);
        scrollMain.setFitToWidth(true);
        scrollMain.setFitToHeight(true);
        scrollMain.setBackground(UIConst.Style.BACKGROUND_TRANSPARENT);
        VBox.setVgrow((Node)scrollMain, (Priority)Priority.ALWAYS);
        containerMain.setCenter((Node)scrollMain);
        containerMain.setLeft((Node)this.countBarColors);
        VBox.setVgrow((Node)containerMain, (Priority)Priority.ALWAYS);
        UtilDispose.PERM.attachChildDisposeListener((Node)this.flowPaneMain);
        this.flowPaneLRIG = new FlowPane();
        this.flowPaneLRIG.getStyleClass().add((Object)"ui_deck_panel");
        ScrollPane scrollLRIG = new ScrollPane((Node)this.flowPaneLRIG);
        scrollLRIG.setFitToWidth(true);
        scrollLRIG.setFitToHeight(true);
        scrollLRIG.setBackground(UIConst.Style.BACKGROUND_TRANSPARENT);
        scrollLRIG.setMinHeight(152.0);
        scrollLRIG.setMaxHeight(scrollLRIG.getMinHeight());
        UtilDispose.PERM.attachChildDisposeListener((Node)this.flowPaneLRIG);
        content.getChildren().addAll((Object[])new Node[]{this.countBar, containerMain, scrollLRIG});
        this.addToTab((Node)content, UITab.Position.CENTER, new Insets(5.0));
    }

    private void showCatalog() {
        this.cardCatalog = new CardCatalog(this::updateCardsCountMessage);
        this.cardCatalog.setSearchFilter(new SearchFilter(this.cardCatalog));
        this.addToTab((Node)this.cardCatalog, UITab.Position.RIGHT, new Insets(5.0));
    }

    public void setCardImageSetPicker(CardImageSetPicker picker) {
        if (this.picker != null) {
            this.deckContainer.getChildren().remove((Object)this.picker);
        }
        if (picker != null) {
            this.deckContainer.getChildren().add((Object)picker);
            picker.requestFocus();
        }
        this.picker = picker;
        this.getDeckBuilder().setDeckBuildingEnabled(picker == null);
    }

    public DeckBuilder getDeckBuilder() {
        return this.builder;
    }

    public CardPreview getCardPreview() {
        return this.cardPreview;
    }

    public CardCatalog getCardCatalog() {
        return this.cardCatalog;
    }

    private void updateCardsCountMessage(int count) {
        this.messageCardsCount.setText(LanguageParser.getString("UI_DECK_INFO_CARDS_NUM") + " " + count);
    }

    public void updateDeckInfo(int countMain, int countLRIG, int countLifeBurst) {
        this.messageDeckInfo.setText(LanguageParser.getString("UI_DECK_INFO_CARDS_NUM_MAIN") + " " + countMain + " / 40 (" + LanguageParser.getString("UI_DECK_INFO_CARDS_NUM_LIFEBURST") + " " + countLifeBurst + " / 20)\n" + LanguageParser.getString("UI_DECK_INFO_CARDS_NUM_LRIG") + " " + countLRIG + " / " + Settings.INSTANCE.getCurrentDeck().getLRIGCardsLimit());
    }

    public void updateDeckStatus() {
        Deck currentDeck = Settings.INSTANCE.getCurrentDeck();
        this.updateDeckInfo(currentDeck.getTotalCards(Deck.DeckType.MAIN), currentDeck.getTotalCards(Deck.DeckType.LRIG), currentDeck.getLifeBurstCount());
        Deck.DeckStatus deckStatus = currentDeck.getValidStatus();
        switch (deckStatus) {
            case ZEROLRIG: {
                this.messageDeckStatus.setText(LanguageParser.getString("UI_DECK_STATUS_ZEROLRIG"));
                break;
            }
            case CARDLIMIT_LIFEBURST: {
                this.messageDeckStatus.setText(LanguageParser.getFormattedString("UI_DECK_STATUS_COUNT_LIFEBURST", 20));
                break;
            }
            case CARDLIMIT_MAIN: {
                this.messageDeckStatus.setText(LanguageParser.getFormattedString("UI_DECK_STATUS_COUNT_MAIN", 40));
                break;
            }
            case CARDLIMIT_LRIG: {
                this.messageDeckStatus.setText(LanguageParser.getFormattedString("UI_DECK_STATUS_COUNT_LRIG", Settings.INSTANCE.getCurrentDeck().getLRIGCardsLimit()));
                break;
            }
            case CARDLIMIT_PIECE_LRIG: {
                this.messageDeckStatus.setText(LanguageParser.getString("UI_DECK_STATUS_PIECE_LRIG"));
                break;
            }
            case CARDLIMIT_PIECE: {
                this.messageDeckStatus.setText(LanguageParser.getFormattedString("UI_DECK_STATUS_PIECE_COUNT", 2));
                break;
            }
            case CARDLIMIT_PIECE_TEAM: {
                this.messageDeckStatus.setText(LanguageParser.getFormattedString("UI_DECK_STATUS_PIECE_COUNT_TEAM", 1));
                break;
            }
            case RESTRICTED_SPECIAL: {
                this.messageDeckStatus.setText(LanguageParser.getString("UI_DECK_STATUS_RESTRICTED"));
                break;
            }
            case RESTRICTED: {
                this.messageDeckStatus.setText(LanguageParser.getString("UI_DECK_STATUS_READY_RESTRICTED"));
                break;
            }
            case UNRELEASED: {
                this.messageDeckStatus.setText(LanguageParser.getString("UI_DECK_STATUS_READY_UNRELEASED"));
                break;
            }
            case READY: {
                this.messageDeckStatus.setText(LanguageParser.getString("UI_DECK_STATUS_READY"));
            }
        }
        this.iconListCompatibleFormats.getChildren().clear();
        for (CardConst.PlayFormat playFormat : CardConst.PlayFormat.values()) {
            if (playFormat == CardConst.PlayFormat.ALLSTAR || !currentDeck.isPlayFormatCompatible(playFormat)) continue;
            ImageView iconFormat = new ImageView(ImageCache.INSTANCE.getImageIcon(ImageCache.getPlayFormatIconPath(playFormat)));
            if (!currentDeck.containsFormatRestrictedCards(playFormat)) {
                this.iconListCompatibleFormats.getChildren().add((Object)iconFormat);
                continue;
            }
            StackPane containerIcon = new StackPane();
            ImageView iconWarn = new ImageView(ImageCache.INSTANCE.getImageIcon("restrict/special"));
            iconWarn.setPreserveRatio(true);
            iconWarn.setFitWidth(16.0);
            StackPane.setAlignment((Node)iconWarn, (Pos)Pos.BOTTOM_LEFT);
            containerIcon.getChildren().addAll((Object[])new Node[]{iconFormat, iconWarn});
            this.iconListCompatibleFormats.getChildren().add((Object)containerIcon);
        }
        if (deckStatus == Deck.DeckStatus.READY || deckStatus == Deck.DeckStatus.UNRELEASED) {
            this.iconDeckStatus.setImage(ImageCache.INSTANCE.getImageIcon("ui/good"));
            this.messageDeckStatus.getStyleClass().removeAll((Object[])new String[]{"ui_deck_panel_text_red"});
        } else {
            this.iconDeckStatus.setImage(ImageCache.INSTANCE.getImageIcon("ui/bad"));
            this.messageDeckStatus.getStyleClass().add((Object)"ui_deck_panel_text_red");
        }
    }

    public CardCountBar getCardCountBar() {
        return this.countBar;
    }

    public ColorsCountBar getColorsCountBar() {
        return this.countBarColors;
    }

    public FlowPane getDeckContainerNode(Deck.DeckType deckType) {
        return deckType == Deck.DeckType.MAIN ? this.flowPaneMain : this.flowPaneLRIG;
    }

    public void updateCurrentDeckFileName() {
        this.deckFileNameTextBox.setText(Settings.INSTANCE.getCurrentDeck().getSourceFileName());
    }

    public Button getButtonLoad() {
        return this.buttonLoad;
    }

    public Button getButtonSave() {
        return this.buttonSave;
    }

    public Button getButtonClear() {
        return this.buttonClear;
    }

    private void toggleFiltersByCardType(CardConst.CardType filterType) {
        this.filterLevel.setDisable(filterType != null && filterType != CardConst.CardType.LRIG && filterType != CardConst.CardType.LRIG_ASSIST && filterType != CardConst.CardType.SIGNI && filterType != CardConst.CardType.RESONA);
        this.filterPower.setDisable(filterType != null && filterType != CardConst.CardType.SIGNI && filterType != CardConst.CardType.RESONA);
        this.filterClass.setDisable(filterType != null && filterType != CardConst.CardType.SIGNI && filterType != CardConst.CardType.RESONA);
        this.filterLifeBurst.setDisable(filterType != null && filterType != CardConst.CardType.SIGNI && filterType != CardConst.CardType.SPELL);
        this.filterGuard.setDisable(filterType != null && filterType != CardConst.CardType.SIGNI);
        if (this.pickerAdvancedFilters != null) {
            this.pickerAdvancedFilters.toggleFiltersByCardType(filterType);
        }
    }
}

