/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.game;

import javafx.animation.FadeTransition;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import open.batoru.Log;
import open.batoru.Main;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.EffectBucket;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.CardConst;
import open.batoru.data.ability.CardAbilities;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.game._3d.CardViewUnderCardsButton;
import open.batoru.game._3d.FieldScene;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.overlay.FieldSceneOverlay;
import open.batoru.game.overlay.OverlayOpeningBackground;
import open.batoru.networking.LogoutProcedure;
import open.batoru.ui.UI;
import open.batoru.ui.UIConst;
import open.batoru.ui.UITab;
import open.batoru.ui.UtilDispose;

public class UITabGame
extends UITab {
    private FieldScene fieldScene;
    private FieldSceneOverlay fieldSceneOverlay;
    private final StackPane fieldContainer = new StackPane();
    private OverlayOpeningBackground op;

    public UITabGame() {
        this.setGameBackground(null);
        this.addToTab((Node)this.fieldContainer, UITab.Position.CENTER, null);
    }

    private void setGameBackground(CardConst.PlayFormat playFormat) {
        if (playFormat == null) {
            this.fieldContainer.setBackground(UIConst.Style.BACKGROUND_BLACK);
        } else if (playFormat == CardConst.PlayFormat.KEY || playFormat == CardConst.PlayFormat.KEY_CLASSIC) {
            this.fieldContainer.setBackground(UIConst.Style.BACKGROUND_GAME_FIELD_KEY);
        } else {
            this.fieldContainer.setBackground(UIConst.Style.BACKGROUND_GAME_FIELD);
        }
    }

    public void prepareNewGame(String username, String usernameOP) {
        UI.selectTab(UI.getTabGame());
        UI.setTabInfo(UI.getTabGame(), " (" + username + " vs " + usernameOP + ")");
        this.fieldSceneOverlay = new FieldSceneOverlay();
        this.fieldContainer.getChildren().add((Object)this.fieldSceneOverlay.getRootNode());
        this.fieldSceneOverlay.getRootNode().maxWidthProperty().bind((ObservableValue)this.fieldContainer.widthProperty());
        this.fieldSceneOverlay.getRootNode().maxHeightProperty().bind((ObservableValue)this.fieldContainer.heightProperty());
        this.op = new OverlayOpeningBackground();
        this.fieldSceneOverlay.getRootNode().getChildren().add((Object)this.op);
        this.op.playAnimation();
    }

    public void initNewGame() {
        if (Game.getCurrentGame() == null) {
            return;
        }
        this.op.stopAnimation();
        this.fieldSceneOverlay.getRootNode().getChildren().remove((Object)this.op);
        this.setGameBackground(Game.getCurrentGame().getRoom().getPlayFormat());
        this.fieldSceneOverlay.showGameMessage(null);
        this.fieldSceneOverlay.initGameNodes();
        Log.prepare();
        Log.printMessage("GAME: #" + Game.getCurrentGame().getGameId());
        this.fieldScene = new FieldScene();
        this.fieldContainer.getChildren().addFirst((Object)this.fieldScene.getScene());
        this.fieldScene.getScene().widthProperty().bind((ObservableValue)this.fieldContainer.widthProperty());
        this.fieldScene.getScene().heightProperty().bind((ObservableValue)this.fieldContainer.heightProperty());
        this.fieldScene.getGameField().initField();
        this.fieldScene.installCameraTestControls(Main.getStage().getScene());
        Rectangle rec = new Rectangle();
        rec.setMouseTransparent(true);
        rec.setFill((Paint)Color.WHITE);
        rec.widthProperty().bind((ObservableValue)this.fieldSceneOverlay.getRootNode().widthProperty());
        rec.heightProperty().bind((ObservableValue)this.fieldSceneOverlay.getRootNode().heightProperty());
        FadeTransition fade = new FadeTransition(Duration.millis((double)1500.0), (Node)rec);
        fade.setFromValue(1.0);
        fade.setToValue(0.0);
        this.fieldSceneOverlay.getRootNode().getChildren().add((Object)rec);
        fade.play();
        fade.setOnFinished(e -> {
            if (this.fieldSceneOverlay != null) {
                this.fieldSceneOverlay.getRootNode().getChildren().remove((Object)rec);
            }
            rec.widthProperty().unbind();
            rec.heightProperty().unbind();
        });
    }

    public void closeGame() {
        this.closeGame(true);
    }

    public void closeGame(boolean shouldCloseRoom) {
        if (this.fieldSceneOverlay == null) {
            return;
        }
        AnimationTracker.stopAllRunningAnimations();
        UI.setTabInfo(UI.getTabGame(), "");
        UI.setTabEnabled(UI.getTabGame(), false);
        if (UI.isTabEnabled(UI.getTabRooms())) {
            UI.selectTab(UI.getTabRooms());
            if (shouldCloseRoom) {
                if (Player.getCurrentRoom() != null) {
                    int roomId = Player.getCurrentRoom().getRoomId();
                    UI.getTabRooms().getRoomListLive().removeEntry(roomId);
                    UI.getTabRooms().getRoomListOpen().removeEntry(roomId);
                    Player.setCurrentRoom(null);
                }
                UI.getTabRooms().getControls().toggleRoomControls(false);
                UI.getTabRooms().getControls().getControlsCreate().setRoomCreationEnabled(true);
                UI.getTabRooms().getControls().getControlsOpen().setListControlsEnabled(true);
            }
        } else {
            UI.selectTab(UI.getTabHome());
        }
        if (Game.getCurrentGame() != null) {
            LogoutProcedure.disconnectGame();
            CardViewUnderCardsButton.clearAllowedUnderTargetsList();
            if (this.fieldScene != null) {
                this.fieldScene.getGameField().clearAll();
            }
            Game.getCurrentGame().getActionQueue().stop();
            if (AbilityCost.getCallbackAction() != null) {
                AbilityCost.getCallbackAction().getCallbackThread().interrupt();
                AbilityCost.setCallbackAction(null);
            }
            if (CardAbilities.getEffectCallbackAction() != null) {
                CardAbilities.getEffectCallbackAction().getCallbackThread().interrupt();
                CardAbilities.setEffectCallbackAction(null);
            }
        }
        if (!UI.isTabEnabled(UI.getTabRooms()) && Player.getNetworkFrame().getGameReceiver() != null) {
            Player.getNetworkFrame().getGameReceiver().end();
        }
        TargetFilter.setDefaultSources(null, null);
        EffectBucket.setLastAbilityAndEvent(null, null);
        EffectBucket.setCurrentResolvingAbilityAndEvent(null, null);
        Game.setCurrentGame(null);
        this.setGameBackground(null);
        if (this.fieldScene != null) {
            this.fieldScene.dispose();
        }
        this.fieldSceneOverlay.dispose();
        this.fieldSceneOverlay = null;
        this.fieldContainer.getChildren().clear();
        UtilDispose.TEMP.clearAllDisposeListeners();
        System.gc();
    }

    public FieldScene getFieldScene() {
        return this.fieldScene;
    }

    public FieldSceneOverlay getFieldSceneOverlay() {
        return this.fieldSceneOverlay;
    }
}

