/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.rooms;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import open.batoru.ImageCache;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.rooms.Room;
import open.batoru.core.rooms.RoomPlayerData;
import open.batoru.networking.UsernameData;
import open.batoru.networking.service.GameDataDownloadService;
import open.batoru.replays.ReplayDataParser;
import open.batoru.replays.ReplayStartProcedure;
import open.batoru.replays.UtilReplays;
import open.batoru.ui.UI;
import open.batoru.ui.UsernameDisplay;
import open.batoru.ui.rooms.RoomListEntry;

public class LiveGameEntry
extends RoomListEntry {
    private Text textSpec;
    private final Text textTurn;
    private final Text[] textTurnPlayerArrow = new Text[2];
    private ChangeListener<Number> listenerTextSpec = (ov, oldValue, newValue) -> this.setSpectatorCount(newValue.intValue());
    private ChangeListener<Number> listenerTextTurn = (ov, oldValue, newValue) -> this.setTurnCount(newValue.intValue());
    private ChangeListener<Number> listenerTextTurnPlayer = (ov, oldValue, newValue) -> this.setTurnPlayerRoleId(oldValue.intValue(), newValue.intValue());
    private final ImageView[] imageLRIGCenter = new ImageView[2];
    private final ImageView[] imageLRIGAssistLeft = new ImageView[2];
    private final ImageView[] imageLRIGAssistRight = new ImageView[2];
    private final LifeClothIndicatorBox[] lcBox = new LifeClothIndicatorBox[2];
    private final KeysIndicatorBox[] keysBox = new KeysIndicatorBox[2];
    private final List<ChangeListener<Number>> listenerLCBox = new ArrayList<ChangeListener<Number>>();
    private final List<ChangeListener<String>> listenerKeys = new ArrayList<ChangeListener<String>>();
    private static boolean isDownloadingSpecData;

    public LiveGameEntry(Room room) {
        super(room);
        this.listenerLCBox.add((ChangeListener<Number>)((ChangeListener)(ov, oldValue, newValue) -> this.lcBox[0].setCount(newValue.intValue())));
        this.listenerLCBox.add((ChangeListener<Number>)((ChangeListener)(ov, oldValue, newValue) -> this.lcBox[1].setCount(newValue.intValue())));
        this.listenerKeys.add((ChangeListener<String>)((ChangeListener)(ov, oldValue, newValue) -> this.keysBox[0].updateValue((String)oldValue, (String)newValue)));
        this.listenerKeys.add((ChangeListener<String>)((ChangeListener)(ov, oldValue, newValue) -> this.keysBox[1].updateValue((String)oldValue, (String)newValue)));
        if (room.areSpectatorsAllowed()) {
            this.textSpec = new Text();
            this.setSpectatorCount(0);
            StackPane.setAlignment((Node)this.textSpec, (Pos)Pos.TOP_LEFT);
            this.getContent().getChildren().add((Object)this.textSpec);
            this.setOnMouseClicked(e -> this.onActionRoomSpectate());
        }
        this.textTurn = new Text();
        this.setTurnCount(0);
        StackPane.setAlignment((Node)this.textTurn, (Pos)Pos.TOP_RIGHT);
        StackPane boxContent = new StackPane();
        StackPane.setMargin((Node)boxContent, (Insets)new Insets(16.0, 0.0, 16.0, 0.0));
        this.lcBox[0] = new LifeClothIndicatorBox();
        this.lcBox[1] = new LifeClothIndicatorBox();
        StackPane.setAlignment((Node)this.lcBox[0], (Pos)Pos.CENTER_LEFT);
        StackPane.setAlignment((Node)this.lcBox[1], (Pos)Pos.CENTER_RIGHT);
        Text textVS = new Text("vs");
        HBox contentVS = new HBox();
        contentVS.setSpacing(25.0);
        contentVS.getChildren().add((Object)this.newUsernameText(room.getPlayerData(Game.GamePlayerRole.HOST).getPlayerName(), true));
        contentVS.getChildren().add((Object)this.newUsernameText(room.getPlayerData(Game.GamePlayerRole.GUEST).getPlayerName(), false));
        StackPane boxLRIGLeft = new StackPane();
        boxLRIGLeft.setMaxSize(90.0, 105.0);
        boxLRIGLeft.setMinSize(90.0, 105.0);
        StackPane boxLeftImageLRIGCenter = new StackPane();
        this.imageLRIGCenter[0] = LiveGameEntry.newCardImage(true);
        this.textTurnPlayerArrow[0] = new Text("\u25bc");
        this.textTurnPlayerArrow[0].setFont(Font.font((double)10.0));
        this.textTurnPlayerArrow[0].setVisible(false);
        StackPane.setMargin((Node)this.textTurnPlayerArrow[0], (Insets)new Insets(5.0, 0.0, 0.0, 40.0));
        StackPane.setAlignment((Node)this.textTurnPlayerArrow[0], (Pos)Pos.TOP_CENTER);
        boxLeftImageLRIGCenter.getChildren().addAll((Object[])new Node[]{this.textTurnPlayerArrow[0], this.imageLRIGCenter[0]});
        StackPane.setAlignment((Node)this.imageLRIGCenter[0], (Pos)Pos.CENTER_RIGHT);
        this.imageLRIGAssistLeft[0] = LiveGameEntry.newCardImage(false);
        StackPane.setAlignment((Node)this.imageLRIGAssistLeft[0], (Pos)Pos.TOP_LEFT);
        this.imageLRIGAssistRight[0] = LiveGameEntry.newCardImage(false);
        StackPane.setAlignment((Node)this.imageLRIGAssistRight[0], (Pos)Pos.BOTTOM_LEFT);
        this.keysBox[0] = new KeysIndicatorBox(true);
        StackPane.setMargin((Node)this.keysBox[0], (Insets)new Insets(-10.0, -50.0, 0.0, 0.0));
        StackPane.setAlignment((Node)this.keysBox[0], (Pos)Pos.TOP_RIGHT);
        boxLRIGLeft.getChildren().addAll((Object[])new Node[]{this.imageLRIGAssistLeft[0], this.imageLRIGAssistRight[0], boxLeftImageLRIGCenter, this.keysBox[0]});
        StackPane boxLRIGRight = new StackPane();
        boxLRIGRight.setMaxSize(90.0, 105.0);
        boxLRIGRight.setMinSize(90.0, 105.0);
        StackPane boxRightImageLRIGCenter = new StackPane();
        this.imageLRIGCenter[1] = LiveGameEntry.newCardImage(true);
        this.textTurnPlayerArrow[1] = new Text("\u25bc");
        this.textTurnPlayerArrow[1].setFont(Font.font((double)10.0));
        this.textTurnPlayerArrow[1].setVisible(false);
        StackPane.setMargin((Node)this.textTurnPlayerArrow[1], (Insets)new Insets(5.0, 40.0, 0.0, 0.0));
        StackPane.setAlignment((Node)this.textTurnPlayerArrow[1], (Pos)Pos.TOP_CENTER);
        boxRightImageLRIGCenter.getChildren().addAll((Object[])new Node[]{this.textTurnPlayerArrow[1], this.imageLRIGCenter[1]});
        StackPane.setAlignment((Node)this.imageLRIGCenter[1], (Pos)Pos.CENTER_LEFT);
        this.imageLRIGAssistLeft[1] = LiveGameEntry.newCardImage(false);
        StackPane.setAlignment((Node)this.imageLRIGAssistLeft[1], (Pos)Pos.TOP_RIGHT);
        this.imageLRIGAssistRight[1] = LiveGameEntry.newCardImage(false);
        StackPane.setAlignment((Node)this.imageLRIGAssistRight[1], (Pos)Pos.BOTTOM_RIGHT);
        this.keysBox[1] = new KeysIndicatorBox(false);
        StackPane.setMargin((Node)this.keysBox[1], (Insets)new Insets(-10.0, 0.0, 0.0, -50.0));
        StackPane.setAlignment((Node)this.keysBox[1], (Pos)Pos.TOP_LEFT);
        boxLRIGRight.getChildren().addAll((Object[])new Node[]{this.imageLRIGAssistLeft[1], this.imageLRIGAssistRight[1], boxRightImageLRIGCenter, this.keysBox[1]});
        StackPane.setMargin((Node)boxLRIGLeft, (Insets)new Insets(0.0, 310.0, 0.0, 0.0));
        StackPane.setMargin((Node)boxLRIGRight, (Insets)new Insets(0.0, 0.0, 0.0, 310.0));
        boxContent.getChildren().addAll((Object[])new Node[]{boxLRIGLeft, boxLRIGRight, this.lcBox[0], this.lcBox[1], textVS, contentVS});
        ImageView background = new ImageView(ImageCache.INSTANCE.getImageIcon(ImageCache.getPlayFormatIconPath(room.getPlayFormat(), false)));
        background.setOpacity(0.15);
        StackPane.setAlignment((Node)background, (Pos)Pos.CENTER);
        Object settingsString = "";
        if (room.areUnreleasedCardsAllowed()) {
            settingsString = (String)settingsString + "\u231b ";
        }
        if (room.areRestrictedCardsAllowed()) {
            settingsString = (String)settingsString + "\u26d4 ";
        }
        settingsString = (String)settingsString + room.getPlayFormat().getLabel();
        Text textFormat = new Text((String)settingsString);
        StackPane.setAlignment((Node)textFormat, (Pos)Pos.BOTTOM_LEFT);
        this.getContent().getChildren().addFirst((Object)background);
        this.getContent().getChildren().addAll((Object[])new Node[]{this.textTurn, boxContent, textFormat});
        this.bindValues();
        this.bindPlayerValues(Game.GamePlayerRole.HOST);
        this.bindPlayerValues(Game.GamePlayerRole.GUEST);
    }

    private void bindValues() {
        if (this.textSpec != null) {
            this.getRoom().getSpectatorCountProperty().addListener(this.listenerTextSpec);
        }
        this.getRoom().getTurnCountProperty().addListener(this.listenerTextTurn);
        this.getRoom().getTurnPlayerRoleIdProperty().addListener(this.listenerTextTurnPlayer);
    }

    private void bindPlayerValues(Game.GamePlayerRole rolePlayer) {
        RoomPlayerData data = this.getRoom().getPlayerData(rolePlayer);
        int roleId = rolePlayer.getId();
        this.bindImage(this.imageLRIGCenter[roleId], data.getLRIGCenterImageProperty());
        this.bindImage(this.imageLRIGAssistLeft[roleId], data.getLRIGAssistLeftImageProperty());
        this.bindImage(this.imageLRIGAssistRight[roleId], data.getLRIGAssistRightImageProperty());
        data.getLifeClothCountProperty().addListener(this.listenerLCBox.get(roleId));
        data.getKeysImagesProperty().addListener(this.listenerKeys.get(roleId));
    }

    private void bindImage(ImageView imageView, StringProperty imageProperty) {
        imageView.imageProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            String imageSet = (String)imageProperty.get();
            if (imageSet == null) {
                return ImageCache.INSTANCE.getLRIGCardBackImage();
            }
            if (imageSet.isEmpty()) {
                return null;
            }
            return ImageCache.INSTANCE.getCardImage(imageSet);
        }, (Observable[])new Observable[]{imageProperty}));
    }

    private void unbindValues() {
        if (this.textSpec != null) {
            this.getRoom().getSpectatorCountProperty().removeListener(this.listenerTextSpec);
        }
        this.getRoom().getTurnCountProperty().removeListener(this.listenerTextTurn);
        this.getRoom().getTurnPlayerRoleIdProperty().removeListener(this.listenerTextTurnPlayer);
    }

    private void unbindPlayerValues(Game.GamePlayerRole rolePlayer) {
        int roleId = rolePlayer.getId();
        this.imageLRIGCenter[roleId].imageProperty().unbind();
        this.imageLRIGAssistLeft[roleId].imageProperty().unbind();
        this.imageLRIGAssistRight[roleId].imageProperty().unbind();
        this.getRoom().getPlayerData(rolePlayer).getLifeClothCountProperty().removeListener(this.listenerLCBox.get(roleId));
        this.getRoom().getPlayerData(rolePlayer).getKeysImagesProperty().removeListener(this.listenerKeys.get(roleId));
    }

    @Override
    public void onMouseEntered() {
        if (!this.getRoom().areSpectatorsAllowed() || !UtilReplays.canWatchGames()) {
            return;
        }
        super.onMouseEntered();
        if (Game.getCurrentGame() == null) {
            this.setCursor(Cursor.HAND);
        }
    }

    @Override
    public void onMouseExited() {
        super.onMouseExited();
        if (this.getCursor() == Cursor.HAND) {
            this.setCursor(Cursor.DEFAULT);
        }
    }

    @Override
    public void select() {
        super.select();
        if (Player.getCurrentRoom() == this.getRoom()) {
            UI.getTabRooms().getControls().getControlsCreate().setRoomCreationEnabled(false);
        }
    }

    private void onActionRoomSpectate() {
        if (isDownloadingSpecData || !this.getRoom().areSpectatorsAllowed() || this.isSelected() || !UtilReplays.canWatchGames() || this.getRoom().getTurnCountProperty().get() == 0) {
            return;
        }
        isDownloadingSpecData = true;
        GameDataDownloadService service = new GameDataDownloadService(this.getRoom().getGameId(), pathTemp -> {
            isDownloadingSpecData = false;
            if (!UtilReplays.canWatchGames()) {
                return;
            }
            ReplayDataParser parser = new ReplayDataParser(pathTemp);
            parser.parse();
            ReplayStartProcedure.playAsSpectator(parser, this.getRoom());
        });
        service.start();
    }

    private StackPane newUsernameText(String username, boolean isLeft) {
        StackPane content = new StackPane();
        content.setAlignment(isLeft ? Pos.CENTER_RIGHT : Pos.CENTER_LEFT);
        if (UsernameData.getBadgeIds(username) == null) {
            username = UsernameData.updateAndGet(username);
        }
        UsernameDisplay usernameDisplay = new UsernameDisplay(username, Orientation.VERTICAL);
        usernameDisplay.setBoxAlignment(isLeft ? Pos.CENTER_RIGHT : Pos.CENTER_LEFT);
        if (isLeft) {
            usernameDisplay.setTextAlignment(TextAlignment.RIGHT);
        }
        usernameDisplay.setTextWrappingWidth(100);
        content.getChildren().add((Object)usernameDisplay);
        content.prefWidthProperty().bind((ObservableValue)this.getContent().widthProperty().multiply(0.5));
        return content;
    }

    private static ImageView newCardImage(boolean isCenter) {
        double multi = isCenter ? 0.8 : 0.6;
        double width = 63.0 * multi;
        double height = 87.0 * multi;
        double borderRadius = 9.0 * multi;
        ImageView cardImage = new ImageView(isCenter ? ImageCache.INSTANCE.getLRIGCardBackImage() : null);
        cardImage.setFitWidth(width);
        cardImage.setFitHeight(height);
        Rectangle clip = new Rectangle(width, height);
        clip.setArcWidth(borderRadius);
        clip.setArcHeight(borderRadius);
        cardImage.setClip((Node)clip);
        return cardImage;
    }

    private void setSpectatorCount(int count) {
        if (this.textSpec != null) {
            this.textSpec.setText("\ud83d\udc41 " + count);
        }
        if (Game.getCurrentGame() != null && Game.getCurrentGame().getRoom() == this.getRoom()) {
            UI.getTabGame().getFieldSceneOverlay().updateSpectatorControls(count);
        }
    }

    private void setTurnCount(int count) {
        this.textTurn.setText("\u231b " + count);
    }

    private void setTurnPlayerRoleId(int oldRoleId, int roleId) {
        if (oldRoleId != -1) {
            this.textTurnPlayerArrow[oldRoleId].setVisible(false);
        }
        this.textTurnPlayerArrow[roleId].setVisible(true);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.unbindValues();
        this.unbindPlayerValues(Game.GamePlayerRole.HOST);
        this.unbindPlayerValues(Game.GamePlayerRole.GUEST);
        this.listenerLCBox.clear();
        this.listenerTextSpec = null;
        this.listenerTextTurn = null;
        this.listenerTextTurnPlayer = null;
    }

    public static class LifeClothIndicatorBox
    extends VBox {
        private static final String MARK_FILLED = "\u26ab";
        private static final String MARK_EMPTY = "\u26aa";

        public LifeClothIndicatorBox() {
            this.setAlignment(Pos.CENTER);
            this.setMaxWidth(15.0);
            this.setSpacing(-2.0);
            for (int i = 0; i < 7; ++i) {
                this.getChildren().add((Object)new Text(MARK_FILLED));
            }
        }

        public void setCount(int count) {
            for (int i = 0; i <= this.getChildren().size() - 1; ++i) {
                String newMark;
                Text text = (Text)this.getChildren().get(i);
                String string = newMark = this.getChildren().size() - 1 - i < count ? MARK_FILLED : MARK_EMPTY;
                if (text.getText().equals(newMark)) continue;
                text.setText(newMark);
            }
        }
    }

    public static class KeysIndicatorBox
    extends VBox {
        public KeysIndicatorBox(boolean isLeft) {
            this.setAlignment(isLeft ? Pos.BASELINE_RIGHT : Pos.BASELINE_LEFT);
            this.setSpacing(-40.0);
        }

        public void updateValue(String oldValue, String newValue) {
            String[] imageSets;
            if (oldValue != null && !oldValue.isEmpty()) {
                this.getChildren().clear();
            }
            if (newValue == null || newValue.isEmpty()) {
                return;
            }
            for (String imageSet : imageSets = newValue.split("~")) {
                ImageView image = LiveGameEntry.newCardImage(false);
                image.setRotate(90.0);
                image.setImage(ImageCache.INSTANCE.getCardImage(imageSet));
                this.getChildren().add((Object)image);
            }
        }
    }
}

