/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.rooms;

import java.util.Optional;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.Text;
import open.batoru.ImageCache;
import open.batoru.Settings;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.rooms.Room;
import open.batoru.data.CardConst;
import open.batoru.networking.connection.RoomGuestJoinAttempt;
import open.batoru.networking.connection.RoomGuestLeaveAttempt;
import open.batoru.networking.connection.RunnableConnection;
import open.batoru.networking.service.UpdateProcedureService;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.ThinkingText;
import open.batoru.ui.UI;
import open.batoru.ui.UserAttentionNotifier;
import open.batoru.ui.UsernameDisplay;
import open.batoru.ui.deck.DeckCompatibilityService;
import open.batoru.ui.rooms.RoomListEntry;

public class OpenRoomEntry
extends RoomListEntry {
    private final HBox containerButton = new HBox();
    private final Button buttonLeave;
    private final ThinkingText textWaiting;
    private final UsernameDisplay usernameDisplay;
    private final int roomFlags;
    private final CardConst.PlayFormat playFormat;

    public OpenRoomEntry(Room room, String description) {
        super(room);
        this.setMinHeight(85.0);
        this.roomFlags = room.getRoomFlags();
        this.playFormat = room.getPlayFormat();
        Room.StartingPlayer startingPlayer = room.getStartingPlayer();
        this.usernameDisplay = new UsernameDisplay(room.getPlayerData(Game.GamePlayerRole.HOST).getPlayerName(), Orientation.HORIZONTAL);
        Text textDescription = new Text(description);
        textDescription.setFill((Paint)Color.DIMGREY);
        textDescription.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontPosture)FontPosture.ITALIC, (double)12.0));
        Object settingsString = "";
        if (room.areSpectatorsAllowed()) {
            settingsString = (String)settingsString + "\ud83d\udc41 ";
        }
        if (room.areUnreleasedCardsAllowed()) {
            settingsString = (String)settingsString + "\u231b ";
        }
        if (room.areRestrictedCardsAllowed()) {
            settingsString = (String)settingsString + "\u26d4 ";
        }
        settingsString = (String)settingsString + this.playFormat.getLabel();
        if (startingPlayer != Room.StartingPlayer.RANDOM) {
            settingsString = (String)settingsString + " (" + startingPlayer.getLabel() + " " + LanguageParser.getString("UI_ROOM_START_PLAYER_INFO") + ")";
        }
        Text textSettings = new Text((String)settingsString);
        textSettings.setFont(Font.font((String)"file:fonts/Symbola-12.ttf"));
        StackPane.setAlignment((Node)this.usernameDisplay, (Pos)Pos.TOP_LEFT);
        StackPane.setAlignment((Node)textDescription, (Pos)Pos.CENTER_LEFT);
        StackPane.setAlignment((Node)textSettings, (Pos)Pos.BOTTOM_LEFT);
        this.containerButton.setSpacing(5.0);
        this.containerButton.setAlignment(Pos.CENTER_LEFT);
        this.containerButton.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
        this.buttonLeave = new Button(LanguageParser.getString("UI_ROOM_LEAVE_BUTTON"));
        this.textWaiting = new ThinkingText(LanguageParser.getString("UI_ROOM_WAIT_HOST"));
        this.textWaiting.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontPosture)FontPosture.ITALIC, (double)12.0));
        this.containerButton.getChildren().addAll((Object[])new Node[]{this.buttonLeave, this.textWaiting});
        this.getContentExtra().getChildren().add((Object)this.containerButton);
        this.containerButton.setVisible(false);
        this.containerButton.setManaged(false);
        ImageView background = new ImageView(ImageCache.INSTANCE.getImageIcon(ImageCache.getPlayFormatIconPath(this.playFormat, false)));
        background.setOpacity(0.25);
        StackPane.setAlignment((Node)background, (Pos)Pos.CENTER_RIGHT);
        this.getContent().getChildren().addAll((Object[])new Node[]{background, this.usernameDisplay, textDescription, textSettings});
        this.setOnMouseClicked(e -> this.onActionRoomJoin());
        this.buttonLeave.setOnAction(e -> this.onActionRoomLeave());
    }

    @Override
    public void select() {
        if (!this.isSelected()) {
            this.usernameDisplay.setBoxStyle("ui_rooms_panel_list_entry_selected_badge_outline", true);
        }
        super.select();
    }

    @Override
    public void deselect() {
        if (this.isSelected()) {
            this.usernameDisplay.setBoxStyle("ui_rooms_panel_list_entry_selected_badge_outline", false);
        }
        super.deselect();
    }

    private void onActionRoomJoin() {
        if (Player.getCurrentRoom() != null) {
            return;
        }
        DeckCompatibilityService service = new DeckCompatibilityService();
        Optional<String> message = service.getCompatibilityMessage(Settings.INSTANCE.getCurrentPlayDeck(), (this.roomFlags & 2) != 0, (this.roomFlags & 4) != 0, this.playFormat);
        if (message.isPresent()) {
            new Alert(Alert.AlertType.WARNING, message.get(), new ButtonType[0]).showAndWait();
            return;
        }
        UI.getTabRooms().getControls().getControlsCreate().setRoomCreationEnabled(false);
        UI.getTabRooms().getControls().setDeckLoadButtonEnabled(false);
        this.setOnMouseClicked(null);
        RunnableConnection connection = new RunnableConnection(() -> new RoomGuestJoinAttempt(this.getRoom().getRoomId()), (socketReceiver, pp, status) -> {
            if (status != RunnableConnection.ResponseStatus.SUCCESS) {
                if (status == RunnableConnection.ResponseStatus.TIMEOUT) {
                    new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_CONNECT_TIMEOUT_RETRY"), new ButtonType[0]).showAndWait();
                }
                UI.getTabRooms().getControls().getControlsCreate().setRoomCreationEnabled(true);
                UI.getTabRooms().getControls().setDeckLoadButtonEnabled(true);
                this.setOnMouseClicked(e -> this.onActionRoomJoin());
                if (pp != null && pp.getPacketData().equals("!6")) {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION, LanguageParser.getString("UI_ALERT_UPDATE"), new ButtonType[]{ButtonType.YES, ButtonType.NO});
                    alert.setHeaderText(LanguageParser.getString("UI_ALERT_UPDATE_HEADER"));
                    alert.showAndWait();
                    if (((ButtonType)alert.getResult()).getButtonData() != ButtonBar.ButtonData.YES) {
                        return;
                    }
                    UpdateProcedureService updateProcedure = new UpdateProcedureService(null);
                    updateProcedure.runAutoUpdater();
                }
                return;
            }
            if (Player.getCurrentRoom() != null) {
                return;
            }
            this.select();
            this.containerButton.setVisible(true);
            this.containerButton.setManaged(true);
            this.textWaiting.playAnimation();
        });
        new Thread(connection).start();
    }

    private void onActionRoomLeave() {
        if (Player.getCurrentRoom() == null) {
            return;
        }
        this.buttonLeave.setDisable(true);
        RunnableConnection connection = new RunnableConnection(() -> new RoomGuestLeaveAttempt(this.getRoom().getRoomId()), (socketReceiver, pp, status) -> {
            if (status != RunnableConnection.ResponseStatus.SUCCESS) {
                if (status == RunnableConnection.ResponseStatus.TIMEOUT) {
                    new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_CONNECT_TIMEOUT_RETRY"), new ButtonType[0]).showAndWait();
                }
                this.buttonLeave.setDisable(false);
                return;
            }
            if (Player.getCurrentRoom() == null) {
                return;
            }
            this.deselect();
            this.containerButton.setVisible(false);
            this.containerButton.setManaged(false);
            this.buttonLeave.setDisable(false);
            this.textWaiting.stopAnimation();
            UI.getTabRooms().getControls().getControlsCreate().setRoomCreationEnabled(true);
            UI.getTabRooms().getControls().setDeckLoadButtonEnabled(true);
            this.setOnMouseClicked(e -> this.onActionRoomJoin());
        });
        new Thread(connection).start();
    }

    public int getRoomFlags() {
        return this.roomFlags;
    }

    public CardConst.PlayFormat getPlayFormat() {
        return this.playFormat;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.buttonLeave.setOnAction(null);
        this.textWaiting.stopAnimation();
        if (Player.getCurrentRoom() == this.getRoom()) {
            Player.setCurrentRoom(null);
            UI.getTabRooms().getControls().getControlsCreate().setRoomCreationEnabled(true);
            UI.getTabRooms().getControls().setDeckLoadButtonEnabled(true);
            UserAttentionNotifier.notifyUser(true, UI.getTabRooms());
        }
    }
}

