/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.rooms;

import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import open.batoru.core.Disposable;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UsernameDisplay;
import open.batoru.ui.rooms.RoomsControlsOpen;

public class OpenRoomPlayerEntry
extends HBox
implements Disposable {
    private final String username;
    private final Button buttonOpen;

    public OpenRoomPlayerEntry(RoomsControlsOpen controls, String username) {
        this.username = username;
        UsernameDisplay usernameDisplay = new UsernameDisplay(username, Orientation.HORIZONTAL);
        this.setSpacing(10.0);
        this.setAlignment(Pos.CENTER_LEFT);
        this.buttonOpen = new Button(LanguageParser.getString("UI_ROOM_START_GAME_BUTTON"));
        this.getChildren().addAll((Object[])new Node[]{this.buttonOpen, usernameDisplay});
        this.buttonOpen.setOnAction(e -> controls.onActionRoomGameStart(username));
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public void dispose() {
        this.buttonOpen.setOnAction(null);
    }
}

