/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.rooms;

import java.io.File;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import open.batoru.core.Game;
import open.batoru.core.rooms.Room;
import open.batoru.data.CardConst;
import open.batoru.networking.service.GameDataDownloadService;
import open.batoru.parsers.LanguageParser;
import open.batoru.replays.ReplayDataParser;
import open.batoru.replays.ReplayStartProcedure;
import open.batoru.replays.UtilReplays;
import open.batoru.ui.rooms.LiveGameEntry;

public class RecentGameEntry
extends LiveGameEntry {
    private static boolean isDownloadingReplayData;
    private final Button buttonSave;

    public RecentGameEntry(String[] data, Room room) {
        super(room);
        String checksum = data[0];
        int gameId = Integer.parseInt(data[5]);
        boolean isWin = Boolean.parseBoolean(data[8]);
        HBox content = new HBox();
        content.setSpacing(5.0);
        Text textGameId = new Text("#" + gameId);
        content.getChildren().add((Object)textGameId);
        StackPane.setAlignment((Node)content, (Pos)Pos.TOP_LEFT);
        this.getContent().getChildren().addFirst((Object)content);
        this.getContent().getChildren().addFirst((Object)UtilReplays.createReplayEntryGradientBackground(isWin));
        room.getTurnCountProperty().set(Integer.parseInt(data[7]));
        room.getPlayerData(Game.GamePlayerRole.HOST).getLRIGCenterImageProperty().set((Object)data[9]);
        room.getPlayerData(Game.GamePlayerRole.HOST).getLRIGAssistLeftImageProperty().set((Object)data[10]);
        room.getPlayerData(Game.GamePlayerRole.HOST).getLRIGAssistRightImageProperty().set((Object)data[11]);
        room.getPlayerData(Game.GamePlayerRole.GUEST).getLRIGCenterImageProperty().set((Object)data[12]);
        room.getPlayerData(Game.GamePlayerRole.GUEST).getLRIGAssistLeftImageProperty().set((Object)data[13]);
        room.getPlayerData(Game.GamePlayerRole.GUEST).getLRIGAssistRightImageProperty().set((Object)data[14]);
        room.getPlayerData(Game.GamePlayerRole.HOST).getLifeClothCountProperty().set(Integer.parseInt(data[15]));
        room.getPlayerData(Game.GamePlayerRole.GUEST).getLifeClothCountProperty().set(Integer.parseInt(data[16]));
        room.getPlayerData(Game.GamePlayerRole.HOST).getKeysImagesProperty().set((Object)data[17]);
        room.getPlayerData(Game.GamePlayerRole.GUEST).getKeysImagesProperty().set((Object)data[18]);
        this.setOnMouseClicked(e -> {
            if (isDownloadingReplayData || !UtilReplays.canWatchGames()) {
                return;
            }
            isDownloadingReplayData = true;
            GameDataDownloadService service = new GameDataDownloadService(checksum, pathTemp -> {
                isDownloadingReplayData = false;
                if (!UtilReplays.canWatchGames()) {
                    return;
                }
                ReplayDataParser parser = new ReplayDataParser(pathTemp);
                parser.parse();
                ReplayStartProcedure.play(parser);
                Game.getCurrentGame().setSourceReplayChecksum(checksum);
            });
            service.start();
        });
        this.buttonSave = new Button(LanguageParser.getString("UI_GAME_MESSAGE_END_BUTTON_REPLAY_DOWNLOAD"));
        this.buttonSave.setFont(Font.font((double)10.0));
        this.buttonSave.setOnAction(e2 -> {
            if (isDownloadingReplayData) {
                return;
            }
            File newFile = UtilReplays.showSaveReplayDialog(gameId);
            if (newFile == null) {
                return;
            }
            isDownloadingReplayData = true;
            GameDataDownloadService service = new GameDataDownloadService(checksum, pathTemp -> {
                isDownloadingReplayData = false;
                UtilReplays.saveReplay(pathTemp, newFile);
            });
            service.start();
        });
        this.buttonSave.visibleProperty().bind((ObservableValue)this.hoverProperty());
        StackPane.setAlignment((Node)this.buttonSave, (Pos)Pos.BOTTOM_RIGHT);
        StackPane.setMargin((Node)this.buttonSave, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        this.getContent().getChildren().add((Object)this.buttonSave);
        this.setOnMouseEntered(e -> {
            if (UtilReplays.canWatchGames()) {
                this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"highlight"), true);
            }
        });
        this.setOnMouseExited(e -> this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"highlight"), false));
    }

    @Override
    public void dispose() {
        super.dispose();
        this.buttonSave.setOnAction(null);
        this.buttonSave.visibleProperty().unbind();
    }

    public static Room prepareFakeRoom(String[] data) {
        Room room = new Room(0, 0, CardConst.PlayFormat.getPlayFormatById(Integer.parseInt(data[6])), Room.StartingPlayer.RANDOM, data[2]);
        room.getPlayerData(Game.GamePlayerRole.GUEST).setPlayerName(data[3]);
        return room;
    }
}

