/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.rooms;

import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import open.batoru.Settings;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.rooms.RoomsControlsCreate;
import open.batoru.ui.rooms.RoomsControlsOpen;

public class RoomsControls {
    private final VBox node = new VBox();
    private final RoomsControlsCreate controlsCreate = new RoomsControlsCreate();
    private final RoomsControlsOpen controlsOpen = new RoomsControlsOpen();
    private final TextField fieldCurrentDeck;
    private final Button buttonDeckLoad;
    private final Label labelOnlinePlayers = new Label(LanguageParser.getString("UI_ROOM_INFO_ONLINE") + " ?");
    private static final int DECK_BUTTON_WIDTH = 50;

    public RoomsControls() {
        this.node.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        this.node.setSpacing(10.0);
        VBox content = new VBox();
        content.setSpacing(10.0);
        content.getChildren().addAll((Object[])new Node[]{this.controlsCreate, this.controlsOpen});
        this.controlsOpen.setVisible(false);
        this.controlsOpen.setManaged(false);
        HBox containerDeck = new HBox();
        containerDeck.setAlignment(Pos.CENTER_LEFT);
        containerDeck.setSpacing(5.0);
        this.buttonDeckLoad = new Button(LanguageParser.getString("UI_ROOM_DECK_BUTTON_LOAD"));
        this.buttonDeckLoad.setMinSize(50.0, 25.0);
        this.buttonDeckLoad.setOnAction(e -> Settings.INSTANCE.loadDeckFile(Settings.DeckSource.PLAY));
        Label labelDeck = new Label(LanguageParser.getString("UI_ROOM_DECK_DISPLAY"));
        this.fieldCurrentDeck = new TextField(Settings.INSTANCE.getCurrentPlayDeck().getSourceFileName());
        this.fieldCurrentDeck.setDisable(true);
        this.fieldCurrentDeck.prefWidthProperty().bind((ObservableValue)this.node.widthProperty().subtract(50));
        containerDeck.getChildren().addAll((Object[])new Node[]{this.buttonDeckLoad, this.fieldCurrentDeck});
        this.node.getChildren().addAll((Object[])new Node[]{content, new Separator(), labelDeck, containerDeck, new Separator(), this.labelOnlinePlayers});
    }

    public void toggleRoomControls(boolean isInRoom) {
        this.controlsCreate.setVisible(!isInRoom);
        this.controlsCreate.setManaged(!isInRoom);
        this.controlsOpen.setVisible(isInRoom);
        this.controlsOpen.setManaged(isInRoom);
        if (!isInRoom) {
            this.controlsOpen.clearPlayers();
        }
    }

    public void updateOnlinePlayersCount(int count) {
        this.labelOnlinePlayers.setText(LanguageParser.getString("UI_ROOM_INFO_ONLINE") + " " + count);
    }

    public void updateCurrentDeckFileName() {
        this.updateCurrentDeckFileName(false);
    }

    public void updateCurrentDeckFileName(boolean showAsterisk) {
        this.fieldCurrentDeck.setText((showAsterisk ? "*" : "") + Settings.INSTANCE.getCurrentPlayDeck().getSourceFileName());
    }

    public void setDeckLoadButtonEnabled(boolean set) {
        this.buttonDeckLoad.setDisable(!set);
    }

    public boolean isDeckLoadButtonDisabled() {
        return this.buttonDeckLoad.isDisable();
    }

    public RoomsControlsCreate getControlsCreate() {
        return this.controlsCreate;
    }

    public RoomsControlsOpen getControlsOpen() {
        return this.controlsOpen;
    }

    public VBox getNode() {
        return this.node;
    }
}

