/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.rooms;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import open.batoru.Settings;
import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.rooms.Room;
import open.batoru.networking.GameReceiver;
import open.batoru.networking.connection.GameSendPlayerConnectAttempt;
import open.batoru.networking.connection.RoomAbandonAttempt;
import open.batoru.networking.connection.RoomGameSendDeckAttempt;
import open.batoru.networking.connection.RoomGameStartAttempt;
import open.batoru.networking.connection.RunnableConnection;
import open.batoru.networking.connection.TemporaryPacketRedirect;
import open.batoru.networking.service.UpdateProcedureService;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.ThinkingText;
import open.batoru.ui.UI;
import open.batoru.ui.UserAttentionNotifier;
import open.batoru.ui.UtilDispose;
import open.batoru.ui.deck.DeckCompatibilityService;
import open.batoru.ui.rooms.LiveGameEntry;
import open.batoru.ui.rooms.OpenRoomPlayerEntry;
import open.batoru.ui.rooms.RoomListEntry;

public class RoomsControlsOpen
extends VBox {
    private final VBox listPlayers = new VBox();
    private final Button buttonAbandon;
    private final ThinkingText textWaiting;

    public RoomsControlsOpen() {
        this.setSpacing(10.0);
        this.buttonAbandon = new Button(LanguageParser.getString("UI_ROOM_ABANDON_BUTTON"));
        this.buttonAbandon.setPrefHeight(25.0);
        this.buttonAbandon.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.buttonAbandon.setOnAction(e -> this.onActionRoomAbandon());
        this.listPlayers.setPadding(new Insets(5.0));
        this.listPlayers.setAlignment(Pos.CENTER_LEFT);
        this.listPlayers.setSpacing(5.0);
        ScrollPane scrollPlayers = new ScrollPane((Node)this.listPlayers);
        scrollPlayers.setFitToWidth(true);
        scrollPlayers.setMinHeight(145.0);
        scrollPlayers.getStyleClass().add((Object)"ui_rooms_panel");
        this.textWaiting = new ThinkingText(LanguageParser.getString("UI_ROOM_WAIT_PLAYERS"));
        this.textWaiting.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontPosture)FontPosture.ITALIC, (double)12.0));
        this.listPlayers.getChildren().add((Object)this.textWaiting);
        UtilDispose.PERM.attachChildDisposeListener((Node)this.listPlayers);
        this.getChildren().addAll((Object[])new Node[]{this.buttonAbandon, scrollPlayers});
    }

    public void addPlayer(String username) {
        if (this.listPlayers.getChildren().stream().anyMatch(node -> {
            OpenRoomPlayerEntry entry;
            return node instanceof OpenRoomPlayerEntry && (entry = (OpenRoomPlayerEntry)node).getUsername().equals(username);
        })) {
            return;
        }
        if (this.listPlayers.getChildren().size() == 1) {
            this.stopTextAnimation();
            this.listPlayers.getChildren().remove((Object)this.textWaiting);
        }
        this.listPlayers.getChildren().add((Object)new OpenRoomPlayerEntry(this, username));
        UserAttentionNotifier.notifyUser(true, username, UI.getTabRooms());
    }

    public void removePlayer(String username) {
        if (this.listPlayers.getChildren().removeIf(node -> {
            OpenRoomPlayerEntry entry;
            return node instanceof OpenRoomPlayerEntry && (entry = (OpenRoomPlayerEntry)node).getUsername().equals(username);
        }) && this.listPlayers.getChildren().isEmpty()) {
            this.listPlayers.getChildren().add((Object)this.textWaiting);
            this.startTextAnimation();
        }
    }

    public void clearPlayers() {
        this.listPlayers.getChildren().clear();
        this.listPlayers.getChildren().add((Object)this.textWaiting);
    }

    public void stopTextAnimation() {
        this.textWaiting.stopAnimation();
    }

    public void startTextAnimation() {
        this.textWaiting.playAnimation();
    }

    private void onActionRoomAbandon() {
        if (Player.getCurrentRoom() == null) {
            return;
        }
        this.buttonAbandon.setDisable(true);
        RunnableConnection connection = new RunnableConnection(RoomAbandonAttempt::new, (socketReceiver, pp, status) -> {
            if (status != RunnableConnection.ResponseStatus.SUCCESS) {
                if (status == RunnableConnection.ResponseStatus.TIMEOUT) {
                    new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_CONNECT_TIMEOUT_RETRY"), new ButtonType[0]).showAndWait();
                }
                this.buttonAbandon.setDisable(false);
                return;
            }
            Room currentRoom = Player.getCurrentRoom();
            UI.getTabRooms().getRoomListOpen().removeEntry(currentRoom.getRoomId());
            UI.getTabRooms().getRoomCoordinator().removeRoom(currentRoom.getRoomId());
            Player.setCurrentRoom(null);
            this.stopTextAnimation();
            UI.getTabRooms().getControls().toggleRoomControls(false);
            this.buttonAbandon.setDisable(false);
        });
        new Thread(connection).start();
    }

    public void onActionRoomGameStart(String usernameOP) {
        Room room = Player.getCurrentRoom();
        if (room == null) {
            return;
        }
        Settings.INSTANCE.reloadDeck(Settings.DeckSource.PLAY);
        DeckCompatibilityService service = new DeckCompatibilityService();
        Optional<String> message = service.getCompatibilityMessage(Settings.INSTANCE.getCurrentPlayDeck(), room.areUnreleasedCardsAllowed(), room.areRestrictedCardsAllowed(), room.getPlayFormat());
        if (message.isPresent()) {
            new Alert(Alert.AlertType.WARNING, message.get(), new ButtonType[0]).showAndWait();
            return;
        }
        UI.getTabGame().closeGame(false);
        Platform.runLater(() -> this.startGame(usernameOP));
    }

    private void startGame(String usernameOP) {
        Deck selectedPlayDeck = Settings.INSTANCE.getCurrentPlayDeck();
        this.setListControlsEnabled(false);
        RunnableConnection connection = new RunnableConnection(() -> new RoomGameStartAttempt(usernameOP), (socketReceiver, pp, status) -> {
            if (status != RunnableConnection.ResponseStatus.SUCCESS) {
                if (status == RunnableConnection.ResponseStatus.TIMEOUT) {
                    new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_CONNECT_TIMEOUT_RETRY"), new ButtonType[0]).showAndWait();
                }
                this.setListControlsEnabled(true);
                if (pp != null && pp.getPacketData().equals("!6")) {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION, LanguageParser.getString("UI_ALERT_UPDATE"), new ButtonType[]{ButtonType.YES, ButtonType.NO});
                    alert.setHeaderText(LanguageParser.getString("UI_ALERT_UPDATE_HEADER"));
                    alert.showAndWait();
                    if (((ButtonType)alert.getResult()).getButtonData() != ButtonBar.ButtonData.YES) {
                        return;
                    }
                    UpdateProcedureService updateProcedure = new UpdateProcedureService(null);
                    updateProcedure.runAutoUpdater();
                }
                return;
            }
            UI.getTabGame().prepareNewGame(Player.getUsername(), usernameOP);
            UI.getTabGame().getFieldSceneOverlay().showGameMessage(LanguageParser.getString("UI_GAME_MESSAGE_CONNECT_WAIT_OPPONENT"));
            TemporaryPacketRedirect redirectOP = new TemporaryPacketRedirect(Player.getNetworkFrame().getRoomsReceiver(), "GRS", (ppOP, statusOP) -> {
                if (statusOP != TemporaryPacketRedirect.RedirectResponseStatus.SUCCESS) {
                    if (statusOP == TemporaryPacketRedirect.RedirectResponseStatus.TIMEOUT) {
                        new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_CONNECT_TIMEOUT_OPPONENT"), new ButtonType[0]).showAndWait();
                    } else {
                        new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_CONNECT_OPPONENT"), new ButtonType[0]).showAndWait();
                    }
                    UI.getTabGame().closeGame();
                    this.setListControlsEnabled(true);
                    return;
                }
                UI.getTabGame().getFieldSceneOverlay().showGameMessage(LanguageParser.getString("UI_GAME_MESSAGE_CONNECT_DECK"));
                RoomListEntry entry = UI.getTabRooms().getRoomListOpen().getEntry(Player.getCurrentRoom().getRoomId());
                entry.hide();
                try {
                    RoomGameSendDeckAttempt attemptDeck = new RoomGameSendDeckAttempt(selectedPlayDeck);
                    RunnableConnection connectionDeck = new RunnableConnection(() -> attemptDeck, (socketReceiverDeck, ppDeck, statusDeck) -> {
                        if (statusDeck != RunnableConnection.ResponseStatus.SUCCESS) {
                            if (statusDeck == RunnableConnection.ResponseStatus.TIMEOUT) {
                                new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_CONNECT_TIMEOUT_RETRY"), new ButtonType[0]).showAndWait();
                            } else {
                                new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_CONNECT_DECK"), new ButtonType[0]).showAndWait();
                            }
                            UI.getTabGame().closeGame();
                            this.setListControlsEnabled(true);
                            entry.show();
                            return;
                        }
                        if (attemptDeck.prepareNextChunk()) {
                            attemptDeck.send();
                        } else {
                            UI.getTabGame().getFieldSceneOverlay().showGameMessage(LanguageParser.getString("UI_GAME_MESSAGE_CONNECT_WAIT_OPPONENT"));
                            TemporaryPacketRedirect redirectDeckOP = new TemporaryPacketRedirect(Player.getNetworkFrame().getRoomsReceiver(), "SET", (ppDeckOP, statusDeckOP) -> {
                                if (statusDeckOP != TemporaryPacketRedirect.RedirectResponseStatus.SUCCESS) {
                                    if (statusDeckOP == TemporaryPacketRedirect.RedirectResponseStatus.TIMEOUT) {
                                        new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_CONNECT_TIMEOUT_OPPONENT"), new ButtonType[0]).showAndWait();
                                    } else {
                                        new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_CONNECT_OPPONENT"), new ButtonType[0]).showAndWait();
                                    }
                                    UI.getTabGame().closeGame();
                                    this.setListControlsEnabled(true);
                                    entry.show();
                                    return;
                                }
                                if (Game.getCurrentGame() != null) {
                                    return;
                                }
                                UI.getTabGame().getFieldSceneOverlay().showGameMessage(LanguageParser.getString("UI_GAME_MESSAGE_CONNECT_SETUP"));
                                int portOffset = Integer.parseInt(ppDeckOP.getDataArgument(0));
                                int gameId = Integer.parseInt(ppDeckOP.getDataArgument(1));
                                Game game = new Game(portOffset, gameId, Game.GamePlayerRole.HOST, UI.getTabRooms().getRoomCoordinator().getRoom(Player.getCurrentRoom().getRoomId()));
                                Game.setCurrentGame(game);
                                UI.setTabInfo(UI.getTabGame(), UI.getTabInfo(UI.getTabGame()) + " [#" + gameId + "]");
                                RunnableConnection connectionGame = new RunnableConnection(() -> new GameSendPlayerConnectAttempt(portOffset), (socketReceiverGame, ppGame, statusGame) -> {
                                    if (statusGame != RunnableConnection.ResponseStatus.SUCCESS) {
                                        if (statusGame == RunnableConnection.ResponseStatus.TIMEOUT) {
                                            new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_CONNECT_TIMEOUT_RETRY"), new ButtonType[0]).showAndWait();
                                        } else {
                                            new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_CONNECT_START_GAME"), new ButtonType[0]).showAndWait();
                                        }
                                        UI.getTabGame().closeGame();
                                        this.setListControlsEnabled(true);
                                        entry.show();
                                        return;
                                    }
                                    if (Game.getCurrentGame().getGameState() != Game.GameState.CONNECTING) {
                                        return;
                                    }
                                    Game.getCurrentGame().setGameState(Game.GameState.GAME_SETUP);
                                    UI.getTabRooms().getRoomListOpen().removeEntry(Player.getCurrentRoom().getRoomId());
                                    game.getRoom().getPlayerData(Game.GamePlayerRole.HOST).setPlayerName(Player.getUsername());
                                    game.getRoom().getPlayerData(Game.GamePlayerRole.GUEST).setPlayerName(usernameOP);
                                    LiveGameEntry gameEntry = new LiveGameEntry(game.getRoom());
                                    UI.getTabRooms().getRoomListLive().addEntry(gameEntry);
                                    gameEntry.select();
                                    UI.getTabGame().initNewGame();
                                    Player.getNetworkFrame().startGameReceiver(new GameReceiver(socketReceiverGame, portOffset));
                                    Game.getCurrentGame().initStartActions();
                                });
                                new Thread(connectionGame).start();
                            });
                            redirectDeckOP.activate();
                        }
                    });
                    new Thread(connectionDeck).start();
                }
                catch (SocketException | UnknownHostException ex) {
                    System.err.println(ex.getMessage());
                }
            });
            redirectOP.activate();
        });
        new Thread(connection).start();
    }

    public void setListControlsEnabled(boolean isEnabled) {
        this.buttonAbandon.setDisable(!isEnabled);
        this.listPlayers.setDisable(!isEnabled);
    }
}

