/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.rooms;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import open.batoru.Settings;
import open.batoru.core.Player;
import open.batoru.core.rooms.RoomCoordinator;
import open.batoru.networking.HTTPFileReader;
import open.batoru.parsers.LanguageParser;
import open.batoru.replays.ReplayDataParser;
import open.batoru.ui.UI;
import open.batoru.ui.UITab;
import open.batoru.ui.UtilDispose;
import open.batoru.ui.rooms.RecentGameEntry;
import open.batoru.ui.rooms.RoomList;
import open.batoru.ui.rooms.RoomListEntry;
import open.batoru.ui.rooms.RoomsControls;
import open.batoru.ui.rooms.SavedGameEntry;

public class UITabRooms
extends UITab
implements UI.Selectable {
    private final RoomCoordinator coordinator = new RoomCoordinator();
    private final StackPane tabContent = new StackPane();
    private final RoomList roomListLive = new RoomList();
    private final RoomList roomListOpen = new RoomList();
    private final RoomsControls controls = new RoomsControls();
    private final RoomList roomListRecent = new RoomList();
    private final Tab tabSaved;
    private final RoomList roomListSaved = new RoomList();

    public UITabRooms() {
        TabPane tabGames = new TabPane();
        tabGames.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        tabGames.setSide(Side.LEFT);
        ScrollPane scrollLive = new ScrollPane((Node)this.roomListLive);
        scrollLive.setFitToWidth(true);
        scrollLive.setFitToHeight(true);
        scrollLive.getStyleClass().add((Object)"ui_rooms_panel");
        Tab tabLive = new Tab("\u26ab " + LanguageParser.getString("UI_ROOM_TAB_LIVE"), (Node)scrollLive);
        tabLive.setStyle("-fx-text-base-color: red;");
        ScrollPane scrollRecent = new ScrollPane((Node)this.roomListRecent);
        scrollRecent.setFitToWidth(true);
        scrollRecent.setFitToHeight(true);
        scrollRecent.getStyleClass().add((Object)"ui_rooms_panel");
        Tab tabRecent = new Tab(LanguageParser.getString("UI_ROOM_TAB_RECENT"), (Node)scrollRecent);
        tabRecent.selectedProperty().addListener((ov, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.updateRecentGamesList();
            }
        });
        ScrollPane scrollSaved = new ScrollPane((Node)this.roomListSaved);
        scrollSaved.setFitToWidth(true);
        scrollSaved.setFitToHeight(true);
        scrollSaved.getStyleClass().add((Object)"ui_rooms_panel");
        this.tabSaved = new Tab(LanguageParser.getString("UI_ROOM_TAB_SAVED"), (Node)scrollSaved);
        this.tabSaved.selectedProperty().addListener((ov, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.updateSavedReplaysList();
            }
        });
        this.showInitialSavedReplaysCount();
        tabGames.getTabs().addAll((Object[])new Tab[]{tabLive, tabRecent, this.tabSaved});
        ScrollPane scrollRooms = new ScrollPane((Node)this.roomListOpen);
        scrollRooms.setFitToWidth(true);
        scrollRooms.setFitToHeight(true);
        scrollRooms.getStyleClass().add((Object)"ui_rooms_panel");
        HBox content = new HBox();
        content.setPadding(new Insets(5.0));
        tabGames.setMinWidth(490.0);
        this.controls.getNode().setMinWidth(240.0);
        tabGames.prefWidthProperty().bind((ObservableValue)content.widthProperty().multiply(0.3));
        scrollRooms.prefWidthProperty().bind((ObservableValue)content.widthProperty().multiply(0.45));
        this.controls.getNode().prefWidthProperty().bind((ObservableValue)content.widthProperty().multiply(0.25));
        UtilDispose.PERM.attachChildDisposeListener((Node)this.roomListLive.getContent());
        UtilDispose.PERM.attachChildDisposeListener((Node)this.roomListOpen.getContent());
        UtilDispose.PERM.attachChildDisposeListener((Node)this.roomListRecent.getContent());
        UtilDispose.PERM.attachChildDisposeListener((Node)this.roomListSaved.getContent());
        content.getChildren().addAll((Object[])new Node[]{tabGames, scrollRooms, this.controls.getNode()});
        this.tabContent.getChildren().add((Object)content);
        this.addToTab((Node)this.tabContent, UITab.Position.CENTER, new Insets(10.0, 5.0, 10.0, 5.0));
    }

    public StackPane getTabContent() {
        return this.tabContent;
    }

    private void showInitialSavedReplaysCount() {
        try (Stream<Path> stream = Files.walk(Path.of("./replays", new String[0]), new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".replay"));){
            this.setSavedReplaysCount((int)stream.count());
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    private void updateSavedReplaysList() {
        this.roomListSaved.clearAllEntries();
        ArrayList<SavedGameEntry> list = new ArrayList<SavedGameEntry>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Path.of("./replays", new String[0]), "*.replay");){
            for (Path path : stream) {
                ReplayDataParser parser = new ReplayDataParser(path);
                parser.parse();
                if (parser.getLastParseResult() == ReplayDataParser.ParseResult.FAILED_TO_READ || parser.getLastParseResult() == ReplayDataParser.ParseResult.INVALID_FORMAT) continue;
                SavedGameEntry entry2 = new SavedGameEntry(parser, SavedGameEntry.prepareFakeRoom(parser));
                list.add(entry2);
            }
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        if (!list.isEmpty()) {
            list.sort(Comparator.comparingInt(SavedGameEntry::getGameId));
            list.forEach(entry -> this.roomListSaved.addEntry((RoomListEntry)entry, false));
        }
        this.setSavedReplaysCount(list.size());
    }

    private void setSavedReplaysCount(int count) {
        if (count > 0) {
            this.tabSaved.setText(LanguageParser.getString("UI_ROOM_TAB_SAVED") + " [" + count + "]");
            this.tabSaved.setStyle("-fx-text-base-color: green;");
        } else {
            this.tabSaved.setText(LanguageParser.getString("UI_ROOM_TAB_SAVED"));
            this.tabSaved.setStyle("");
        }
    }

    public void updateRecentGamesList() {
        this.roomListRecent.setLock(true);
        new Thread(() -> {
            HTTPFileReader reader = new HTTPFileReader();
            Stream<String> stream = reader.read("https://open.batoru.moe/game/service/recent_games");
            Platform.runLater(() -> {
                if (stream != null) {
                    this.roomListRecent.clearAllEntries();
                    stream.forEach(line -> {
                        String[] data = line.split("\\|", -1);
                        if (data.length < 17) {
                            return;
                        }
                        try {
                            String version = data[1];
                            if (!Settings.INSTANCE.getGameVersionClient().equals(version)) {
                                return;
                            }
                            RecentGameEntry entry = new RecentGameEntry(data, RecentGameEntry.prepareFakeRoom(data));
                            this.roomListRecent.addEntry(entry);
                        }
                        catch (IllegalArgumentException ex) {
                            System.err.println(ex.getMessage());
                        }
                    });
                }
                this.roomListRecent.setLock(false);
            });
        }).start();
    }

    public void sortLiveGames() {
        this.roomListLive.sortEntries((e1, e2) -> {
            if (e2.getRoom().areSpectatorsAllowed() && !e1.getRoom().areSpectatorsAllowed()) {
                return 1;
            }
            if (!e2.getRoom().areSpectatorsAllowed() && e1.getRoom().areSpectatorsAllowed()) {
                return -1;
            }
            return Integer.compare(e2.getRoom().getSpectatorCountProperty().getValue(), e1.getRoom().getSpectatorCountProperty().getValue());
        });
    }

    @Override
    public void onSelected() {
        Player.getNetworkFrame().getRoomsReceiver().startQuery();
    }

    @Override
    public void onDeselected() {
    }

    public void setLock(boolean set) {
        this.roomListLive.setLock(set);
        this.roomListOpen.setLock(set);
    }

    public RoomCoordinator getRoomCoordinator() {
        return this.coordinator;
    }

    public RoomList getRoomListLive() {
        return this.roomListLive;
    }

    public RoomList getRoomListOpen() {
        return this.roomListOpen;
    }

    public RoomsControls getControls() {
        return this.controls;
    }
}

