/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.settings;

import java.util.Locale;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.Slider;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.util.StringConverter;
import open.batoru.Settings;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.ThemeController;
import open.batoru.ui.UI;
import open.batoru.ui.UITab;

public class UITabSettings
extends UITab
implements UI.Selectable {
    private static final double ANI_SPEED_MIN = 0.15;
    private static final double ANI_SPEED_MAX = 0.55;
    private final VBox content = new VBox();
    private final Slider sliderAniSpeed;

    public UITabSettings() {
        this.content.setFillWidth(true);
        this.content.setPadding(new Insets(10.0));
        this.content.setMinWidth(800.0);
        this.content.setMaxWidth(800.0);
        this.content.setSpacing(15.0);
        ComboBox boxLanguage = new ComboBox(LanguageParser.OPTION_LANGUAGES);
        boxLanguage.getSelectionModel().select((Object)boxLanguage.getItems().stream().filter(string -> string.startsWith(Settings.INSTANCE.getGameLanguage())).findFirst().orElse(""));
        boxLanguage.valueProperty().addListener((ov, oldValue, newValue) -> Settings.INSTANCE.setGameLanguage(newValue.substring(0, newValue.indexOf(" "))));
        this.addSetting(LanguageParser.getString("UI_SETTINGS_LANGUAGE"), (Control)boxLanguage);
        this.sliderAniSpeed = new Slider(0.15, 0.55, Math.max(0.15, Math.min(0.55, 0.7000000000000001 - Settings.INSTANCE.getAnimationSpeed())));
        this.sliderAniSpeed.setShowTickLabels(true);
        this.sliderAniSpeed.setShowTickMarks(true);
        this.sliderAniSpeed.setSnapToTicks(true);
        this.sliderAniSpeed.setMinorTickCount(3);
        this.sliderAniSpeed.setMajorTickUnit((double)0.2f);
        this.sliderAniSpeed.setLabelFormatter((StringConverter)new StringConverter<Double>(this){

            public String toString(Double aDouble) {
                return aDouble == 0.15 ? LanguageParser.getString("UI_SETTINGS_SPEED_SLOWER") : (aDouble == 0.55 ? LanguageParser.getString("UI_SETTINGS_SPEED_FASTER") : "");
            }

            public Double fromString(String s) {
                return null;
            }
        });
        this.addSetting(LanguageParser.getString("UI_SETTINGS_SPEED"), (Control)this.sliderAniSpeed);
        CheckBox checkBoxUseDarkTheme = new CheckBox();
        checkBoxUseDarkTheme.setSelected(Settings.INSTANCE.isUsingDarkTheme());
        checkBoxUseDarkTheme.setOnAction(e -> {
            Settings.INSTANCE.setUseDarkTheme(checkBoxUseDarkTheme.isSelected());
            ThemeController.applyTheme(checkBoxUseDarkTheme.isSelected());
        });
        this.addSetting(LanguageParser.getString("UI_SETTINGS_DARK_THEME"), (Control)checkBoxUseDarkTheme);
        CheckBox checkBoxAlwaysShowImageSetInPreview = new CheckBox();
        checkBoxAlwaysShowImageSetInPreview.setSelected(Settings.INSTANCE.shouldAlwaysShowImageSetInPreview());
        checkBoxAlwaysShowImageSetInPreview.setOnAction(e -> {
            Settings.INSTANCE.setShouldAlwaysShowImageSetInPreview(checkBoxAlwaysShowImageSetInPreview.isSelected());
            UI.getTabDeck().getCardPreview().updateCardImageSetTextVisibility(checkBoxAlwaysShowImageSetInPreview.isSelected());
            if (UI.getTabGame().getFieldSceneOverlay() != null) {
                UI.getTabGame().getFieldSceneOverlay().getCardPreview().updateCardImageSetTextVisibility(checkBoxAlwaysShowImageSetInPreview.isSelected());
            }
        });
        this.addSetting(LanguageParser.getString("UI_SETTINGS_SHOW_IMAGESET"), (Control)checkBoxAlwaysShowImageSetInPreview);
        CheckBox checkBoxPlayPhaseAnimation = new CheckBox();
        checkBoxPlayPhaseAnimation.setSelected(Settings.INSTANCE.shouldPlayPhaseAnimation());
        checkBoxPlayPhaseAnimation.setOnAction(e -> Settings.INSTANCE.setShouldPlayPhaseAnimation(checkBoxPlayPhaseAnimation.isSelected()));
        this.addSetting(LanguageParser.getString("UI_SETTINGS_ANI_PHASE"), (Control)checkBoxPlayPhaseAnimation);
        CheckBox checkBoxAutoSaveReplays = new CheckBox();
        checkBoxAutoSaveReplays.setSelected(Settings.INSTANCE.shouldAutoSaveReplays());
        checkBoxAutoSaveReplays.setOnAction(e -> Settings.INSTANCE.setShouldAutoSaveReplays(checkBoxAutoSaveReplays.isSelected()));
        this.addSetting(LanguageParser.getString("UI_SETTINGS_REPLAY_SAVE"), (Control)checkBoxAutoSaveReplays);
        this.addSeparator();
        CheckBox checkBoxAutoConfirmSIGNIPlacement = new CheckBox();
        checkBoxAutoConfirmSIGNIPlacement.setSelected(Settings.INSTANCE.shouldAutoConfirmSIGNIPlacement());
        checkBoxAutoConfirmSIGNIPlacement.setOnAction(e -> Settings.INSTANCE.setShouldAutoConfirmSIGNIPlacement(checkBoxAutoConfirmSIGNIPlacement.isSelected()));
        this.addSetting(LanguageParser.getString("UI_SETTINGS_CONFIRM_SIGNI"), (Control)checkBoxAutoConfirmSIGNIPlacement);
        CheckBox checkBoxAutoConfirmSpellUsage = new CheckBox();
        checkBoxAutoConfirmSpellUsage.setSelected(Settings.INSTANCE.shouldAutoConfirmSpellUsage());
        checkBoxAutoConfirmSpellUsage.setOnAction(e -> Settings.INSTANCE.setShouldAutoConfirmSpellUsage(checkBoxAutoConfirmSpellUsage.isSelected()));
        this.addSetting(LanguageParser.getString("UI_SETTINGS_CONFIRM_SPELL"), (Control)checkBoxAutoConfirmSpellUsage);
        CheckBox checkBoxAutoConfirmActionActivation = new CheckBox();
        checkBoxAutoConfirmActionActivation.setSelected(Settings.INSTANCE.shouldAutoConfirmActionActivation());
        checkBoxAutoConfirmActionActivation.setOnAction(e -> Settings.INSTANCE.setShouldAutoConfirmActionActivation(checkBoxAutoConfirmActionActivation.isSelected()));
        this.addSetting(LanguageParser.getString("UI_SETTINGS_CONFIRM_ACTION"), (Control)checkBoxAutoConfirmActionActivation);
        CheckBox checkBoxAutoConfirmLRIGDeckUsage = new CheckBox();
        checkBoxAutoConfirmLRIGDeckUsage.setSelected(Settings.INSTANCE.shouldAutoConfirmUseFromLRIGDeck());
        checkBoxAutoConfirmLRIGDeckUsage.setOnAction(e -> Settings.INSTANCE.setShouldAutoConfirmUseFromLRIGDeck(checkBoxAutoConfirmLRIGDeckUsage.isSelected()));
        this.addSetting(LanguageParser.getString("UI_SETTINGS_CONFIRM_LRIG"), (Control)checkBoxAutoConfirmLRIGDeckUsage);
        CheckBox checkBoxAutoConfirmChosenCards = new CheckBox();
        checkBoxAutoConfirmChosenCards.setSelected(Settings.INSTANCE.shouldAutoConfirmChosenCards());
        checkBoxAutoConfirmChosenCards.setOnAction(e -> Settings.INSTANCE.setShouldAutoConfirmChosenCards(checkBoxAutoConfirmChosenCards.isSelected()));
        this.addSetting(LanguageParser.getString("UI_SETTINGS_CONFIRM_TARGET"), (Control)checkBoxAutoConfirmChosenCards);
        CheckBox checkBoxAutoSkipSIGNIAttackPhase = new CheckBox();
        checkBoxAutoSkipSIGNIAttackPhase.setSelected(Settings.INSTANCE.shouldAutoSkipSIGNIAttackPhase());
        checkBoxAutoSkipSIGNIAttackPhase.setOnAction(e -> Settings.INSTANCE.setShouldAutoSkipSIGNIAttackPhase(checkBoxAutoSkipSIGNIAttackPhase.isSelected()));
        this.addSetting(LanguageParser.getString("UI_SETTINGS_SKIP_SIGNI"), (Control)checkBoxAutoSkipSIGNIAttackPhase);
        CheckBox checkBoxAutoSkipLRIGAttackPhase = new CheckBox();
        checkBoxAutoSkipLRIGAttackPhase.setSelected(Settings.INSTANCE.shouldAutoSkipLRIGAttackPhase());
        checkBoxAutoSkipLRIGAttackPhase.setOnAction(e -> Settings.INSTANCE.setShouldAutoSkipLRIGAttackPhase(checkBoxAutoSkipLRIGAttackPhase.isSelected()));
        this.addSetting(LanguageParser.getString("UI_SETTINGS_SKIP_LRIG"), (Control)checkBoxAutoSkipLRIGAttackPhase);
        this.addSeparator();
        this.addTitle(LanguageParser.getString("UI_SETTINGS_NOTIFY"));
        CheckBox checkBoxNotifyWindowFlash = new CheckBox();
        checkBoxNotifyWindowFlash.setSelected(Settings.INSTANCE.isNotificationWindowFlashEnabled());
        checkBoxNotifyWindowFlash.setOnAction(e -> Settings.INSTANCE.setNotificationWindowFlashEnabled(checkBoxNotifyWindowFlash.isSelected()));
        this.addSetting("- " + LanguageParser.getString("UI_SETTINGS_NOTIFY_WINDOW_FLASH"), (Control)checkBoxNotifyWindowFlash);
        CheckBox checkBoxNotifyAlertSound = new CheckBox();
        checkBoxNotifyAlertSound.setSelected(Settings.INSTANCE.isNotificationAlertSoundEnabled());
        checkBoxNotifyAlertSound.setOnAction(e -> Settings.INSTANCE.setNotificationAlertSoundEnabled(checkBoxNotifyAlertSound.isSelected()));
        this.addSetting("- " + LanguageParser.getString("UI_SETTINGS_NOTIFY_ALERT_SOUND"), (Control)checkBoxNotifyAlertSound);
        this.addToTab((Node)this.content, UITab.Position.CENTER, new Insets(5.0));
    }

    private void addSetting(String labelText, Control control) {
        BorderPane row = new BorderPane();
        Label label = new Label(labelText);
        label.setWrapText(true);
        label.setMinWidth(400.0);
        label.setMaxWidth(400.0);
        row.setLeft((Node)label);
        row.setCenter((Node)control);
        BorderPane.setAlignment((Node)control, (Pos)Pos.CENTER_LEFT);
        this.content.getChildren().add((Object)row);
    }

    private void addTitle(String title) {
        Label label = new Label(title);
        label.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontPosture)FontPosture.ITALIC, (double)12.0));
        this.content.getChildren().add((Object)label);
    }

    private void addSeparator() {
        this.content.getChildren().add((Object)new Separator());
    }

    @Override
    public void onSelected() {
    }

    @Override
    public void onDeselected() {
        Settings.INSTANCE.getParser().updateValue("ANI_SPEED", String.format(Locale.ENGLISH, "%.2f", 0.7000000000000001 - this.sliderAniSpeed.getValue()));
        Settings.INSTANCE.getParser().writeSettings();
    }
}

