/*
 * Decompiled with CFR 0.152.
 */
package obupdate.ui;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;

public class ProgressPanel
extends VBox {
    private final Button buttonUpdate = new Button("Update");
    private final List<LockableProgressBar> bars = new ArrayList<LockableProgressBar>();
    private final ProgressBar overallProgressBar = new ProgressBar(0.0);
    private final Text textOverallProgress;
    private int completedOperations;
    private int totalOperations;

    public ProgressPanel() {
        this.setPadding(new Insets(5.0));
        this.setSpacing(10.0);
        this.buttonUpdate.setDisable(true);
        this.buttonUpdate.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.getChildren().add((Object)this.buttonUpdate);
        for (int i = 0; i < 4; ++i) {
            LockableProgressBar bar = new LockableProgressBar();
            bar.prefWidthProperty().bind((ObservableValue)this.widthProperty());
            this.bars.add(bar);
            this.getChildren().add((Object)bar);
        }
        StackPane panelOverallProgress = new StackPane();
        this.textOverallProgress = new Text("0 / 0");
        this.textOverallProgress.setFont(Font.font((String)"sans-serif", (FontWeight)FontWeight.BOLD, (double)20.0));
        this.overallProgressBar.setMinHeight(40.0);
        this.overallProgressBar.setStyle("-fx-accent: limegreen;");
        this.overallProgressBar.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        panelOverallProgress.getChildren().addAll((Object[])new Node[]{this.overallProgressBar, this.textOverallProgress});
        VBox.setVgrow((Node)panelOverallProgress, (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)panelOverallProgress);
    }

    public void updateOverallProgress(int numCompleted, int numTotal) {
        this.textOverallProgress.setText(numCompleted + " / " + numTotal);
        this.completedOperations = 0;
        this.totalOperations = numTotal;
    }

    public void incrementOverallProgress() {
        this.textOverallProgress.setText(++this.completedOperations + " / " + this.totalOperations);
        this.overallProgressBar.setProgress((double)this.completedOperations / (double)this.totalOperations);
    }

    public Button getUpdateButton() {
        return this.buttonUpdate;
    }

    public void prepareProgressBars() {
        this.bars.forEach(bar -> bar.setProgress(-1.0));
    }

    public void stopProgressBars() {
        this.bars.forEach(bar -> bar.setProgress(0.0));
    }

    public synchronized LockableProgressBar getNextFreeProgressBar() {
        return this.bars.stream().filter(bar -> !bar.isLocked()).findFirst().orElse(null);
    }

    public static class LockableProgressBar
    extends ProgressBar {
        private boolean isLocked;

        public LockableProgressBar() {
            super(0.0);
        }

        public void setLocked(boolean set) {
            this.isLocked = set;
        }

        public boolean isLocked() {
            return this.isLocked;
        }
    }
}

