/*
 * Decompiled with CFR 0.152.
 */
package obupdate.ui.operations;

import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;

public class OperationEntry
extends HBox {
    private final Text text;
    private final String originalText;

    public OperationEntry(String textString) {
        this.setSpacing(10.0);
        this.text = new Text(textString);
        this.getChildren().add((Object)this.text);
        this.originalText = this.text.getText();
    }

    public void updateProgress(double percent, long existingFileSize, long fileSize) {
        this.text.setText(this.originalText + " (" + OperationEntry.formatBytes(existingFileSize) + "/" + OperationEntry.formatBytes(fileSize) + ") [" + String.format("%.2f", percent) + "%]");
    }

    public void markAsWorking() {
        this.text.setFill((Paint)Color.GREY);
    }

    public void markAsCompleted() {
        this.text.setFill((Paint)Color.GREEN);
    }

    public void markAsFailed() {
        this.text.setFill((Paint)Color.RED);
    }

    private static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.2f kB", (double)bytes / 1024.0);
        }
        return String.format("%.2f MB", (double)bytes / 1048576.0);
    }
}

