/*
 * Decompiled with CFR 0.152.
 */
package obupdate.update;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import obupdate.Main;
import obupdate.update.UpdateParser;
import obupdate.update.operations.UpdateOperation;

public class UpdateProcessor {
    private Thread processorThread;
    private final UpdateParser parser;
    private final ExecutorService exec = Executors.newFixedThreadPool(4);

    public UpdateProcessor(UpdateParser parser) {
        this.parser = parser;
    }

    public void start() {
        if (this.processorThread != null) {
            return;
        }
        this.processorThread = new Thread(() -> {
            if (!this.parser.getDownloadOperations().isEmpty()) {
                CountDownLatch latch = new CountDownLatch(this.parser.getDownloadOperations().size());
                this.parser.getDownloadOperations().forEach(operation -> this.exec.submit(() -> operation.run(latch)));
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.parser.getMiscOperations().forEach(operation -> this.exec.submit(() -> operation.run(null)));
            this.end();
        });
        this.processorThread.start();
    }

    private void end() {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        try {
            scheduler.scheduleAtFixedRate(() -> {
                if (this.exec.isTerminated()) {
                    boolean hasFailedEntries;
                    Platform.runLater(() -> Main.getUI().getProgressPanel().stopProgressBars());
                    boolean bl = hasFailedEntries = this.parser.getDownloadOperations().stream().anyMatch(UpdateOperation::hasFailed) || this.parser.getMiscOperations().stream().anyMatch(UpdateOperation::hasFailed);
                    if (!hasFailedEntries) {
                        try {
                            Main.getJarReader().updateJar(Main.getUpdateParser().getLatestVersion());
                            Platform.runLater(() -> {
                                Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Update completed successfully!\nWould you like to run Open!batoru?", new ButtonType[]{ButtonType.YES, ButtonType.NO});
                                alert.setHeaderText("Success!");
                                alert.showAndWait().ifPresent(result -> {
                                    if (result.getButtonData() == ButtonBar.ButtonData.YES) {
                                        this.runClient();
                                    } else {
                                        Platform.exit();
                                    }
                                });
                            });
                        }
                        catch (IOException ex) {
                            Platform.runLater(() -> {
                                new Alert(Alert.AlertType.ERROR, "Failed to repackage jar!\n" + ex.getMessage(), new ButtonType[0]).showAndWait();
                                Platform.exit();
                            });
                        }
                    } else {
                        Platform.runLater(() -> {
                            new Alert(Alert.AlertType.ERROR, "Update failed!\nSome operations couldn't complete successfully.", new ButtonType[0]).showAndWait();
                            Platform.exit();
                        });
                    }
                    scheduler.shutdown();
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        }
        finally {
            this.exec.shutdown();
        }
    }

    public void runClient() {
        try {
            ProcessBuilder builder = System.getProperty("os.name").startsWith("Win") ? new ProcessBuilder("cmd.exe", "/c", "start", "LAUNCH.bat") : new ProcessBuilder("nohup", "./launch.sh");
            Process process = builder.start();
            System.exit(0);
        }
        catch (IOException ex) {
            new Alert(Alert.AlertType.ERROR, ex.getMessage(), new ButtonType[0]).showAndWait();
        }
    }
}

