/*
 * Decompiled with CFR 0.152.
 */
package obupdate.update.operations;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import javafx.scene.control.ProgressBar;
import obupdate.Main;
import obupdate.update.operations.DownloadUpdateOperation;
import obupdate.update.operations.UpdateOperation;
import obupdate.web.HTTPFileDownloader;

public class CardDownloadOperation
extends DownloadUpdateOperation {
    private ProgressBar progressBar;

    public CardDownloadOperation(String version, String path) {
        super(version, path + ".java");
    }

    @Override
    public HTTPFileDownloader.OnDownloadCompletedHandler getOnDownloadCompletedHandler() {
        return isSuccessful -> {
            try {
                Path targetPath = Path.of(this.getTemporaryPath().toString().replace("downloads" + File.separatorChar + "temp" + File.separatorChar, ""), new String[0]);
                Files.move(this.getTemporaryPath(), targetPath, StandardCopyOption.REPLACE_EXISTING);
                Path targetPathCompiled = Path.of(Main.getGameDirectory() + "cards/compiled/open/batoru/data/cards/" + this.getPath().replace(".java", ".class"), new String[0]);
                Path targetPathCompiled2 = Path.of(Main.getGameDirectory() + "cards/compiled/open/batoru/data/cards/" + this.getPath().replace(".java", "$IndexedInstance.class"), new String[0]);
                Files.deleteIfExists(targetPathCompiled);
                Files.deleteIfExists(targetPathCompiled2);
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
                this.setAsCompleted(UpdateOperation.OperationStatus.FAIL);
                return;
            }
            this.setAsCompleted(isSuccessful ? UpdateOperation.OperationStatus.SUCCESS : UpdateOperation.OperationStatus.FAIL);
        };
    }

    @Override
    public Path getTemporaryPath() {
        return Paths.get(Main.getGameDirectory() + "downloads/temp/cards/" + this.getPath(), new String[0]);
    }
}

