/*
 * Decompiled with CFR 0.152.
 */
package obupdate.update.operations;

import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import obupdate.Main;
import obupdate.ui.operations.OperationEntry;

public abstract class UpdateOperation {
    private OperationEntry entry;
    private boolean hasFailed;
    private OnOperationCompletedHandler handler;

    public abstract void exec();

    public void setOnOperationCompleted(OnOperationCompletedHandler handler) {
        this.handler = handler;
    }

    public void setAsCompleted(OperationStatus status) {
        if (this.handler != null) {
            Platform.runLater(() -> this.handler.handle(status));
        }
    }

    public void addUIOperation(String data) {
        this.entry = new OperationEntry(data);
        Main.getUI().getOperationList().addOperation(this.entry);
    }

    public void removeUIOperation() {
        Main.getUI().getOperationList().removeOperation(this.entry);
    }

    public void startUIOperation() {
        this.entry.markAsWorking();
    }

    public void completeUIOperation() {
        this.entry.markAsCompleted();
    }

    public void failUIOperation() {
        this.entry.markAsFailed();
        this.hasFailed = true;
    }

    public boolean hasFailed() {
        return this.hasFailed;
    }

    public void updateEntryProgress(double percent, long existingFileSize, long fileSize) {
        this.entry.updateProgress(percent, existingFileSize, fileSize);
    }

    public void run(CountDownLatch latch) {
        Platform.runLater(this::startUIOperation);
        this.setOnOperationCompleted(status -> {
            if (status == OperationStatus.SUCCESS) {
                this.completeUIOperation();
            } else {
                this.failUIOperation();
            }
            Main.getUI().getOperationList().scrollTo(this.entry);
            if (latch != null) {
                latch.countDown();
            }
        });
        this.exec();
    }

    @FunctionalInterface
    public static interface OnOperationCompletedHandler {
        public void handle(OperationStatus var1);
    }

    public static enum OperationStatus {
        SUCCESS,
        FAIL;

    }
}

