package open.batoru.data.cards;

import open.batoru.core.Deck.DeckPosition;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.GameConst.CardLocation;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.pickers.TargetFilter.TargetHint;
import open.batoru.core.gameplay.rulechecks.RuleCheck.RuleCheckState;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry.PlayerRuleCheckType;
import open.batoru.data.Card;
import open.batoru.data.CardConst.CardColor;
import open.batoru.data.CardConst.CardType;
import open.batoru.data.CardConst.PlayFormat;
import open.batoru.data.CardConst.UseTiming;
import open.batoru.data.Cost;
import open.batoru.data.ability.ConstantAbility;
import open.batoru.data.ability.cost.ExceedCost;
import open.batoru.data.ability.modifiers.PlayerRuleCheckModifier;
import open.batoru.data.ability.stock.StockPlayerAbilityLRIGBarrier;
import open.batoru.game.gfx.GFX;
import open.batoru.game.gfx.GFXCardCutout;
import open.batoru.game.gfx.GFXTrackedCardDecorator;

public final class ARTS_W_WhiteDestruct extends Card {

    public ARTS_W_WhiteDestruct()
    {
        setImageSets("WX25-P3-001");

        setOriginalName("ホワイト・ディストラクト");
        setAltNames("ホワイトディストラクト Howaito Desutorukuto");
        setDescription("jp",
                "あなたのデッキの上からカードを５枚見る。その中からカードを１枚まで手札に加え、残りを好きな順番でデッキの一番下に置く。【ルリグバリア】１つを得る。\n" +
                "&E４枚以上@0その後、追加でエクシード３を支払ってもよい。そうした場合、対戦相手のシグニ１体を対象とし、それを手札に戻す。このターンと次のターンの間、対戦相手はそれと同じ名前のシグニを新たに場に出せない。"
        );

        setName("en", "White Destruct");
        setDescription("en",
                "Look at the top 5 cards of your deck. Add up to 1 card from among them to your hand, and put the rest on the bottom of your deck in any order. Gain 1 [[LRIG Barrier]].\n" +
                "&E4 or more@0 Then, you may pay an additional @[Exceed 3]@. If you do, target 1 of your opponent's SIGNI, and return it to their hand. During this turn and the next turn, your opponent can't newly put SIGNI with the same name as that SIGNI onto the field."
        );

        setType(CardType.ARTS);
        setColor(CardColor.WHITE);
        setCost(Cost.color(CardColor.WHITE, 1));
        setUseTiming(UseTiming.MAIN);

        setPlayFormat(PlayFormat.KEY, PlayFormat.DIVA);
    }

    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        public IndexedInstance(int cardId)
        {
            super(cardId);
            
            registerARTSAbility(this::onARTSEff).setRecollect(4);
        }

        private void onARTSEff()
        {
            look(5);
            
            CardIndex cardIndex = playerTargetCard(0,1, new TargetFilter(TargetHint.HAND).own().fromLooked()).get();
            addToHand(cardIndex);
            
            returnToDeckOrdered(CardLocation.LOOKED, DeckPosition.BOTTOM);

            attachPlayerAbility(getOwner(), new StockPlayerAbilityLRIGBarrier(), ChronoDuration.permanent());
            
            if(getAbility().isRecollectFulfilled() && pay(new ExceedCost(3)))
            {
                CardIndex target = playerTargetCard(new TargetFilter(TargetHint.HAND).OP().SIGNI()).get();
                
                if(target != null)
                {
                    addToHand(target);
                    
                    String name = target.getCardReference().getOriginalName();
                    ConstantAbility attachedConst = new ConstantAbility(
                        new PlayerRuleCheckModifier<>(PlayerRuleCheckType.CAN_NEWLY_PUT_SIGNI_ON_FIELD, TargetFilter.HINT_OWNER_OP, data ->
                            data.getSourceCardIndex().getCardReference().getOriginalName().equals(name) ? RuleCheckState.BLOCK : RuleCheckState.IGNORE
                        )
                    );
                    GFX.attachToAbility(attachedConst, new GFXTrackedCardDecorator(getOpponent(), new TargetFilter().SIGNI().withName(name).anyLocation(), cardIndexOP ->
                        new GFXCardCutout(cardIndexOP, "fracture")
                    ));
                    attachPlayerAbility(getOwner(), attachedConst, ChronoDuration.turnEnd().repeat(2));
                }
            }
        }
    }
}
