package open.batoru.data.cards;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.GameConst.CardLocation;
import open.batoru.core.gameplay.GameConst.GameEventId;
import open.batoru.core.gameplay.GameConst.GamePhase;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.Card;
import open.batoru.data.CardConst.*;
import open.batoru.data.Cost;
import open.batoru.data.ability.Ability.AbilityFlag;
import open.batoru.data.ability.AbilityCondition.ConditionState;
import open.batoru.data.ability.AbilityConst.UseLimit;
import open.batoru.data.ability.ActionAbility;
import open.batoru.data.ability.AutoAbility;
import open.batoru.data.ability.cost.EnerCost;
import open.batoru.data.ability.events.EventMove;
import open.batoru.data.ability.stock.StockPlayerAbilityMikomikoBodyguard;

public final class LRIG_B3_MikoMikoThreeThreeStanStan extends Card {

    public LRIG_B3_MikoMikoThreeThreeStanStan()
    {
        setImageSets("WX25-P3-023");
        setLinkedImageSets(Token_MikomikoBodyguard.IMAGE_SET);

        setOriginalName("みこみこ☆さんさんおせおせ");
        setAltNames("ミコミコサンサノセオセ Mikomiko Sansan Oseose");
        setDescription("jp",
                "@U $T2：あなたのシグニ１体がアタックしたとき、あなたの場に＜微菌＞のシグニがある場合、以下の２つから１つを選ぶ。\n" +
                "$$1 対戦相手は手札を１枚捨てる。\n" +
                "$$2 対戦相手は【みこみこ親衛隊】１つを得る。\n" +
                "@A $G1 @[@|永遠♡不滅☆宣言|@]@ %B0：このターンと次のターンの間、グロウフェイズ以外で対戦相手の効果１つによってカードが合計１枚以上対戦相手の手札に移動したとき、対戦相手の手札を１枚見ないで選び、捨てさせる。"
        );

        setName("en", "Mikomiko☆Three Three Stan Stan");
        setDescription("en",
                "@U $T2: When 1 of your SIGNI attacks, if there is a <<Bacteria>> SIGNI on your field, @[@|choose 1 of the following:|@]@\n" +
                "$$1 Your opponent discards 1 card from their hand.\n" +
                "$$2 Your opponent gains 1 [[Mikomiko Bodyguard]].\n" +
                "@A $G1 @[@|Eternal♡Immortal☆Declaration|@]@ %B0: During this turn and the next turn, when 1 or more cards are moved to your opponent's hand due to one of your opponent's effects, except during the grow phase, choose 1 card from your opponent's hand without looking, and discard it."
        );

        setType(CardType.LRIG);
        setLRIGTeam(CardLRIGTeam.KYURUKYURUN);
        setLRIGType(CardLRIGType.MIKOMIKO);
        setColor(CardColor.BLUE);
        setCost(Cost.color(CardColor.BLUE, 2));
        setLevel(3);
        setLimit(6);

        setPlayFormat(PlayFormat.KEY, PlayFormat.DIVA);
    }

    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        public IndexedInstance(int cardId)
        {
            super(cardId);

            AutoAbility auto = registerAutoAbility(GameEventId.ATTACK, this::onAutoEff);
            auto.setCondition(this::onAutoEffCond);
            auto.setUseLimit(UseLimit.TURN, 2);

            ActionAbility act = registerActionAbility(new EnerCost(Cost.color(CardColor.BLUE, 0)), this::onActionEff);
            act.setUseLimit(UseLimit.GAME, 1);
            act.setName("EternalImmortalDeclaration");
        }

        private ConditionState onAutoEffCond(CardIndex caller)
        {
            return isOwnCard(caller) && CardType.isSIGNI(caller.getCardReference().getType()) ? ConditionState.OK : ConditionState.BAD;
        }
        private void onAutoEff(CardIndex caller)
        {
            if(new TargetFilter().own().SIGNI().withClass(CardSIGNIClass.BACTERIA).getValidTargetsCount() > 0)
            {
                if(playerChoiceMode() == 1)
                {
                    discard(getOpponent(), 1);
                } else {
                    attachPlayerAbility(getOpponent(), new StockPlayerAbilityMikomikoBodyguard(), ChronoDuration.permanent());
                }
            }
        }

        private void onActionEff()
        {
            AutoAbility attachedAuto = new AutoAbility(GameEventId.MOVE, this::onAttachedAutoEff);
            attachedAuto.setCondition(this::onAttachedAutoEffCond);
            attachedAuto.getFlags().addValue(AbilityFlag.ACTIVE_ONCE_PER_EFFECT);
            
            attachPlayerAbility(getOwner(), attachedAuto, ChronoDuration.turnEnd().repeat(2));
        }
        private ConditionState onAttachedAutoEffCond(CardIndex caller)
        {
            return !isOwnTurn() && !isOwnCard(caller) && EventMove.getDataMoveLocation() == CardLocation.HAND &&
                    getEvent().getSourceAbility() != null && !isOwnCard(getEvent().getSource()) && getEvent().isAtOnce(1) &&
                    getCurrentPhase() != GamePhase.GROW ? ConditionState.OK : ConditionState.BAD;
        }
        private void onAttachedAutoEff(CardIndex caller)
        {
            CardIndex cardIndex = playerChoiceHand().get();
            discard(cardIndex);
        }
    }
}

