package open.batoru.data.cards;

import open.batoru.data.Card;
import open.batoru.data.CardConst.CardColor;
import open.batoru.data.CardConst.CardLRIGType;
import open.batoru.data.CardConst.CardType;
import open.batoru.data.CardConst.PlayFormat;
import open.batoru.data.Cost;
import open.batoru.data.ability.cost.CoinCost;

public final class LRIG_G2_MidorikoGoldenGirlTypeTwo extends Card {

    public LRIG_G2_MidorikoGoldenGirlTypeTwo()
    {
        setImageSets("WDK03-003");

        setOriginalName("二型金娘　翠子");
        setAltNames("ニガタキンキミドリコ Nigata Kinki Midoriko");
        setDescription("jp",
                "@E #C：カードを１枚引く。"
        );

        setName("en", "Midoriko, Golden Girl Type Two");
        setDescription("en",
                "@E #C: Draw 1 card."
        );

        setName("es", "Midoriko, Niña Dorada de Tipo Dos.");
        setDescription("es",
                "@E #C: Roba 1 carta."
        );

        setName("zh_simplified", "二型金娘 翠子");
        setDescription("zh_simplified", 
                "@E #C:抽1张牌。"
        );

        setLRIGType(CardLRIGType.MIDORIKO);
        setType(CardType.LRIG);
        setColor(CardColor.GREEN);
        setCost(Cost.color(CardColor.GREEN, 1));
        setLevel(2);
        setLimit(4);

        setPlayFormat(PlayFormat.KEY);
    }

    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        public IndexedInstance(int cardId)
        {
            super(cardId);

            registerEnterAbility(new CoinCost(1), this::onEnterEff);
        }

        private void onEnterEff()
        {
            draw(1);
        }
    }
}
