package open.batoru.data.cards;

import open.batoru.core.Deck.DeckPosition;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst.CardLocation;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.pickers.TargetFilter.TargetHint;
import open.batoru.data.Card;
import open.batoru.data.CardConst.CardSIGNIClass;
import open.batoru.data.CardConst.CardType;
import open.batoru.data.CardConst.PlayFormat;
import open.batoru.data.CardConst.UseTiming;

public final class PIECE_X_GeneralStudentCouncil extends Card {

    public PIECE_X_GeneralStudentCouncil()
    {
        setImageSets("WXDi-CP02-005");

        setOriginalName("連邦生徒会");
        setAltNames("レンポウセイトカイ Renpouseitokai");
        setDescription("jp",
                "あなたのデッキの上からカードを３枚見る。その中から＜ブルアカ＞のシグニ１枚を公開し手札に加え、残りを好きな順番でデッキの一番下に置く。この方法で公開した生徒との絆を獲得する。"
        );

        setName("en", "General Student Council");
        setDescription("en",
                "Look at the top three cards of your deck. Reveal a <<Blue Archive>> SIGNI from among them and add it to your hand. Put the rest on the bottom of your deck in any order. Start a relationship with the student revealed this way. "
        );

        setName("es", "Consejo General de Estudiantes");
        setDescription("es",
                "Mira 3 cartas del tope de tu mazo. Revela 1 SIGNI <<Blue Archive>> de entre ellas y agregala a tu mano. Pon el resto en el fondo del mazo en cualquier orden. Gana un lazo con la estudiante revelada de esta forma."
        );
        
        setName("en_fan", "General Student Council");
        setDescription("en_fan",
                "Look at the top 3 cards of your deck. Reveal 1 <<Blue Archive>> SIGNI from among them, add it to your hand, and put the rest on the bottom of your deck in any order. Gain a bond with the student revealed this way."
        );

        setName("zh_simplified", "联邦学生会");
        setDescription("zh_simplified", 
                "从你的牌组上面看3张牌。从中把<<蔚蓝档案>>精灵1张公开加入手牌，剩下的任意顺序放置到牌组最下面。获得与这个方法公开的学生的羁绊。（那名学生的[羁绊]能力变为有效）"
        );

        setType(CardType.PIECE);
        setUseTiming(UseTiming.MAIN);

        setPlayFormat(PlayFormat.KEY, PlayFormat.DIVA, PlayFormat.ENGLISH);
    }

    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        public IndexedInstance(int cardId)
        {
            super(cardId);

            registerPieceAbility(this::onPieceEff);
        }
        
        private void onPieceEff()
        {
            look(3);

            CardIndex cardIndex = playerTargetCard(0,1, new TargetFilter(TargetHint.HAND).own().SIGNI().withClass(CardSIGNIClass.BLUE_ARCHIVE).fromLooked()).get();
            reveal(cardIndex);
            addToHand(cardIndex);

            returnToDeckOrdered(CardLocation.LOOKED, DeckPosition.BOTTOM);

            if(cardIndex != null) gainBond(cardIndex.getImageSet());
        }
    }
}
