package open.batoru.data.cards;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.GameConst.CardLocation;
import open.batoru.core.gameplay.ChronoRecordScheduler.ChronoRecord;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.pickers.TargetFilter.TargetHint;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry.CardRuleCheckType;
import open.batoru.data.Card;
import open.batoru.data.CardConst.*;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityConst.ChoiceLogic;
import open.batoru.data.ability.AbilityCondition.ConditionState;
import open.batoru.data.ability.cost.DiscardCost;
import open.batoru.data.ability.modifiers.AbilityGainModifier;
import open.batoru.data.ability.stock.StockAbilityShadow;
import open.batoru.game.gfx.GFX;
import open.batoru.game.gfx.GFXCardTextureLayer;
import open.batoru.game.gfx.GFXTextureCardCanvas;

public final class SIGNI_B1_FutaseMemoriaAzureBeauty extends Card {
    
    public SIGNI_B1_FutaseMemoriaAzureBeauty()
    {
        setImageSets("WXDi-P06-062", "WXDi-P06-062P");
        
        setOriginalName("蒼美　ふたせ//メモリア");
        setAltNames("ソウビフタセメモリア Soubi Futase Memoria");
        setDescription("jp",
                "@C：対戦相手のターンの間、あなたの手札の枚数が対戦相手の手札の枚数以上であるかぎり、このシグニは[[シャドウ（レベル２以下のシグニ）]]を得る。" +
                "~#：対戦相手のルリグかシグニ１体を対象とする。このターン、それがアタックしたとき、対戦相手が手札を３枚捨てないかぎり、そのアタックを無効にする。"
        );
        
        setName("en", "Futase//Memoria, Azure Beauty");
        setDescription("en",
                "@C: During your opponent's turn, as long as the number of cards in your hand is greater than or equal to the cards in your opponent's hand, this SIGNI gains [[Shadow -- Level two or less SIGNI]]. " +
                "~#Whenever target LRIG or SIGNI on your opponent's field attacks this turn, negate that attack unless your opponent discards three cards."
        );

        setName("es", "Futase//Memoria, Primor Indigo");
        setDescription("es",
                "@C: Durante el turno oponente, mientras el numero de cartas en tu mano sea igual o mayor al de tu oponente, esta SIGNI gana [[Shadow (SIGNI nivel 2 o menor)]]" +
                "~#Selecciona 1 LRIG o SIGNI oponente. Este turno, siempre que esa carta ataque, niega ese ataque a menos que tu oponente descarte 3 cartas."
        );
        
        setName("en_fan", "Futase//Memoria, Azure Beauty");
        setDescription("en_fan",
                "@C: During your opponent's turn, while the number of cards in your hand is equal to or more than the number of cards in your opponent's hand, this SIGNI gains [[Shadow (level 2 or lower SIGNI)]]." +
                "~#Target 1 of your opponent's LRIG or SIGNI. This turn, whenever it attacks, disable that attack unless your opponent discards 3 cards from their hand."
        );

        setName("zh_simplified", "苍美 二濑//回忆");
        setDescription("zh_simplified", 
                "@C :对战对手的回合期间，你的手牌的张数在对战对手的手牌的张数以上时，这只精灵得到[[暗影（等级2以下的精灵）]]。" +
                "~#对战对手的分身或精灵1只作为对象。这个回合，当其攻击时，如果对战对手不把手牌3张舍弃，那么那次攻击无效。"
        );
        
        setCardFlags(CardFlag.LIFEBURST);
        
        setType(CardType.SIGNI);
        setColor(CardColor.BLUE);
        setSIGNIClass(CardSIGNIClassGeneration.PERFORMER, CardSIGNIClass.BEAUTY);
        setLevel(1);
        setPower(3000);
        
        setPlayFormat(PlayFormat.KEY, PlayFormat.DIVA, PlayFormat.ENGLISH, PlayFormat.CHINESE);
    }
    
    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        public IndexedInstance(int cardId)
        {
            super(cardId);
            
            registerConstantAbility(this::onConstEffCond, new AbilityGainModifier(this::onConstEffModGetSample));
            
            registerLifeBurstAbility(this::onLifeBurstEff);
        }
        
        private ConditionState onConstEffCond()
        {
            return !isOwnTurn() && getHandCount(getOwner()) >= getHandCount(getOpponent()) ? ConditionState.OK : ConditionState.BAD;
        }
        private Ability onConstEffModGetSample(CardIndex cardIndex)
        {
            return cardIndex.getIndexedInstance().registerStockAbility(new StockAbilityShadow(this::onAttachedStockEffAddCond));
        }
        private ConditionState onAttachedStockEffAddCond(CardIndex cardIndexSource)
        {
            return CardType.isSIGNI(cardIndexSource.getCardReference().getType()) &&
                   cardIndexSource.getIndexedInstance().getLevel().getValue() <= 2 ? ConditionState.OK : ConditionState.BAD;
        }
        
        private void onLifeBurstEff()
        {
            CardIndex target = playerTargetCard(new TargetFilter(TargetHint.ABILITY).OP().fromField()).get();

            if(target != null)
            {
                ChronoRecord record = new ChronoRecord(target, ChronoDuration.turnEnd());
                GFX.attachToChronoRecord(record, new GFXCardTextureLayer(target, new GFXTextureCardCanvas("border/discard", 0.75,3)));
                addCardRuleCheck(CardRuleCheckType.COST_TO_LAND_ATTACK, target, record, data -> new DiscardCost(0,3, ChoiceLogic.BOOLEAN));
            }
        }
    }
}
