package open.batoru.data.cards;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.pickers.TargetFilter.TargetHint;
import open.batoru.data.Card;
import open.batoru.data.CardConst.*;
import open.batoru.data.ability.cost.DownCost;
import open.batoru.data.ability.DamageBlockParams;

public final class SIGNI_G1_GlazeVerdantBeauty extends Card {

    public SIGNI_G1_GlazeVerdantBeauty()
    {
        setImageSets("WX24-P3-081");

        setOriginalName("翠美　グレーズ");
        setAltNames("スイビグレーズ Suibi Gureezu");
        setDescription("jp",
                "@A #D：あなたの＜美巧＞のシグニ１体を対象とし、次の対戦相手のターン終了時まで、それのパワーを＋5000する。" +
                "~#：【エナチャージ１】をする。このターン、次にあなたがシグニによってダメージを受ける場合、代わりにダメージを受けない。"
        );

        setName("en", "Glaze, Verdant Beauty");
        setDescription("en",
                "@A #D: Target 1 of your <<Beautiful Technique>> SIGNI, and until the end of your opponent's next turn, it gets +5000 power." +
                "~#[[Ener Charge 1]]. This turn, the next time you would be damaged by a SIGNI, instead you aren't damaged."
        );

        setName("zh_simplified", "翠美 釉画");
        setDescription("zh_simplified", 
                "@A #D:你的<<美巧>>精灵1只作为对象，直到下一个对战对手的回合结束时为止，其的力量+5000。" +
                "~#[[能量填充1]]。这个回合，下一次你因为精灵受到伤害的场合，作为替代，不会受到伤害。"
        );

        setCardFlags(CardFlag.LIFEBURST);

        setType(CardType.SIGNI);
        setColor(CardColor.GREEN);
        setSIGNIClass(CardSIGNIClassGeneration.PERFORMER, CardSIGNIClass.BEAUTY);
        setLevel(1);
        setPower(3000);

        setPlayFormat(PlayFormat.KEY, PlayFormat.DIVA);
    }

    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        // Contributed by NebelTal
        public IndexedInstance(int cardId)
        {
            super(cardId);

            registerActionAbility(new DownCost(), this::onActionEff);

            registerLifeBurstAbility(this::onLifeBurstEff);
        }

        private void onActionEff()
        {
            CardIndex cardIndex = playerTargetCard(new TargetFilter(TargetHint.PLUS).own().SIGNI().withClass(CardSIGNIClass.BEAUTY)).get();
            gainPower(cardIndex, 5000, ChronoDuration.nextTurnEnd(getOpponent()));
        }

        private void onLifeBurstEff()
        {
            enerCharge(1);

            blockNextDamage(DamageBlockParams.ofSIGNI());
        }
    }
}
