package open.batoru.data.cards;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst.GameEventId;
import open.batoru.core.gameplay.GameConst.GamePhase;
import open.batoru.core.gameplay.GameLog;
import open.batoru.data.Card;
import open.batoru.data.CardConst.*;
import open.batoru.data.ability.AbilityCondition.ConditionState;
import open.batoru.data.ability.AutoAbility;
import open.batoru.data.ability.DamageBlockParams;

public final class SIGNI_G2_BurankoSecondWarPlay extends Card {

    public SIGNI_G2_BurankoSecondWarPlay()
    {
        setImageSets("WX25-P2-094");

        setOriginalName("弍ノ闘遊　ブランコ");
        setAltNames("ニノトウユウブランコ Ni no Touyuu Buranko");
        setDescription("jp",
                "@U：あなたのターン終了時、このターンにあなたの効果によってこのシグニが場に出ていた場合、【エナチャージ１】をする。" +
                "~#：【エナチャージ１】をする。このターン、次にあなたがルリグによってダメージを受ける場合、代わりにダメージを受けない。"
        );

        setName("en", "Buranko, Second War Play");
        setDescription("en",
                "@U: At the end of your turn, if this SIGNI entered the field by your effect this turn, [[Ener Charge 1]]." +
                "~#[[Ener Charge 1]]. This turn, the next time you would be damaged by a LRIG, instead you aren't damaged."
        );

        setName("zh_simplified", "贰之斗游 秋千");
        setDescription("zh_simplified", 
                "@U :你的回合结束时，这个回合因为你的效果把这只精灵出场的场合，[[能量填充1]]。" +
                "~#[[能量填充1]]。这个回合，下一次你因为分身受到伤害的场合，作为替代，不会受到伤害。"
        );

        setCardFlags(CardFlag.LIFEBURST);

        setType(CardType.SIGNI);
        setColor(CardColor.GREEN);
        setSIGNIClass(CardSIGNIClassGeneration.PERFORMER, CardSIGNIClass.PLAYGROUND);
        setLevel(2);
        setPower(5000);

        setPlayFormat(PlayFormat.KEY, PlayFormat.DIVA);
    }

    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        public IndexedInstance(int cardId)
        {
            super(cardId);

            AutoAbility auto = registerAutoAbility(GameEventId.PHASE_START, this::onAutoEff);
            auto.setCondition(this::onAutoEffCond);

            registerLifeBurstAbility(this::onLifeBurstEff);
        }

        private ConditionState onAutoEffCond()
        {
            return isOwnTurn() && getCurrentPhase() == GamePhase.END ? ConditionState.OK : ConditionState.BAD;
        }
        private void onAutoEff(CardIndex caller)
        {
            if(GameLog.getTurnRecordsCount(event -> event.getId() == GameEventId.ENTER && event.getCaller().getInstanceId() == getInstanceId() && event.getSourceAbility() != null && isOwnCard(event.getSource())) > 0)
            {
                enerCharge(1);
            }
        }

        private void onLifeBurstEff()
        {
            enerCharge(1);

            blockNextDamage(DamageBlockParams.ofLRIG());
        }
    }
}
