package open.batoru.data.cards;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.GameConst.GameEventId;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.pickers.TargetFilter.TargetHint;
import open.batoru.data.Card;
import open.batoru.data.CardConst.*;
import open.batoru.data.ability.AbilityCondition.ConditionState;
import open.batoru.data.ability.AutoAbility;
import open.batoru.data.ability.events.EventPowerChanged;

public final class SIGNI_K3_DreiCleopatra extends Card {

    public SIGNI_K3_DreiCleopatra()
    {
        setImageSets("WX25-P3-062");
        setLinkedImageSets("WX25-P3-032");

        setOriginalName("ドライ=クレオパトラ");
        setAltNames("ドライクレオパトラ Dorei Kureopatora");
        setDescription("jp",
                "@U $TO：あなたの他の＜毒牙＞のシグニの効果によって対戦相手のシグニ１体のパワーが減ったとき、ターン終了時まで、このシグニのパワーを減った値と同じだけ＋（プラス）する。\n" +
                "@U：このシグニがアタックしたとき、あなたの場に《虚幸の冥者　ハナレ》がいる場合、対戦相手のシグニ１体を対象とし、あなたのエナゾーンから＜毒牙＞のシグニ１枚をトラッシュに置いてもよい。そうした場合、ターン終了時まで、それとこのシグニのパワーを－20000する。"
        );

        setName("en", "Drei-Cleopatra");
        setDescription("en",
                "@U $TO: When the power of 1 of your opponent's SIGNI is reduced by the effect of your other <<Venom Fang>> SIGNI, until end of turn, this SIGNI gets + (plus) power equal to that amount.\n" +
                "@U: Whenever this SIGNI attacks, if your LRIG is \"Hanare, Mourner of Empty Fortune\", target 1 of your opponent's SIGNI, and you may put 1 <<Venom Fang>> SIGNI from your ener zone into the trash. If you do, until end of turn, it and this SIGNI get --20000 power each."
        );

        setType(CardType.SIGNI);
        setColor(CardColor.BLACK);
        setSIGNIClass(CardSIGNIClassGeneration.PERFORMER, CardSIGNIClass.VENOM_FANG);
        setLevel(3);
        setPower(10000);

        setPlayFormat(PlayFormat.KEY, PlayFormat.DIVA);
    }

    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        public IndexedInstance(int cardId)
        {
            super(cardId);

            AutoAbility auto1 = registerAutoAbility(GameEventId.POWER_CHANGED, this::onAutoEff1);
            auto1.setCondition(this::onAutoEff1Cond);

            registerAutoAbility(GameEventId.ATTACK, this::onAutoEff2);
        }

        private ConditionState onAutoEff1Cond(CardIndex caller)
        {
            return isOwnTurn() && !isOwnCard(caller) && getEvent().getSourceAbility() != null && EventPowerChanged.getDataAddedValue() < 0 &&
                   getEvent().getSourceCardIndex() != getCardIndex() &&
                   isOwnCard(getEvent().getSource()) && CardType.isSIGNI(getEvent().getSource().getCardReference().getType()) &&
                   getEvent().getSource().getSIGNIClass().matches(CardSIGNIClass.VENOM_FANG) ? ConditionState.OK : ConditionState.BAD;
        }
        private void onAutoEff1(CardIndex caller)
        {
            gainPower(getCardIndex(), -EventPowerChanged.getDataAddedValue(), ChronoDuration.turnEnd());
        }

        private void onAutoEff2()
        {
            if(getLRIG(getOwner()).getIndexedInstance().getName().getValue().contains("虚幸の冥者　ハナレ"))
            {
                CardIndex target = playerTargetCard(new TargetFilter(TargetHint.MINUS).OP().SIGNI()).get();
                
                if(target != null)
                {
                    CardIndex cardIndex = playerTargetCard(0,1, new TargetFilter(TargetHint.TRASH).own().SIGNI().withClass(CardSIGNIClass.VENOM_FANG).fromEner()).get();
                    
                    if(trash(cardIndex))
                    {
                        gainPower(target, -20000, ChronoDuration.turnEnd());
                        gainPower(getCardIndex(), -20000, ChronoDuration.turnEnd());
                    }
                }
            }
        }
    }
}
